/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.pdf;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermFactory;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermNumeric;
import cz.vutbr.web.csskit.Color;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.BlockReplacedBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BrowserConfig;
import org.fit.cssbox.layout.Dimension;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.ReplacedContent;
import org.fit.cssbox.layout.ReplacedImage;
import org.fit.cssbox.layout.TextBox;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.layout.VisualContext;
import org.fit.pdfdom.BoxStyle;
import org.fit.pdfdom.PDFDomTree;
import org.fit.pdfdom.PathSegment;
import org.fit.pdfdom.TextMetrics;
import org.fit.pdfdom.resource.ImageResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class CSSBoxTree
extends PDFDomTree {
    private static Logger log = LoggerFactory.getLogger(PDFDomTree.class);
    protected float unknownFontScale = 0.95f;
    protected TermNumeric.Unit unit = TermNumeric.Unit.pt;
    protected VisualContext ctx;
    protected Dimension dim;
    protected URL baseurl;
    protected Viewport viewport;
    protected BlockBox html;
    protected BlockBox body;
    protected BlockBox pagebox;
    protected BrowserConfig config;
    protected int next_order;

    public CSSBoxTree(VisualContext ctx, Dimension dim, URL baseurl) throws IOException, ParserConfigurationException {
        this.ctx = ctx;
        this.dim = dim;
        this.baseurl = baseurl;
        this.init();
    }

    private void init() {
        this.next_order = 0;
    }

    public BrowserConfig getConfig() {
        return this.config;
    }

    public void setConfig(BrowserConfig config) {
        this.config = config;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public int getLastId() {
        return this.next_order;
    }

    public void processDocument(PDDocument pdfdocument, int startPage, int endPage) throws IOException {
        this.setStartPage(startPage);
        this.setEndPage(endPage);
        this.createDOM(pdfdocument);
    }

    protected void createDocument() throws ParserConfigurationException {
        super.createDocument();
        Element vp = this.createAnonymousElement(this.getDocument(), "Xdiv", "block");
        Element root = this.getDocument().getDocumentElement();
        this.viewport = new Viewport(vp, this.ctx, null, root, this.dim.width, this.dim.height);
        this.viewport.setConfig(this.config);
        this.html = this.createBlock((BlockBox)this.viewport, root, false);
        this.html.setStyle(this.createBlockStyle());
        this.viewport.addSubBox((Box)this.html);
        this.body = this.createBlock(this.html, (Element)root.getElementsByTagName("body").item(0), false);
        this.body.setStyle(this.createBodyStyle());
        this.html.addSubBox((Box)this.body);
    }

    protected void startNewPage() {
        super.startNewPage();
        this.pagebox = this.createBlock(this.body, this.curpage, false);
        this.pagebox.setStyle(this.createPageStyle());
        this.body.addSubBox((Box)this.pagebox);
    }

    protected void renderText(String data, TextMetrics metrics) {
        Element el = this.createTextElement(data, metrics.getWidth());
        this.curpage.appendChild(el);
        BlockBox block = this.createBlock(this.pagebox, el, false);
        block.setStyle(this.createTextStyle(this.curstyle, metrics.getWidth()));
        this.pagebox.addSubBox((Box)block);
        TextBox text = this.createTextBox(block, (Text)el.getFirstChild());
        block.addSubBox((Box)text);
    }

    protected void renderPath(List<PathSegment> path, boolean stroke, boolean fill) {
        float[] rect = this.toRectangle(path);
        if (rect != null) {
            Element el = this.createRectangleElement(rect[0], rect[1], rect[2] - rect[0], rect[3] - rect[1], stroke, fill);
            this.curpage.appendChild(el);
            BlockBox block = this.createBlock(this.pagebox, el, false);
            block.setStyle(this.createRectangleStyle(rect[0], rect[1], rect[2] - rect[0], rect[3] - rect[1], stroke, fill));
            this.pagebox.addSubBox((Box)block);
        } else if (stroke) {
            for (PathSegment segm : path) {
                Element el = this.createLineElement(segm.getX1(), segm.getY1(), segm.getX2(), segm.getY2());
                this.curpage.appendChild(el);
                BlockBox block = this.createBlock(this.pagebox, el, false);
                block.setStyle(this.createLineStyle(segm.getX1(), segm.getY1(), segm.getX2(), segm.getY2()));
                this.pagebox.addSubBox((Box)block);
            }
        }
    }

    protected void renderImage(float x, float y, float width, float height, ImageResource resource) throws IOException {
        Element el = this.createImageElement(x, y, width, height, resource);
        this.curpage.appendChild(el);
        BlockBox block = this.createBlock(this.pagebox, el, true);
        block.setStyle(this.createRectangleStyle(x, y, width, height, false, false));
        this.pagebox.addSubBox((Box)block);
    }

    protected Element createAnonymousElement(Document doc, String name, String display) {
        Element div = doc.createElement(name);
        div.setAttribute("class", "Xanonymous");
        div.setAttribute("style", "display:" + display);
        return div;
    }

    protected BlockBox createBlock(BlockBox parent, Element n, boolean replaced) {
        BlockBox root;
        if (replaced) {
            BlockReplacedBox rbox = new BlockReplacedBox(n, parent.getVisualContext().create());
            rbox.setViewport(this.viewport);
            ReplacedImage img = new ReplacedImage((ElementBox)rbox, rbox.getVisualContext(), this.baseurl, n.getAttribute("src"));
            if (this.config.getLoadImages()) {
                img.setImage(parent.getVisualContext().getImageLoader().loadImage(img.getUrl()));
            }
            rbox.setContentObj((ReplacedContent)img);
            root = rbox;
        } else {
            root = new BlockBox(n, parent.getVisualContext().create());
            root.setViewport(this.viewport);
        }
        root.setBase(this.baseurl);
        root.setParent((ElementBox)parent);
        root.setContainingBlockBox((ElementBox)parent);
        root.setClipBlock((BlockBox)this.viewport);
        root.setOrder(this.next_order++);
        return root;
    }

    protected TextBox createTextBox(BlockBox contblock, Text n) {
        TextBox text = new TextBox(n, contblock.getVisualContext().create());
        text.setOrder(this.next_order++);
        text.setContainingBlockBox((ElementBox)contblock);
        text.setClipBlock(contblock);
        text.setViewport(this.viewport);
        text.setBase(this.baseurl);
        return text;
    }

    protected NodeData createTextStyle(BoxStyle style, float width) {
        NodeData ret = CSSFactory.createNodeData();
        TermFactory tf = CSSFactory.getTermFactory();
        ret.push(this.createDeclaration("position", (Term<?>)tf.createIdent("absolute")));
        ret.push(this.createDeclaration("overflow", (Term<?>)tf.createIdent("hidden")));
        ret.push(this.createDeclaration("left", (Term<?>)tf.createLength(Float.valueOf(style.getLeft()), this.unit)));
        ret.push(this.createDeclaration("top", (Term<?>)tf.createLength(Float.valueOf(style.getTop()), this.unit)));
        ret.push(this.createDeclaration("line-height", (Term<?>)tf.createLength(Float.valueOf(style.getLineHeight()), this.unit)));
        if (style.getFontFamily() != null) {
            ret.push(this.createDeclaration("font-family", (Term<?>)tf.createString(style.getFontFamily())));
        }
        if (style.getFontSize() != 0.0f) {
            float size = style.getFontSize();
            if (style.getFontFamily() == null) {
                size *= this.unknownFontScale;
            }
            ret.push(this.createDeclaration("font-size", (Term<?>)tf.createLength(Float.valueOf(size), this.unit)));
        }
        if (style.getFontWeight() != null) {
            ret.push(this.createDeclaration("font-weight", (Term<?>)tf.createIdent(style.getFontWeight())));
        }
        if (style.getFontStyle() != null) {
            ret.push(this.createDeclaration("font-style", (Term<?>)tf.createIdent(style.getFontStyle())));
        }
        if (style.getWordSpacing() != 0.0f) {
            ret.push(this.createDeclaration("word-spacing", (Term<?>)tf.createLength(Float.valueOf(style.getWordSpacing()), this.unit)));
        }
        if (style.getLetterSpacing() != 0.0f) {
            ret.push(this.createDeclaration("letter-spacing", (Term<?>)tf.createLength(Float.valueOf(style.getLetterSpacing()), this.unit)));
        }
        if (style.getColor() != null) {
            boolean hasStrokeColor;
            String fillColor = style.getColor();
            boolean bl = hasStrokeColor = style.getStrokeColor() != null && fillColor.equals("rgba(0,0,0,0)");
            if (fillColor.equals("rgba(0,0,0,0)") && hasStrokeColor) {
                fillColor = style.getStrokeColor();
            }
            ret.push(this.createDeclaration("color", (Term<?>)CSSBoxTree.createTermColor(fillColor)));
        }
        ret.push(this.createDeclaration("width", (Term<?>)tf.createLength(Float.valueOf(width), this.unit)));
        return ret;
    }

    private static TermColor createTermColor(String color) {
        TermFactory tf = CSSFactory.getTermFactory();
        if (color.startsWith("rgba")) {
            color = color.replaceAll("rgba|\\)|\\(", "");
            String[] params = color.split(",");
            int[] colorValues = new int[params.length];
            for (int i = 0; i < params.length; ++i) {
                colorValues[i] = Integer.parseInt(params[i]);
            }
            TermColor termColor = tf.createColor(0, 0, 0);
            termColor.setValue((Object)new Color(colorValues[0], colorValues[1], colorValues[2], colorValues[3]));
            return termColor;
        }
        return tf.createColor(color);
    }

    protected NodeData createBlockStyle() {
        NodeData ret = CSSFactory.createNodeData();
        TermFactory tf = CSSFactory.getTermFactory();
        ret.push(this.createDeclaration("display", (Term<?>)tf.createIdent("block")));
        return ret;
    }

    protected NodeData createBodyStyle() {
        NodeData ret = this.createBlockStyle();
        TermFactory tf = CSSFactory.getTermFactory();
        ret.push(this.createDeclaration("background-color", (Term<?>)tf.createColor(255, 255, 255)));
        return ret;
    }

    protected NodeData createPageStyle() {
        NodeData ret = this.createBlockStyle();
        TermFactory tf = CSSFactory.getTermFactory();
        ret.push(this.createDeclaration("position", (Term<?>)tf.createIdent("relative")));
        ret.push(this.createDeclaration("border-width", (Term<?>)tf.createLength(Float.valueOf(1.0f), TermNumeric.Unit.px)));
        ret.push(this.createDeclaration("border-style", (Term<?>)tf.createIdent("solid")));
        ret.push(this.createDeclaration("border-color", (Term<?>)tf.createColor(0, 0, 255)));
        ret.push(this.createDeclaration("margin", (Term<?>)tf.createLength(Float.valueOf(0.5f), TermNumeric.Unit.em)));
        PDRectangle layout = this.getCurrentMediaBox();
        if (layout != null) {
            float w = layout.getWidth();
            float h = layout.getHeight();
            int rot = this.pdpage.getRotation();
            if (rot == 90 || rot == 270) {
                float x = w;
                w = h;
                h = x;
            }
            ret.push(this.createDeclaration("width", (Term<?>)tf.createLength(Float.valueOf(w), this.unit)));
            ret.push(this.createDeclaration("height", (Term<?>)tf.createLength(Float.valueOf(h), this.unit)));
            ret.push(this.createDeclaration("overflow-x", (Term<?>)tf.createIdent("hidden")));
            ret.push(this.createDeclaration("overflow-y", (Term<?>)tf.createIdent("hidden")));
        } else {
            log.warn("No media box found");
        }
        return ret;
    }

    protected NodeData createRectangleStyle(float x, float y, float width, float height, boolean stroke, boolean fill) {
        String color;
        float lineWidth = this.transformWidth(this.getGraphicsState().getLineWidth());
        float wcor = stroke ? lineWidth : 0.0f;
        float strokeOffset = wcor == 0.0f ? 0.0f : wcor / 2.0f;
        width = width - wcor < 0.0f ? 1.0f : width - wcor;
        height = height - wcor < 0.0f ? 1.0f : height - wcor;
        NodeData ret = CSSFactory.createNodeData();
        TermFactory tf = CSSFactory.getTermFactory();
        ret.push(this.createDeclaration("position", (Term<?>)tf.createIdent("absolute")));
        ret.push(this.createDeclaration("left", (Term<?>)tf.createLength(Float.valueOf(x - strokeOffset), this.unit)));
        ret.push(this.createDeclaration("top", (Term<?>)tf.createLength(Float.valueOf(y - strokeOffset), this.unit)));
        ret.push(this.createDeclaration("width", (Term<?>)tf.createLength(Float.valueOf(width), this.unit)));
        ret.push(this.createDeclaration("height", (Term<?>)tf.createLength(Float.valueOf(height), this.unit)));
        if (stroke) {
            ret.push(this.createDeclaration("border-width", (Term<?>)tf.createLength(Float.valueOf(lineWidth), this.unit)));
            ret.push(this.createDeclaration("border-style", (Term<?>)tf.createIdent("solid")));
            color = this.colorString(this.getGraphicsState().getStrokingColor());
            ret.push(this.createDeclaration("border-color", (Term<?>)tf.createColor(color)));
        }
        if (fill && (color = this.colorString(this.getGraphicsState().getNonStrokingColor())) != null) {
            ret.push(this.createDeclaration("background-color", (Term<?>)tf.createColor(color)));
        }
        return ret;
    }

    protected NodeData createLineStyle(float x1, float y1, float x2, float y2) {
        PDFDomTree.HtmlDivLine line = new PDFDomTree.HtmlDivLine((PDFDomTree)this, x1, y1, x2, y2);
        String bside = line.getBorderSide();
        NodeData ret = CSSFactory.createNodeData();
        TermFactory tf = CSSFactory.getTermFactory();
        ret.push(this.createDeclaration("position", (Term<?>)tf.createIdent("absolute")));
        ret.push(this.createDeclaration("position", (Term<?>)tf.createIdent("absolute")));
        ret.push(this.createDeclaration("left", (Term<?>)tf.createLength(Float.valueOf(line.getLeft()), this.unit)));
        ret.push(this.createDeclaration("top", (Term<?>)tf.createLength(Float.valueOf(line.getTop()), this.unit)));
        ret.push(this.createDeclaration("width", (Term<?>)tf.createLength(Float.valueOf(line.getWidth()), this.unit)));
        ret.push(this.createDeclaration("height", (Term<?>)tf.createLength(Float.valueOf(line.getHeight()), this.unit)));
        ret.push(this.createDeclaration(bside + "-width", (Term<?>)tf.createLength(Float.valueOf(line.getLineStrokeWidth()), this.unit)));
        ret.push(this.createDeclaration(bside + "-style", (Term<?>)tf.createIdent("solid")));
        String color = this.colorString(this.getGraphicsState().getStrokingColor());
        ret.push(this.createDeclaration(bside + "-color", (Term<?>)tf.createColor(color)));
        if (line.getAngleDegrees() != 0.0) {
            Term[] angle = new Term[]{tf.createAngle(String.valueOf(line.getAngleDegrees()), TermNumeric.Unit.deg, 1)};
            List<Term> args = Arrays.asList(angle);
            TermFunction rotate = tf.createFunction("rotate", args);
            ret.push(this.createDeclaration("transform", (Term<?>)rotate));
        }
        return ret;
    }

    protected Declaration createDeclaration(String property, Term<?> term) {
        Declaration d = CSSFactory.getRuleFactory().createDeclaration();
        d.unlock();
        d.setProperty(property);
        d.add(term);
        return d;
    }
}

