/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.pdf;

import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.fit.cssbox.awt.GraphicsEngine;
import org.fit.cssbox.awt.GraphicsVisualContext;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.css.FontTable;
import org.fit.cssbox.layout.BrowserConfig;
import org.fit.cssbox.layout.Dimension;
import org.fit.cssbox.layout.Rectangle;
import org.fit.cssbox.layout.VisualContext;
import org.fit.cssbox.pdf.CSSBoxTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PdfEngine
extends GraphicsEngine {
    private static Logger log = LoggerFactory.getLogger(PdfEngine.class);
    protected PDDocument pdfdocument;
    protected int startPage;
    protected int endPage;
    protected boolean pdfLoaded = false;
    protected CSSBoxTree boxtree;

    public PdfEngine(Element root, DOMAnalyzer decoder, Dimension dim, URL baseurl) {
        super(root, decoder, dim, baseurl);
    }

    public PdfEngine(PDDocument document, int startPage, int endPage, DOMAnalyzer decoder, Dimension dim, URL baseurl) {
        super(null, decoder, dim, baseurl);
        this.pdfdocument = document;
        this.startPage = startPage;
        this.endPage = endPage;
        this.createPdfLayout(dim);
        this.pdfLoaded = true;
    }

    public PdfEngine(PDDocument document, DOMAnalyzer decoder, Dimension dim, URL baseurl) {
        super(null, decoder, dim, baseurl);
        this.pdfdocument = document;
        this.startPage = 0;
        this.endPage = Integer.MAX_VALUE;
        this.createPdfLayout(dim);
        this.pdfLoaded = true;
    }

    public CSSBoxTree getBoxTree() {
        return this.boxtree;
    }

    public void createLayout(Dimension dim, Rectangle visibleRect) {
        if (this.pdfdocument != null) {
            if (this.pdfLoaded) {
                this.createPdfLayout(dim);
            }
        } else if (this.getRootElement() != null) {
            super.createLayout(dim, visibleRect);
        }
    }

    protected VisualContext createVisualContext(BrowserConfig config, FontTable fontTable) {
        GraphicsVisualContext ctx = new GraphicsVisualContext(this.getImageGraphics(), null, config, fontTable);
        return ctx;
    }

    public void createPdfLayout(Dimension dim) {
        if (this.pdfdocument != null) {
            try {
                this.initOutputMedia(dim.width, dim.height);
                log.info("Creating PDF boxes");
                GraphicsVisualContext ctx = (GraphicsVisualContext)this.createVisualContext(this.getConfig(), null);
                this.boxtree = new CSSBoxTree((VisualContext)ctx, dim, this.getBaseUrl());
                this.boxtree.setConfig(this.getConfig());
                this.boxtree.processDocument(this.pdfdocument, this.startPage, this.endPage);
                this.setViewport(this.boxtree.getViewport());
                this.setRootElement(this.boxtree.getDocument().getDocumentElement());
                log.info("We have " + this.boxtree.getLastId() + " boxes");
                this.getViewport().initSubtree();
                log.info("Layout for " + dim.width + "px");
                this.getViewport().doLayout(dim.width, true, true);
                log.info("Resulting size: " + this.getViewport().getWidth() + "x" + this.getViewport().getHeight() + " (" + this.getViewport() + ")");
                log.info("Updating viewport size");
                this.getViewport().updateBounds(dim);
                log.info("Resulting size: " + this.getViewport().getWidth() + "x" + this.getViewport().getHeight() + " (" + this.getViewport() + ")");
                if (this.getViewport().getWidth() > dim.width || this.getViewport().getHeight() > dim.height) {
                    this.initOutputMedia(Math.max(this.getViewport().getWidth(), dim.width), Math.max(this.getViewport().getHeight(), dim.height));
                }
                log.trace("Positioning for " + this.getViewport().getWidth() + "x" + this.getViewport().getHeight() + "px");
                this.getViewport().absolutePositions();
                log.trace("Drawing");
                this.renderViewport(this.getViewport());
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (this.getRootElement() != null) {
            super.createLayout(dim);
        }
    }
}

