/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.pdf.demo;

import cz.vutbr.web.css.MediaSpec;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.tree.DefaultTreeModel;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.fit.cssbox.awt.BrowserCanvas;
import org.fit.cssbox.awt.GraphicsEngine;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.demo.BoxBrowser;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.Dimension;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.pdf.PdfEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class PdfBoxBrowser
extends BoxBrowser {
    private static Logger log = LoggerFactory.getLogger(PdfBoxBrowser.class);

    public URL displayURL(String urlstring) {
        try {
            PdfEngine engine;
            if (!(urlstring.startsWith("http:") || urlstring.startsWith("https:") || urlstring.startsWith("ftp:") || urlstring.startsWith("file:"))) {
                urlstring = "http://" + urlstring;
            }
            DefaultDocumentSource docSource = new DefaultDocumentSource(urlstring);
            this.urlText.setText(docSource.getURL().toString());
            Document dom = null;
            InputStream is = docSource.getInputStream();
            if (docSource.getContentType().equals("application/pdf")) {
                log.info("Parsing PDF: " + docSource.getURL());
                PDDocument doc = this.loadPdf(is);
                engine = new PdfEngine(doc, null, new Dimension((float)this.contentScroll.getSize().width, (float)this.contentScroll.getSize().height), docSource.getURL());
            } else {
                DefaultDOMSource parser = new DefaultDOMSource((DocumentSource)docSource);
                Document doc = parser.parse();
                String encoding = parser.getCharset();
                MediaSpec media = new MediaSpec("screen");
                this.updateCurrentMedia(media);
                DOMAnalyzer da = new DOMAnalyzer(doc, docSource.getURL());
                if (encoding == null) {
                    encoding = da.getCharacterEncoding();
                }
                da.setDefaultEncoding(encoding);
                da.setMediaSpec(media);
                da.attributesToStyles();
                da.addStyleSheet(null, CSSNorm.stdStyleSheet(), DOMAnalyzer.Origin.AGENT);
                da.addStyleSheet(null, CSSNorm.userStyleSheet(), DOMAnalyzer.Origin.AGENT);
                da.addStyleSheet(null, CSSNorm.formsStyleSheet(), DOMAnalyzer.Origin.AGENT);
                da.getStyleSheets();
                engine = new GraphicsEngine(da.getRoot(), da, docSource.getURL());
                dom = doc;
            }
            is.close();
            this.contentCanvas = new BrowserCanvas((GraphicsEngine)engine);
            ((BrowserCanvas)this.contentCanvas).setConfig(this.config);
            ((BrowserCanvas)this.contentCanvas).createLayout(this.contentScroll.getSize(), this.contentScroll.getVisibleRect());
            docSource.close();
            this.contentCanvas.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    System.out.println("Click: " + e.getX() + ":" + e.getY());
                    PdfBoxBrowser.this.canvasClick(e.getX(), e.getY());
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            this.contentScroll.setViewportView(this.contentCanvas);
            Viewport viewport = engine.getViewport();
            this.root = this.createBoxTree((Box)viewport);
            this.boxTree.setModel(new DefaultTreeModel(this.root));
            if (dom == null) {
                dom = engine.getBoxTree().getDocument();
            }
            this.domRoot = this.createDomTree(dom);
            this.domTree.setModel(new DefaultTreeModel(this.domRoot));
            return docSource.getURL();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    protected PDDocument loadPdf(InputStream is) throws IOException {
        PDDocument document = null;
        document = PDDocument.load((InputStream)is);
        return document;
    }

    public static void main(String[] args) {
        browser = new PdfBoxBrowser();
        JFrame main = browser.getMainWindow();
        main.setSize(1200, 600);
        main.setVisible(true);
    }
}

