/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.pdf;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.layout.BrowserCanvas;
import org.fit.cssbox.layout.VisualContext;
import org.fit.cssbox.pdf.CSSBoxTree;
import org.fit.cssbox.render.BoxRenderer;
import org.fit.cssbox.render.GraphicsRenderer;
import org.w3c.dom.Element;

public class PdfBrowserCanvas
extends BrowserCanvas {
    private static final long serialVersionUID = -8053836572208370866L;
    protected PDDocument pdfdocument;
    protected int startPage;
    protected int endPage;
    protected boolean pdfLoaded = false;
    protected CSSBoxTree boxtree;

    public PdfBrowserCanvas(Element root, DOMAnalyzer decoder, Dimension dim, URL baseurl) {
        super(root, decoder, dim, baseurl);
    }

    public PdfBrowserCanvas(PDDocument document, int startPage, int endPage, DOMAnalyzer decoder, Dimension dim, URL baseurl) {
        super(null, decoder, dim, baseurl);
        this.pdfdocument = document;
        this.startPage = startPage;
        this.endPage = endPage;
        this.createPdfLayout(dim);
        this.pdfLoaded = true;
    }

    public PdfBrowserCanvas(PDDocument document, DOMAnalyzer decoder, Dimension dim, URL baseurl) {
        super(null, decoder, dim, baseurl);
        this.pdfdocument = document;
        this.startPage = 0;
        this.endPage = Integer.MAX_VALUE;
        this.createPdfLayout(dim);
        this.pdfLoaded = true;
    }

    public PdfBrowserCanvas(PDDocument document, int startPage, int endPage, DOMAnalyzer decoder, URL baseurl) {
        super(null, decoder, baseurl);
        this.pdfdocument = document;
        this.startPage = startPage;
        this.endPage = endPage;
        this.pdfLoaded = true;
    }

    public CSSBoxTree getBoxTree() {
        return this.boxtree;
    }

    public void createLayout(Dimension dim) {
        if (this.pdfdocument != null) {
            if (this.pdfLoaded) {
                this.createPdfLayout(dim);
            }
        } else if (this.root != null) {
            super.createLayout(dim);
        }
    }

    public void createPdfLayout(Dimension dim) {
        if (this.pdfdocument != null) {
            try {
                if (this.createImage) {
                    this.img = new BufferedImage(dim.width, dim.height, 1);
                }
                Graphics2D ig = this.img.createGraphics();
                System.err.println("Creating PDF boxes");
                VisualContext ctx = new VisualContext(null, null);
                this.boxtree = new CSSBoxTree(ig, ctx, dim, this.baseurl);
                this.boxtree.setConfig(this.config);
                this.boxtree.processDocument(this.pdfdocument, this.startPage, this.endPage);
                this.viewport = this.boxtree.getViewport();
                this.root = this.boxtree.getDocument().getDocumentElement();
                System.err.println("We have " + this.boxtree.getLastId() + " boxes");
                this.viewport.initSubtree();
                System.err.println("Layout for " + dim.width + "px");
                this.viewport.doLayout(dim.width, true, true);
                System.err.println("Resulting size: " + this.viewport.getWidth() + "x" + this.viewport.getHeight() + " (" + this.viewport + ")");
                System.err.println("Updating viewport size");
                this.viewport.updateBounds(dim);
                System.err.println("Resulting size: " + this.viewport.getWidth() + "x" + this.viewport.getHeight() + " (" + this.viewport + ")");
                if (this.createImage && (this.viewport.getWidth() > dim.width || this.viewport.getHeight() > dim.height)) {
                    this.img = new BufferedImage(Math.max(this.viewport.getWidth(), dim.width), Math.max(this.viewport.getHeight(), dim.height), 1);
                    ig = this.img.createGraphics();
                }
                System.err.println("Positioning for " + this.img.getWidth() + "x" + this.img.getHeight() + "px");
                this.viewport.absolutePositions();
                this.clearCanvas();
                this.viewport.draw((BoxRenderer)new GraphicsRenderer(ig));
                this.setPreferredSize(new Dimension(this.img.getWidth(), this.img.getHeight()));
                this.revalidate();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (this.root != null) {
            super.createLayout(dim);
        }
    }
}

