/*
 * Decompiled with CFR 0.152.
 */
package org.fit.pdfdom;

import java.io.IOException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.pdfbox.exceptions.WrappedIOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.fit.pdfdom.Base64Coder;
import org.fit.pdfdom.PDFBoxTree;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class PDFDomTree
extends PDFBoxTree {
    protected String defaultStyle = ".page{position:relative; border:1px solid blue;margin:0.5em}\n.p,.r{position:absolute;}";
    protected Document doc;
    protected Element head;
    protected Element body;
    protected Element title;
    protected Element curpage;
    protected int textcnt;
    protected int pagecnt;

    public PDFDomTree() throws IOException, ParserConfigurationException {
        this.init();
    }

    private void init() throws ParserConfigurationException {
        this.pagecnt = 0;
        this.textcnt = 0;
    }

    protected void createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        DocumentType doctype = builder.getDOMImplementation().createDocumentType("html", "-//W3C//DTD XHTML 1.1//EN", "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd");
        this.doc = builder.getDOMImplementation().createDocument("http://www.w3.org/1999/xhtml", "html", doctype);
        this.head = this.doc.createElement("head");
        Element meta = this.doc.createElement("meta");
        meta.setAttribute("http-equiv", "content-type");
        meta.setAttribute("content", "text/html;charset=utf-8");
        this.head.appendChild(meta);
        this.title = this.doc.createElement("title");
        this.title.setTextContent("PDF Document");
        this.head.appendChild(this.title);
        Element gs = this.doc.createElement("style");
        gs.setAttribute("type", "text/css");
        gs.setTextContent(this.defaultStyle);
        this.head.appendChild(gs);
        this.body = this.doc.createElement("body");
        Element root = this.doc.getDocumentElement();
        root.appendChild(this.head);
        root.appendChild(this.body);
    }

    public Document getDocument() {
        return this.doc;
    }

    @Override
    public void processDocument(PDDocument document, int startPage, int endPage) throws IOException {
        try {
            this.createDocument();
        }
        catch (ParserConfigurationException e) {
            throw new WrappedIOException("Error: parser configuration error", (Throwable)e);
        }
        super.processDocument(document, startPage, endPage);
        String doctitle = document.getDocumentInformation().getTitle();
        if (doctitle != null && doctitle.trim().length() > 0) {
            this.title.setTextContent(doctitle);
        }
    }

    public void writeText(PDDocument doc, Writer outputStream) throws IOException {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            writer.getDomConfig().setParameter("format-pretty-print", true);
            output.setCharacterStream(outputStream);
            this.processDocument(doc);
            writer.write(this.getDocument(), output);
        }
        catch (ClassCastException e) {
            throw new WrappedIOException("Error: cannot initialize the DOM serializer", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new WrappedIOException("Error: cannot initialize the DOM serializer", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new WrappedIOException("Error: cannot initialize the DOM serializer", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WrappedIOException("Error: cannot initialize the DOM serializer", (Throwable)e);
        }
    }

    @Override
    protected void startNewPage() {
        this.curpage = this.createPageElement();
        this.body.appendChild(this.curpage);
    }

    @Override
    protected void renderText(String data) {
        this.curpage.appendChild(this.createTextElement(data));
    }

    @Override
    protected void renderRectangle(float x, float y, float width, float height, boolean stroke, boolean fill) {
        this.curpage.appendChild(this.createRectangleElement(x, y, width, height, stroke, fill));
    }

    @Override
    protected void renderImage(float x, float y, float width, float height, String mimetype, byte[] data) {
        this.curpage.appendChild(this.createImageElement(x, y, width, height, mimetype, data));
    }

    protected Element createPageElement() {
        String pstyle = "";
        PDRectangle layout = this.getCurrentMediaBox();
        if (layout != null) {
            pstyle = "width:" + layout.getUpperRightX() + "pt" + ";" + "height:" + layout.getUpperRightY() + "pt";
        } else {
            System.err.println("Warning: no media box found");
        }
        Element el = this.doc.createElement("div");
        el.setAttribute("id", "page_" + this.pagecnt++);
        el.setAttribute("class", "page");
        el.setAttribute("style", pstyle);
        return el;
    }

    protected Element createTextElement() {
        Element el = this.doc.createElement("div");
        el.setAttribute("id", "p" + this.textcnt++);
        el.setAttribute("class", "p");
        el.setAttribute("style", this.curstyle.toString());
        return el;
    }

    protected Element createTextElement(String data) {
        Element el = this.createTextElement();
        Text text = this.doc.createTextNode(data);
        el.appendChild(text);
        return el;
    }

    protected Element createRectangleElement(float x, float y, float width, float height, boolean stroke, boolean fill) {
        String color = "black";
        if (this.strokingColor != null) {
            color = this.strokingColor;
        }
        StringBuilder pstyle = new StringBuilder(50);
        pstyle.append("left:").append(this.style.formatLength(x)).append(';');
        pstyle.append("bottom:").append(this.style.formatLength(y)).append(';');
        pstyle.append("width:").append(this.style.formatLength(width)).append(';');
        pstyle.append("height:").append(this.style.formatLength(height)).append(';');
        if (stroke) {
            this.lineWidth = this.transformLength((float)this.getGraphicsState().getLineWidth());
            String lw = this.lineWidth == 0.0f ? "1px" : this.lineWidth + "pt";
            pstyle.append("border:").append(lw).append(" solid ").append(color).append(';');
        }
        if (fill) {
            pstyle.append("background-color:").append(this.style.getColor()).append(';');
        }
        Element el = this.doc.createElement("div");
        el.setAttribute("class", "r");
        el.setAttribute("style", pstyle.toString());
        el.appendChild(this.doc.createEntityReference("nbsp"));
        return el;
    }

    protected Element createImageElement(float x, float y, float width, float height, String mimetype, byte[] data) {
        StringBuilder pstyle = new StringBuilder("position:absolute;");
        pstyle.append("left:").append(x).append("pt").append(';');
        pstyle.append("bottom:").append(y).append("pt").append(';');
        pstyle.append("width:").append(width).append("pt").append(';');
        pstyle.append("height:").append(height).append("pt").append(';');
        Element el = this.doc.createElement("img");
        el.setAttribute("style", pstyle.toString());
        if (!this.disableImageData) {
            char[] cdata = Base64Coder.encode(data);
            String imgdata = "data:" + mimetype + ";base64," + new String(cdata);
            el.setAttribute("src", imgdata);
        } else {
            el.setAttribute("src", "");
        }
        return el;
    }
}

