package net.sf.cuf.fw;

import java.util.Map;

/**
 * This interface describes all methods common to presentation component.<br>
 * These common methods mainly describe the lifecycle of a presentation 
 * component and the services it provides.<br>
 */
@SuppressWarnings({"InterfaceNamingConvention"})
public interface Pc
{
    /**
     * This method is called by the dialog controller peer during
     * the initialisation phase of an application.<br>
     * All arguments are handed in with a map object, that map always
     * contains the application object with the key
     * <code>Application.APPLICATION_KEY</code>.
     * The map should <b>not</b> be altered inside the method.
     *
     * @param pDc our peer dialog controller, never null.
     * @param pArgs variable argument list modeled as a key/value map,
     *              never null.
     */
    void init(Dc pDc, Map<String, ? super Object> pArgs);
}
