package net.sf.cuf.fw2;

import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw.Application;
import net.sf.cuf.appevent.AppEventSupport;
import net.sf.cuf.appevent.AppEvent;

import java.util.Map;

/**
 * The AbstractDialogDc implements the common stuff (AppEvent handling,
 * canPassivate check) of the DialogDc interface.
 * A project specific DialogDc is usally derived from AbstractDialogDc.
 */
public abstract class AbstractDialogDc implements DialogDc
{
    /** The next object in the AppEvent responder chain. */
    protected AppEventSupport mAppEventSupport;

    /** The manager object that opens/closes dialogs. */
    protected DialogManager mDialogManager;

    /**
     * We assume that all dialogs that don't care can always be passivated.
     * @return always true
     */
    public boolean canPassivate()
    {
        return true;
    }

    /**
     * This method is called by the parent dialog controller during
     * the initialisation phase of an application.
     *
     * @param pParent our non-null parent, must implement AppEventSupport
     * @param pArgs variable argument list modeled as a key/value map, never null.
     */
    public void init(final Dc pParent, final Map<String, ? super Object> pArgs)
    {
        Object application= pArgs.get(Application.APPLICATION_KEY);
        if (pParent instanceof AppEventSupport)
        {
            mAppEventSupport= (AppEventSupport)pParent;
        }
        else
        {
            mAppEventSupport= (AppEventSupport) application;
        }
        mDialogManager= new DialogManager((Application)application);
    }

    /**
     * Process/Dispatch an AppEvent.
     *
     * @param pAppEvent event that should be routed/processes
     * @throws IllegalArgumentException if pAppEvent is null
     */
    public void postAppEvent(final AppEvent pAppEvent)
    {
        mDialogManager.postAppEvent(this, mAppEventSupport, pAppEvent);
    }

    /**
     * Called from the dialog coordinator to tell the dialog to cleanup all
     * resources. The base implementation does nothing.
     * @param pArgs arguments, key is a String, value is any suitable objekt for the key
     */
    public void dispose(final Map<String, ? super Object> pArgs)
    {
    }
}
