package net.sf.cuf.singleapp;

import java.io.Serializable;


/**
 * Handles contacts from other started instances
 */
public interface ContactHandler
{

    /**
     * This method is called when another application instance is started and contacts this instance.
     * When this method is called, it is already ensured that both the caller and this application have
     * the same application id.
     * <P>
     * This method will be called in some thread. It may be called simultaneously in multiple threads.
     * <P>
     * The objects transferred may be any {@link Serializable} but you should certain that
     * either both application instances are using the same code base or that the objects have 
     * custom serialization mechanisms that allow communication across different versions.
     * <P>
     * The implementation of this method should be relatively fast.
     * 
     * @param pData the data object provided by the new application instance
     * @return an object to return to the new application instance
     */
    Serializable handleContactFromOtherInstance(Serializable pData);
    
}
