/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.fw2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class UserProperties {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator", "/");
    protected static final String DEFAULT_USER_PROPERTIES_FILENAME = "user.properties";

    private UserProperties() {
    }

    public static Properties read(String pDefaultProps, String pPath, String pFle) throws IOException {
        ClassLoader loader;
        InputStream defaultIn;
        Properties userProps = new Properties();
        if (pDefaultProps != null && (defaultIn = (loader = Thread.currentThread().getContextClassLoader()).getResourceAsStream(pDefaultProps)) != null) {
            userProps.load(defaultIn);
            defaultIn.close();
        }
        String fileName = pFle != null ? pFle : DEFAULT_USER_PROPERTIES_FILENAME;
        StringBuilder userPropsFilename = new StringBuilder(System.getProperty("user.home", "."));
        userPropsFilename.append(FILE_SEPARATOR);
        if (pPath != null) {
            userPropsFilename.append(pPath);
            userPropsFilename.append(FILE_SEPARATOR);
        }
        userPropsFilename.append(fileName);
        File userPropsFile = new File(userPropsFilename.toString());
        try {
            FileInputStream userIn = new FileInputStream(userPropsFile);
            userProps.load(userIn);
            userIn.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return userProps;
    }

    public static void write(Properties pUserProps, String pPath, String pFile) throws IOException {
        String fileName = pFile != null ? pFile : DEFAULT_USER_PROPERTIES_FILENAME;
        StringBuilder userPropsFilename = new StringBuilder(System.getProperty("user.home", "."));
        if (pPath != null) {
            userPropsFilename.append(FILE_SEPARATOR);
            userPropsFilename.append(pPath);
        }
        userPropsFilename.append(FILE_SEPARATOR);
        userPropsFilename.append(fileName);
        File userPropsFile = new File(userPropsFilename.toString());
        File userPropsPath = userPropsFile.getParentFile();
        if (userPropsPath != null && !userPropsPath.exists()) {
            userPropsPath.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(userPropsFile);
        if (pUserProps != null) {
            pUserProps.store(out, System.getProperty("user.name", ""));
        }
        out.close();
    }
}

