/*
 * Decompiled with CFR 0.152.
 */
package com.nexwave.nquindexer;

import com.nexwave.nquindexer.SaxHTMLIndex;
import com.nexwave.nquindexer.WriteJSFiles;
import com.nexwave.nsidita.DirList;
import com.nexwave.nsidita.DocFileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;

public class IndexerTask {
    private String txt_no_inputdir = "Input directory not found:";
    private String txt_cannot_create_outputdir = "Cannot create output search directory.";
    private String txt_no_files_found = "No html files found.";
    private String txt_wrong_dita_basedir = "ERROR: Parser initialization failed. Wrong dita base dir";
    private String txt_no_relative_files_found = "No relative html files calculated.";
    private String txt_no_words_gathered = "No words have been indexed in";
    private String txt_no_html_files = "No HTML Files found in";
    private String txt_no_args = "No argument given: you must provide an htmldir to the IndexerTask";
    private String searchdir = "search";
    private File inputDir = null;
    private String outputDir = null;
    private String projectDir = null;
    private String htmldir = null;
    public static String indexerLanguage = "en";
    private String[] supportedLanguages = new String[]{"en", "de", "fr", "zh", "ja", "ko"};
    private ArrayList<String> cleanUpStrings = null;
    private ArrayList<String> cleanUpChars = null;

    public void setHtmldir(String string) {
        this.htmldir = string;
    }

    public void setIndexerLanguage(String string) {
        if (string != null && !"".equals(string)) {
            int n;
            int n2 = string.indexOf(95);
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
            for (n = 0; n < this.supportedLanguages.length; ++n) {
                if (!string.equals(this.supportedLanguages[n])) continue;
                indexerLanguage = this.supportedLanguages[n];
                break;
            }
            if (n >= this.supportedLanguages.length) {
                indexerLanguage = string;
            }
        } else {
            indexerLanguage = "@@";
        }
    }

    public void execute() {
        DirList dirList;
        boolean bl;
        File file;
        try {
            System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        }
        catch (SecurityException securityException) {
            System.out.println("[WARNING] Default parser is not set to Xerces. Make sure Saxon6.5.5 is not in your CLASSPATH.");
        }
        catch (Exception exception) {
            System.out.println("[WARNING] Default parser is not set to Xerces. Make sure Saxon6.5.5 is not in your CLASSPATH");
        }
        ArrayList<DocFileInfo> arrayList = null;
        ArrayList<File> arrayList2 = null;
        ArrayList<String> arrayList3 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "htmlFileList.js";
        String string2 = "htmlFileInfoList.js";
        String string3 = ".js";
        Date date = new Date();
        if (this.htmldir == null) {
            System.out.println(this.txt_no_args + ".");
            return;
        }
        this.inputDir = new File(this.htmldir);
        if (this.inputDir == null) {
            IndexerTask.DisplayHelp();
            return;
        }
        if (!this.inputDir.exists()) {
            System.out.println(this.txt_no_inputdir + " " + this.inputDir + ".");
            return;
        }
        if (this.outputDir == null) {
            this.outputDir = this.inputDir.getPath().concat(File.separator).concat(this.searchdir);
        }
        if (!(file = new File(this.outputDir)).exists() && !(bl = new File(this.outputDir).mkdir())) {
            System.out.println(this.txt_cannot_create_outputdir + " " + this.outputDir + ".");
            return;
        }
        if (this.projectDir == null) {
            this.projectDir = this.inputDir.getPath();
        }
        if ((arrayList2 = (dirList = new DirList(this.inputDir, "^.*\\.html?$", 1)).getListFiles()).isEmpty()) {
            System.out.println(this.txt_no_html_files + " " + this.inputDir + ".");
            return;
        }
        arrayList3 = dirList.getListFilesRelTo(this.projectDir);
        if (arrayList2 == null) {
            System.out.println(this.txt_no_files_found);
            return;
        }
        if (arrayList3 == null) {
            System.out.println(this.txt_no_relative_files_found);
            return;
        }
        WriteJSFiles.WriteHTMLList(this.outputDir.concat(File.separator).concat(string), arrayList3);
        this.RetrieveCleanUpProps();
        SaxHTMLIndex saxHTMLIndex = new SaxHTMLIndex(this.cleanUpStrings, this.cleanUpChars);
        if (saxHTMLIndex.init(hashMap) == 0) {
            arrayList = new ArrayList<DocFileInfo>();
            for (File file2 : arrayList2) {
                DocFileInfo docFileInfo = new DocFileInfo(saxHTMLIndex.runExtractData(file2, indexerLanguage));
                File file3 = docFileInfo.getFullpath();
                String string4 = file3.toString();
                int n = string4.indexOf(this.projectDir);
                if (n != 0) {
                    System.out.println("the documentation root does not match with the documentation input!");
                    return;
                }
                int n2 = 1;
                if (string4.equals(this.projectDir)) {
                    n2 = 0;
                }
                string4 = string4.substring(n + this.projectDir.length() + n2);
                File comparable2 = new File(string4);
                docFileInfo.setFullpath(comparable2);
                arrayList.add(docFileInfo);
            }
            if (hashMap.containsKey("")) {
                hashMap.remove("");
            }
            if (hashMap.isEmpty()) {
                System.out.println(this.txt_no_words_gathered + " " + this.inputDir + ".");
                return;
            }
            WriteJSFiles.WriteIndex(this.outputDir.concat(File.separator).concat(string3), hashMap);
            WriteJSFiles.WriteHTMLInfoList(this.outputDir.concat(File.separator).concat(string2), arrayList);
            Date date2 = new Date();
            long l = date2.getTime() - date.getTime();
            if (l < 1000L) {
                System.out.println("Delay = " + l + " milliseconds");
            } else {
                System.out.println("Delay = " + l / 1000L + " seconds");
            }
        } else {
            System.out.println(this.txt_wrong_dita_basedir);
            return;
        }
    }

    private static void DisplayHelp() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("USAGE:" + string);
        stringBuffer.append("   java -classpath TesterIndexer inputDir outputDir projectDir" + string);
        stringBuffer.append("with:" + string);
        stringBuffer.append("   inputDir (mandatory) :  specify the html files ' directory to index" + string);
        stringBuffer.append("   outputDir (optional) : specify where to output the index files" + string);
        stringBuffer.append("   projectDir (optional) : specify the root of the documentation directory" + string);
        stringBuffer.append("Example:" + string);
        stringBuffer.append("   java -classpath TesterIndexer /home/$USER/DITA/doc" + string);
        stringBuffer.append("Example 2:" + string);
        stringBuffer.append("   java -classpath TesterIndexer /home/$USER/DITA/doc/customer/concepts /home/$USER/temp/search /home/$USER/DITA/doc/" + string);
        System.out.println(stringBuffer.toString());
    }

    private int RetrieveCleanUpProps() {
        String[] stringArray = new String[]{"punctuation.props"};
        Collection<Object> collection = new ArrayList();
        DirList dirList = new DirList(this.inputDir, "^(?!(punctuation)).*\\.props$", 1);
        ArrayList<File> arrayList = dirList.getListFiles();
        Properties properties = new Properties();
        String string = this.inputDir.getPath().concat(File.separator).concat(this.searchdir);
        this.cleanUpStrings = new ArrayList();
        this.cleanUpChars = new ArrayList();
        try {
            FileInputStream fileInputStream;
            File file;
            for (File file2 : arrayList) {
                file = file2;
                if (!file.exists()) continue;
                fileInputStream = new FileInputStream(file.getAbsolutePath());
                properties.load(fileInputStream);
                fileInputStream.close();
                collection = properties.values();
                this.cleanUpStrings.addAll(collection);
                properties.clear();
            }
            for (String string2 : stringArray) {
                String string3 = string.concat(File.separator).concat(string2);
                file = new File(string3);
                if (!file.exists()) continue;
                fileInputStream = new FileInputStream(string3);
                properties.load(fileInputStream);
                fileInputStream.close();
                collection = properties.values();
                this.cleanUpChars.addAll(collection);
                properties.clear();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 1;
        }
        return 0;
    }
}

