/*
 * Decompiled with CFR 0.152.
 */
package com.nexwave.nquindexer;

import com.nexwave.nsidita.BlankRemover;
import com.nexwave.nsidita.DocFileInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxDocFileParser
extends DefaultHandler {
    protected DocFileInfo fileDesc = null;
    protected String projectDir = null;
    protected StringBuffer strbf = null;
    private String currentElName = "";
    private StringBuffer tempVal = null;
    private boolean shortdescBool = false;
    private int shortTagCpt = 0;
    private boolean addContent = false;
    private boolean addHeaderInfo = false;
    private boolean doNotIndex = false;
    private int divCount = 0;

    public int init(String string) {
        return 0;
    }

    public DocFileInfo runExtractData(File file) {
        this.fileDesc = new DocFileInfo(file);
        this.strbf = new StringBuffer("");
        this.parseDocument(file);
        return this.fileDesc;
    }

    public void parseDocument(File file) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        this.addContent = false;
        this.divCount = 0;
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.getXMLReader().setFeature("http://xml.org/sax/features/external-general-entities", false);
            sAXParser.getXMLReader().setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            System.out.println("Parsing: " + file);
            long l = System.currentTimeMillis();
            if (this.RemoveValidationPI(file) == 0) {
                sAXParser.parse("xx.html", (DefaultHandler)this);
            }
            long l2 = System.currentTimeMillis();
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("SaxParseException: The indexing file contains incorrect xml syntax.");
            sAXParseException.printStackTrace();
        }
        catch (SAXException sAXException) {
            System.out.println("SaxException. You may need to include Xerces in your classpath. See documentation for details");
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        this.currentElName = string3;
        if (string3.equalsIgnoreCase("meta")) {
            this.addHeaderInfo = true;
            string4 = attributes.getValue("name");
            if (string4 != null && (string4.equalsIgnoreCase("keywords") || string4.equalsIgnoreCase("description"))) {
                this.strbf.append(" " + attributes.getValue("content") + " ");
            }
            if (string4 != null && string4.equalsIgnoreCase("description")) {
                this.fileDesc.setShortdesc(BlankRemover.rmWhiteSpace(attributes.getValue("content").replace('\n', ' ')));
            }
        }
        if (string3.equalsIgnoreCase("title") || string3.equalsIgnoreCase("shortdesc")) {
            this.tempVal = new StringBuffer();
        }
        this.addHeaderInfo = string3.equalsIgnoreCase("meta") || string3.equalsIgnoreCase("title") || string3.equalsIgnoreCase("shortdesc");
        string4 = attributes.getValue("id");
        if ("content".equals(string4)) {
            this.addContent = true;
        }
        if (this.addContent) {
            String string5;
            if (string3.equalsIgnoreCase("div")) {
                ++this.divCount;
            }
            if (string3.equalsIgnoreCase("div") || string3.equalsIgnoreCase("p") || string3.equalsIgnoreCase("span")) {
                string5 = attributes.getValue("class");
                if (string5 != null && (string5.equalsIgnoreCase("shortdesc") || string5.equalsIgnoreCase("summary"))) {
                    this.shortdescBool = true;
                }
                this.tempVal = new StringBuffer();
                this.strbf.append(" ");
            }
            if (this.shortdescBool) {
                ++this.shortTagCpt;
            }
            this.doNotIndex = (string5 = attributes.getValue("accesskey")) != null && ("n".equals(string5) || "p".equals(string5) || "h".equals(string5));
        }
        this.strbf.append(" ");
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if ((this.addContent || this.addHeaderInfo) && !this.doNotIndex && !this.currentElName.equalsIgnoreCase("script")) {
            String string = new String(cArray, n, n2);
            this.strbf.append(string);
            if (this.tempVal != null) {
                this.tempVal.append(string);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("title")) {
            this.fileDesc.setTitle(BlankRemover.rmWhiteSpace(this.tempVal.toString()));
            this.tempVal = null;
        } else if (this.shortdescBool) {
            --this.shortTagCpt;
            if (this.shortTagCpt == 0) {
                this.fileDesc.setShortdesc(BlankRemover.rmWhiteSpace(this.tempVal.toString().replace('\n', ' ')));
                this.tempVal = null;
                this.shortdescBool = false;
            }
        }
        if (string3.equalsIgnoreCase("div") && this.addContent) {
            --this.divCount;
            if (this.divCount == 0) {
                this.addContent = false;
            }
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        return null;
    }

    public int RemoveValidationPI(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File("xx.html")), "UTF-8"));
            while (true) {
                boolean bl = true;
                try {
                    String string = bufferedReader.readLine();
                    if (string == null) break;
                    if (!(string = string.replaceAll("\\x26nbsp\\x3B", "&#160;")).contains("<!DOCTYPE html PUBLIC")) {
                        if (string.contains("<?xml version")) {
                            string = string.replaceAll("\\x3C\\x3Fxml[^\\x3E]*\\x3F\\x3E", "\n");
                        }
                        printWriter.write(string + "\n");
                        continue;
                    }
                    int n = string.indexOf("<!DOCTYPE");
                    int n2 = string.indexOf(">", n);
                    while (n2 < 0) {
                        string = string.concat(bufferedReader.readLine());
                        n2 = string.indexOf(">", n);
                    }
                    String string2 = string.substring(n, n2);
                    if (string.contains("<?xml version")) {
                        string = string.replaceAll("\\x3C\\x3Fxml[^\\x3E]*\\x3F\\x3E", "\n");
                    }
                    string = string.replaceAll("\\x3C\\x21DOCTYPE[^\\x3E]*\\x3E", "\n");
                    printWriter.write(string);
                }
                catch (IOException iOException) {
                    break;
                }
            }
            printWriter.flush();
            printWriter.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return 1;
        }
        return 0;
    }
}

