/*
 * Decompiled with CFR 0.152.
 */
package com.nexwave.nquindexer;

import com.nexwave.nquindexer.IndexerTask;
import com.nexwave.nsidita.DocFileInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class WriteJSFiles {
    private static String txt_VM_encoding_not_supported = "This VM does not support the specified encoding.";
    private static String txt_indices_location = "The created index files are located in ";

    public static void WriteHTMLList(String string, ArrayList<String> arrayList) {
        int n = 0;
        if (arrayList == null) {
            return;
        }
        if (string == null) {
            return;
        }
        Iterator<String> iterator = arrayList.iterator();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, "UTF-8");
            outputStreamWriter.write("//List of files which are indexed.\n");
            outputStreamWriter.write("fl = new Array();\n");
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                outputStreamWriter.write("fl[\"" + n + "\"]" + "= \"" + string2.replace(File.separatorChar, '/') + "\";\n");
                ++n;
            }
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(txt_VM_encoding_not_supported);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public static void WriteHTMLInfoList(String string, ArrayList<DocFileInfo> arrayList) {
        int n = 0;
        Iterator<DocFileInfo> iterator = null;
        if (arrayList == null) {
            return;
        }
        if (string == null) {
            return;
        }
        iterator = arrayList.iterator();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, "UTF-8");
            outputStreamWriter.write("fil = new Array();\n");
            while (iterator.hasNext()) {
                DocFileInfo docFileInfo = iterator.next();
                String string2 = docFileInfo.getFullpath().toString().replace(File.separatorChar, '/');
                String string3 = docFileInfo.getTitle();
                String string4 = docFileInfo.getShortdesc();
                if (string3 != null) {
                    string3 = string3.replaceAll("\\s+", " ");
                    string3 = string3.replaceAll("['\u00d4\u00f8\u03a9\"]", " ");
                }
                if (string4 != null) {
                    string4 = string4.replaceAll("\\s+", " ");
                    string4 = string4.replaceAll("['\u00d4\u00f8\u03a9\"]", " ");
                }
                outputStreamWriter.write("fil[\"" + n + "\"]" + "= \"" + string2 + "@@@" + string3 + "@@@" + string4 + "\";\n");
                ++n;
            }
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(txt_VM_encoding_not_supported);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public static void WriteIndex(String string, Map<String, ?> map) {
        if (map == null || string == null) {
            return;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(map.keySet());
        Iterator iterator = treeSet.iterator();
        String string2 = (String)iterator.next();
        File file = new File(string);
        int n = treeSet.size();
        for (int i = 1; i <= 3; ++i) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file.getParent() + File.separator + "index-" + i + file.getName());
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, "UTF-8");
                try {
                    int n2 = 0;
                    if (i == 1) {
                        outputStreamWriter.write("var indexerLanguage=\"" + IndexerTask.indexerLanguage + "\";\n");
                    }
                    outputStreamWriter.write("//Auto generated index for searching.\n");
                    while (iterator.hasNext()) {
                        outputStreamWriter.write("w[\"" + string2 + "\"]" + "=\"" + map.get(string2) + "\";\n");
                        string2 = (String)iterator.next();
                        if (n / ++n2 >= 3) continue;
                    }
                    outputStreamWriter.write("\n");
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println(txt_VM_encoding_not_supported);
                }
                continue;
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
        }
        System.out.println(txt_indices_location + string);
    }
}

