/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking;

import com.javadocking.DockingExecutor;
import com.javadocking.component.DefaultSwComponentFactory;
import com.javadocking.component.SwComponentFactory;
import com.javadocking.drag.DefaultDragListenerFactory;
import com.javadocking.drag.DragListenerFactory;
import com.javadocking.drag.DraggerFactory;
import com.javadocking.drag.StaticDraggerFactory;
import com.javadocking.drag.painter.CompositeDockableDragPainter;
import com.javadocking.drag.painter.DefaultRectanglePainter;
import com.javadocking.drag.painter.RectangleDragComponentFactory;
import com.javadocking.drag.painter.SwDockableDragPainter;
import com.javadocking.drag.painter.WindowDockableDragPainter;
import com.javadocking.model.DefaultDockingPathModel;
import com.javadocking.model.DockModel;
import com.javadocking.model.DockingPathModel;
import java.awt.Cursor;
import java.awt.dnd.DragSource;

public class DockingManager {
    private static DockingExecutor dockingExecutor = new DockingExecutor();
    private static SwComponentFactory componentFactory = new DefaultSwComponentFactory();
    private static DockModel dockModel;
    private static DockingPathModel dockingPathModel;
    private static DraggerFactory draggerFactory;
    private static DragListenerFactory dockDragListenerFactory;
    private static DragListenerFactory dockableDragListenerFactory;
    private static Cursor canDockCursor;
    private static Cursor canNotDockCursor;

    public static SwComponentFactory getComponentFactory() {
        return componentFactory;
    }

    public static void setComponentFactory(SwComponentFactory newComponentFactory) {
        componentFactory = newComponentFactory;
    }

    public static DockingExecutor getDockingExecutor() {
        return dockingExecutor;
    }

    public static void setDockingExecutor(DockingExecutor newDockingExecutor) {
        dockingExecutor = newDockingExecutor;
    }

    public static DraggerFactory getDraggerFactory() {
        return draggerFactory;
    }

    public static void setDraggerFactory(DraggerFactory newDraggerFactory) {
        draggerFactory = newDraggerFactory;
    }

    public static DragListenerFactory getDockDragListenerFactory() {
        return dockDragListenerFactory;
    }

    public static void setDockDragListenerFactory(DragListenerFactory newDragListenerFactory) {
        dockDragListenerFactory = newDragListenerFactory;
    }

    public static DragListenerFactory getDockableDragListenerFactory() {
        return dockableDragListenerFactory;
    }

    public static void setDockableDragListenerFactory(DragListenerFactory newDragListenerFactory) {
        dockableDragListenerFactory = newDragListenerFactory;
    }

    public static DockModel getDockModel() {
        return dockModel;
    }

    public static void setDockModel(DockModel newDockModel) {
        if (newDockModel == null) {
            throw new NullPointerException("Dock model null");
        }
        dockModel = newDockModel;
    }

    public static DockingPathModel getDockingPathModel() {
        return dockingPathModel;
    }

    public static void setDockingPathModel(DockingPathModel newDockingPathModel) {
        if (newDockingPathModel == null) {
            throw new NullPointerException("Docking path model null");
        }
        dockingPathModel = newDockingPathModel;
    }

    public static Cursor getCanDockCursor() {
        return canDockCursor;
    }

    public static void setCanDockCursor(Cursor newCanDockCursor) {
        canDockCursor = newCanDockCursor;
    }

    public static Cursor getCanNotDockCursor() {
        return canNotDockCursor;
    }

    public static void setCanNotDockCursor(Cursor newCanNotDockCursor) {
        canNotDockCursor = newCanNotDockCursor;
    }

    static {
        dockingPathModel = new DefaultDockingPathModel();
        draggerFactory = new StaticDraggerFactory();
        dockDragListenerFactory = new DefaultDragListenerFactory();
        dockableDragListenerFactory = new DefaultDragListenerFactory();
        canDockCursor = DragSource.DefaultMoveDrop;
        canNotDockCursor = DragSource.DefaultMoveNoDrop;
        CompositeDockableDragPainter dockableDragPainter = new CompositeDockableDragPainter();
        dockableDragPainter.addPainter(new SwDockableDragPainter(new RectangleDragComponentFactory(new DefaultRectanglePainter(), true)));
        dockableDragPainter.addPainter(new WindowDockableDragPainter(new DefaultRectanglePainter(), true));
        draggerFactory = new StaticDraggerFactory(dockableDragPainter);
    }
}

