/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;

class IconButton
extends JLabel {
    private static final Dimension DEFAULT_SIZE = new Dimension(14, 14);
    private static final int BORDER = 1;
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static final Border LINE_BORDER = BorderFactory.createLineBorder(Color.gray);
    private Action action;

    public IconButton(Action action) {
        this.setDimensions();
        this.setAction(action);
        this.addMouseListener(new ClickListener());
        this.setBorder(EMPTY_BORDER);
        this.setOpaque(false);
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Acion is null.");
        }
        this.action = action;
        if (action instanceof AbstractAction) {
            Icon icon = (Icon)action.getValue("SmallIcon");
            this.setIcon(icon);
            String description = (String)action.getValue("ShortDescription");
            this.setToolTipText(description);
        }
    }

    private void setDimensions() {
        this.setPreferredSize(DEFAULT_SIZE);
        this.setMaximumSize(DEFAULT_SIZE);
        this.setMinimumSize(DEFAULT_SIZE);
    }

    private class ClickListener
    extends MouseAdapter {
        private ClickListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, (String)IconButton.this.action.getValue("ShortDescription"), mouseEvent.getModifiers());
            IconButton.this.action.actionPerformed(actionEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            IconButton.this.setBorder(LINE_BORDER);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            IconButton.this.setBorder(EMPTY_BORDER);
        }
    }
}

