/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.component;

import com.javadocking.DockingManager;
import com.javadocking.component.SelectableHeader;
import com.javadocking.dock.Dock;
import com.javadocking.dockable.Dockable;
import com.javadocking.util.DockingUtil;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SelectableDockHeader
extends JPanel
implements SelectableHeader {
    private static final int HEADER_HEIGHT = 16;
    private static final int MAXIMUM_WIDTH = Integer.MAX_VALUE;
    private static final int DIVIDER_WIDTH = 6;
    private boolean selected;
    private JLabel titleLabel;
    private Dimension preferredSize;
    private int position = 3;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public SelectableDockHeader(Dock dock, int position) {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createRigidArea(new Dimension(6, 0)));
        this.add(Box.createHorizontalGlue());
        ArrayList dockables = new ArrayList();
        DockingUtil.retrieveDockables(dock, dockables);
        String title = "";
        if (dockables.size() > 0) {
            title = ((Dockable)dockables.get(0)).getTitle();
        }
        for (int index = 1; index < dockables.size(); ++index) {
            title = title + ", " + ((Dockable)dockables.get(index)).getTitle();
        }
        this.titleLabel = DockingManager.getComponentFactory().createJLabel();
        this.titleLabel.setText(title);
        this.titleLabel.setHorizontalAlignment(0);
        this.add(this.titleLabel);
        this.add(Box.createRigidArea(new Dimension(6, 0)));
        this.add(Box.createHorizontalGlue());
        this.setSizes();
    }

    public void dispose() {
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        boolean oldValue = this.selected;
        if (this.selected != selected) {
            this.selected = selected;
            this.setSizes();
        }
        this.revalidate();
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("selected", oldValue, selected);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
        super.removePropertyChangeListener(listener);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    protected JLabel getTitleLabel() {
        return this.titleLabel;
    }

    protected int getHeaderHeight() {
        return 16;
    }

    protected int getHeaderMaximumWidth() {
        return Integer.MAX_VALUE;
    }

    private void setSizes() {
        int preferredWidth = this.calculatePreferredWidth();
        int maximumWidth = this.getHeaderMaximumWidth();
        this.setMaximumSize(new Dimension(maximumWidth, this.getHeaderHeight()));
        this.setMinimumSize(new Dimension(preferredWidth, this.getHeaderHeight()));
        this.preferredSize = new Dimension(preferredWidth, this.getHeaderHeight());
    }

    protected int calculatePreferredWidth() {
        return 12 + this.titleLabel.getPreferredSize().width;
    }
}

