/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.component;

import com.javadocking.DockingManager;
import com.javadocking.component.SelectableHeader;
import com.javadocking.dockable.Dockable;
import com.javadocking.dockable.action.ShowActionMode;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SelectableDockableHeader
extends JPanel
implements SelectableHeader {
    private static final int HEADER_HEIGHT = 16;
    private static final int MAXIMUM_WIDTH = Integer.MAX_VALUE;
    private static final int DIVIDER_WIDTH = 6;
    private static final String DOCKABLE_ICON_PROPERTY = "icon";
    private static final String DOCKABLE_TITLE_PROPERTY = "title";
    private static final String DOCKABLE_DESCRIPTION_PROPERTY = "description";
    private Dockable dockable;
    private boolean selected;
    private JLabel titleLabel;
    private JLabel iconLabel;
    private JPanel actionPanel;
    private JPanel selectedActionPanel;
    private Dimension preferredSize;
    private int position = 3;
    private ShowActionMode showActionMode;
    private ShowActionMode selectedShowActionMode;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private PropertyChangeListener dockableChangeListener;

    public SelectableDockableHeader(Dockable dockable, int position) {
        this(dockable, position, ShowActionMode.FIRST_ROW_ACTIONS, ShowActionMode.ALL_ACTIONS);
    }

    public SelectableDockableHeader(Dockable dockable, int position, ShowActionMode showActionMode, ShowActionMode selectedShowActionMode) {
        this.setOpaque(false);
        this.dockable = dockable;
        this.showActionMode = showActionMode;
        this.selectedShowActionMode = selectedShowActionMode;
        this.setLayout(new BoxLayout(this, 0));
        Icon icon = dockable.getIcon();
        if (icon != null) {
            this.iconLabel = DockingManager.getComponentFactory().createJLabel();
            this.iconLabel.setIcon(dockable.getIcon());
            this.add(this.iconLabel);
        }
        this.add(Box.createRigidArea(new Dimension(6, 0)));
        this.add(Box.createHorizontalGlue());
        this.titleLabel = DockingManager.getComponentFactory().createJLabel();
        this.titleLabel.setText(dockable.getTitle());
        this.titleLabel.setHorizontalAlignment(0);
        this.add(this.titleLabel);
        this.actionPanel = this.createActionPanel(showActionMode);
        this.selectedActionPanel = this.createActionPanel(selectedShowActionMode);
        this.add(Box.createRigidArea(new Dimension(6, 0)));
        this.add(Box.createHorizontalGlue());
        this.addActions();
        this.setSizes();
        this.dockableChangeListener = new DockableChangeListener();
        dockable.addPropertyChangeListener(this.dockableChangeListener);
    }

    public void dispose() {
        this.dockable.removePropertyChangeListener(this.dockableChangeListener);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        boolean oldValue = this.selected;
        if (this.selected != selected) {
            this.selected = selected;
            this.addActions();
        }
        this.revalidate();
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("selected", oldValue, selected);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
        super.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
        super.removePropertyChangeListener(listener);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public ShowActionMode getSelectedShowActionMode() {
        return this.selectedShowActionMode;
    }

    public void setSelectedShowActionMode(ShowActionMode selectedShowActionMode) {
        this.selectedShowActionMode = selectedShowActionMode;
    }

    public ShowActionMode getShowActionMode() {
        return this.showActionMode;
    }

    public void setShowActionMode(ShowActionMode showActionMode) {
        this.showActionMode = showActionMode;
    }

    protected JPanel getActionPanel() {
        return this.actionPanel;
    }

    public JPanel getSelectedActionPanel() {
        return this.selectedActionPanel;
    }

    protected JLabel getIconLabel() {
        return this.iconLabel;
    }

    protected JLabel getTitleLabel() {
        return this.titleLabel;
    }

    protected int getHeaderHeight() {
        return 16;
    }

    protected int getHeaderMaximumWidth() {
        return Integer.MAX_VALUE;
    }

    private void addActions() {
        if (this.actionPanel != null) {
            this.remove(this.actionPanel);
        }
        if (this.selectedActionPanel != null) {
            this.remove(this.selectedActionPanel);
        }
        if (this.selected && this.selectedActionPanel != null) {
            this.add(this.selectedActionPanel);
        } else if (!this.selected && this.actionPanel != null) {
            this.add(this.actionPanel);
        }
        this.setSizes();
    }

    private JPanel createActionPanel(ShowActionMode actionMode) {
        JPanel actionPanel;
        block3: {
            Action[] actionGroup;
            Action[][] actionMatrix;
            block4: {
                actionPanel = null;
                actionMatrix = this.dockable.getActions();
                if (actionMatrix == null || actionMatrix.length <= 0) break block3;
                if (actionMode != ShowActionMode.ALL_ACTIONS) break block4;
                actionPanel = new JPanel();
                actionPanel.setOpaque(false);
                actionPanel.setLayout(new BoxLayout(actionPanel, 0));
                for (int group = actionMatrix.length - 1; group >= 0; --group) {
                    Action[] actionGroup2 = actionMatrix[group];
                    if (actionGroup2 == null) continue;
                    for (int index = 0; index < actionGroup2.length; ++index) {
                        actionPanel.add(DockingManager.getComponentFactory().createIconButton(actionGroup2[index]));
                    }
                }
                break block3;
            }
            if (actionMode != ShowActionMode.FIRST_ROW_ACTIONS || (actionGroup = actionMatrix[0]) == null || actionGroup.length <= 0) break block3;
            actionPanel = new JPanel();
            actionPanel.setOpaque(false);
            actionPanel.setLayout(new BoxLayout(actionPanel, 0));
            for (int index = 0; index < actionGroup.length; ++index) {
                actionPanel.add(DockingManager.getComponentFactory().createIconButton(actionGroup[index]));
            }
        }
        return actionPanel;
    }

    private void setSizes() {
        int preferredWidth = this.calculatePreferredWidth();
        int maximumWidth = this.getHeaderMaximumWidth();
        this.setMaximumSize(new Dimension(maximumWidth, this.getHeaderHeight()));
        this.setMinimumSize(new Dimension(preferredWidth, this.getHeaderHeight()));
        this.preferredSize = new Dimension(preferredWidth, this.getHeaderHeight());
    }

    protected int calculatePreferredWidth() {
        int icon = 0;
        if (this.iconLabel != null) {
            icon = this.iconLabel.getPreferredSize().width;
        }
        int action = 0;
        if (this.actionPanel != null) {
            for (int index = 0; index < this.actionPanel.getComponentCount(); ++index) {
                action += this.actionPanel.getComponent((int)index).getPreferredSize().width;
            }
        }
        int selectedAction = 0;
        if (this.selected && this.selectedActionPanel != null) {
            for (int index = 0; index < this.selectedActionPanel.getComponentCount(); ++index) {
                selectedAction += this.selectedActionPanel.getComponent((int)index).getPreferredSize().width;
            }
        }
        if (action > selectedAction) {
            selectedAction = action;
        }
        return 12 + icon + this.titleLabel.getPreferredSize().width + selectedAction;
    }

    private class DockableChangeListener
    implements PropertyChangeListener {
        private DockableChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ((propertyChangeEvent.getPropertyName().equals(SelectableDockableHeader.DOCKABLE_DESCRIPTION_PROPERTY) || propertyChangeEvent.getPropertyName().equals(SelectableDockableHeader.DOCKABLE_TITLE_PROPERTY) || propertyChangeEvent.getPropertyName().equals(SelectableDockableHeader.DOCKABLE_ICON_PROPERTY)) && SelectableDockableHeader.this.iconLabel != null) {
                SelectableDockableHeader.this.iconLabel.setIcon(SelectableDockableHeader.this.dockable.getIcon());
            }
            if (SelectableDockableHeader.this.titleLabel != null) {
                SelectableDockableHeader.this.titleLabel.setText(SelectableDockableHeader.this.dockable.getTitle());
            }
            SelectableDockableHeader.this.revalidate();
            SelectableDockableHeader.this.repaint();
        }
    }
}

