/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.component;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class WindowResizer
implements MouseMotionListener,
MouseListener {
    private static final int RESIZE_BORDER = 3;
    private static final int RESIZE_CORNER = 10;
    private Window window;
    private int currentCursorDirection = 0;
    private Cursor oldCursor;
    private int startX;
    private int startY;
    private int startWidth;
    private int startHeight;

    public WindowResizer(Window window) {
        if (window == null) {
            throw new NullPointerException("Window null");
        }
        this.window = window;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        this.startX = mouseEvent.getPoint().x;
        this.startY = mouseEvent.getPoint().y;
        this.startWidth = component.getWidth();
        this.startHeight = component.getHeight();
        this.currentCursorDirection = this.getCursorDirection(component, this.startX, this.startY);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.currentCursorDirection != 0 && !this.window.isValid()) {
            this.window.validate();
        }
        this.currentCursorDirection = 0;
        this.window.setCursor(this.oldCursor);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        this.oldCursor = component.getCursor();
        component.setCursor(this.retrieveCursor(mouseEvent));
    }

    public void mouseExited(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        if (this.oldCursor != null) {
            component.setCursor(this.oldCursor);
        } else {
            component.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        component.setCursor(this.retrieveCursor(mouseEvent));
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.currentCursorDirection != 0) {
            this.resizeWindow(mouseEvent);
        }
    }

    private void resizeWindow(MouseEvent mouseEvent) {
        int minHeight;
        int mouseX = mouseEvent.getPoint().x;
        int mouseY = mouseEvent.getPoint().y;
        Rectangle newBounds = new Rectangle(this.window.getBounds());
        Rectangle oldBounds = new Rectangle(this.window.getBounds());
        int minWidth = this.window.getMinimumSize().width;
        if (minWidth < 100) {
            minWidth = 100;
        }
        if ((minHeight = this.window.getMinimumSize().height) < 30) {
            minHeight = 30;
        }
        switch (this.currentCursorDirection) {
            case 11: {
                this.changeEast(newBounds, mouseX, minWidth);
                break;
            }
            case 9: {
                this.changeSouth(newBounds, mouseY, minHeight);
                break;
            }
            case 10: {
                this.changeWest(newBounds, mouseX, minWidth);
                break;
            }
            case 8: {
                this.changeNorth(newBounds, mouseY, minHeight);
                break;
            }
            case 7: {
                this.changeNorth(newBounds, mouseY, minHeight);
                this.changeEast(newBounds, mouseX, minWidth);
                break;
            }
            case 5: {
                this.changeSouth(newBounds, mouseY, minHeight);
                this.changeEast(newBounds, mouseX, minWidth);
                break;
            }
            case 6: {
                this.changeNorth(newBounds, mouseY, minHeight);
                this.changeWest(newBounds, mouseX, minWidth);
                break;
            }
            case 4: {
                this.changeSouth(newBounds, mouseY, minHeight);
                this.changeWest(newBounds, mouseX, minWidth);
                break;
            }
        }
        if (!newBounds.equals(oldBounds)) {
            this.window.setBounds(newBounds);
            if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                this.window.validate();
            }
        }
    }

    private void changeNorth(Rectangle newBounds, int mouseY, int minHeight) {
        int newHeight = newBounds.height - (mouseY - this.startY);
        int newY = newBounds.getLocation().y + (mouseY - this.startY);
        if (newHeight < minHeight) {
            newY -= minHeight - newHeight;
            newHeight = minHeight;
        }
        newBounds.setBounds(newBounds.getLocation().x, newY, newBounds.width, newHeight);
    }

    private void changeSouth(Rectangle newBounds, int mouseY, int minHeight) {
        int newHeight = this.startHeight + (mouseY - this.startY);
        if (newHeight < minHeight) {
            newHeight = minHeight;
        }
        newBounds.setSize(newBounds.width, newHeight);
    }

    private void changeEast(Rectangle newBounds, int mouseX, int minWidth) {
        int newWidth = this.startWidth + (mouseX - this.startX);
        if (newWidth < minWidth) {
            newWidth = minWidth;
        }
        newBounds.setSize(newWidth, newBounds.height);
    }

    private void changeWest(Rectangle newBounds, int mouseX, int minWidth) {
        int newWidth = newBounds.width - (mouseX - this.startX);
        int newX = newBounds.getLocation().x + (mouseX - this.startX);
        if (newWidth < minWidth) {
            newX -= minWidth - newWidth;
            newWidth = minWidth;
        }
        newBounds.setBounds(newX, newBounds.getLocation().y, newWidth, newBounds.height);
    }

    private Cursor retrieveCursor(MouseEvent mouseEvent) {
        int cursor = this.getCursorDirection((Component)mouseEvent.getSource(), mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        if (cursor != 0) {
            return Cursor.getPredefinedCursor(cursor);
        }
        return this.oldCursor;
    }

    private int getCursorDirection(Component component, int x, int y) {
        int width = component.getSize().width;
        int height = component.getSize().height;
        if (0 <= y && y <= 10 && 0 <= x && x <= 10) {
            return 6;
        }
        if (0 <= y && y <= 10 && width - 10 <= x && x <= width) {
            return 7;
        }
        if (height - 10 <= y && y <= height && 0 <= x && x <= 10) {
            return 4;
        }
        if (height - 10 <= y && y <= height && width - 10 <= x && x <= width) {
            return 5;
        }
        if (0 <= y && y <= 3 && 0 <= x && x <= width) {
            return 8;
        }
        if (height - 3 <= y && y <= height && 0 <= x && x <= width) {
            return 9;
        }
        if (0 <= x && x <= 3 && 0 <= y && y <= height) {
            return 10;
        }
        if (width - 3 <= x && x <= width && 0 <= y && y <= height) {
            return 11;
        }
        return 0;
    }
}

