/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock;

import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.LineDock;
import com.javadocking.dock.Position;
import com.javadocking.dock.factory.DockFactory;
import com.javadocking.dock.factory.LeafDockFactory;
import com.javadocking.dock.factory.SingleDockFactory;
import com.javadocking.dockable.Dockable;
import com.javadocking.event.ChildDockEvent;
import com.javadocking.event.DockingEventSupport;
import com.javadocking.event.DockingListener;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;

public class BorderDock
extends JPanel
implements CompositeDock {
    public static final int MODE_GENERAL = 0;
    public static final int MODE_TOOL_BAR = 1;
    public static final int MODE_MINIMIZE_BAR = 2;
    private static final double leftDockingRectangleRelativeWidth = 0.25;
    private static final double rightDockingRectangleRelativeWidth = 0.25;
    private static final double topDockingRectangleRelativeHeight = 0.25;
    private static final double bottomDockingRectangleRelativeHeight = 0.25;
    private static final double leftPriorityRectangleRelativeWidth = 0.125;
    private static final double rightPriorityRectangleRelativeWidth = 0.125;
    private static final double topPriorityRectangleRelativeHeight = 0.125;
    private static final double bottomPriorityRectangleRelativeHeight = 0.125;
    private CompositeDock parentDock;
    private int topDockingMode = 4;
    private int bottomDockingMode = 8;
    private int leftDockingMode = 1;
    private int rightDockingMode = 2;
    private Component centerComponent;
    private Dock centerChildDock;
    private Dock leftChildDock;
    private Dock rightChildDock;
    private Dock topChildDock;
    private Dock bottomChildDock;
    private DockFactory childDockFactory;
    private DockingEventSupport dockingEventSupport = new DockingEventSupport();
    private Rectangle priorityRectangle = new Rectangle();
    private Dock ghostChild;

    public BorderDock() {
        this(new LeafDockFactory());
    }

    public BorderDock(Dock centerChildDock) {
        this(new LeafDockFactory(), centerChildDock);
    }

    public BorderDock(DockFactory childDockFactory) {
        super(new BorderLayout());
        if (childDockFactory == null) {
            throw new IllegalArgumentException("The child dock factory cannot be null.");
        }
        this.childDockFactory = childDockFactory;
    }

    public BorderDock(DockFactory childDockFactory, Dock centerChildDock) {
        super(new BorderLayout());
        if (childDockFactory == null) {
            throw new IllegalArgumentException("The child dock factory cannot be null.");
        }
        this.childDockFactory = childDockFactory;
        this.addChildDock(centerChildDock, new Position(0));
    }

    public int getDockPriority(Dockable dockable, Point relativeLocation) {
        int dockPosition;
        int dockingMode;
        if (!this.checkDockingModes(dockable)) {
            return 0;
        }
        if (this.isFull()) {
            return 0;
        }
        int dockingModes = dockable.getDockingModes();
        if ((dockingModes & (dockingMode = this.getDockingMode(dockPosition = this.getDockPosition(relativeLocation)))) != 0 && this.isFree(dockPosition) && this.getChildDockFactory().createDock(dockable, dockingMode) != null) {
            if (this.canAddDockableWithPriority(dockable, relativeLocation)) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public int retrieveDockingRectangle(Dockable dockable, Point relativeLocation, Point dockableOffset, Rectangle rectangle) {
        int priority = this.getDockPriority(dockable, relativeLocation);
        if (priority != 0) {
            int position = this.getDockPosition(relativeLocation);
            int dockingMode = this.getDockingMode(position);
            Dimension preferredSize = this.childDockFactory.getDockPreferredSize(dockable, dockingMode);
            Dimension centerSize = new Dimension(0, 0);
            Point centerLocation = new Point();
            if (this.centerChildDock != null) {
                centerSize = ((Component)((Object)this.centerChildDock)).getSize();
                centerLocation = ((Component)((Object)this.centerChildDock)).getLocation();
            } else if (this.centerComponent != null) {
                centerSize = this.centerComponent.getSize();
                centerLocation = this.centerComponent.getLocation();
            }
            if (position == 1) {
                int dockingWidth = this.getChildDockWidth(preferredSize.width, this.getSize().width, position);
                int dockingHeight = centerSize.height;
                int dockingY = centerLocation.y;
                rectangle.setBounds(0, dockingY, dockingWidth, dockingHeight);
            } else if (position == 2) {
                int dockingWidth = this.getChildDockWidth(preferredSize.width, this.getSize().width, position);
                int dockingHeight = centerSize.height;
                int dockingY = centerLocation.y;
                rectangle.setBounds(this.getSize().width - dockingWidth, dockingY, dockingWidth, dockingHeight);
            } else if (position == 3) {
                int dockingHeight = this.getChildDockWidth(preferredSize.height, this.getSize().height, position);
                rectangle.setBounds(0, 0, this.getSize().width, dockingHeight);
            } else if (position == 4) {
                int dockingHeight = this.getChildDockWidth(preferredSize.height, this.getSize().height, position);
                rectangle.setBounds(0, this.getSize().height - dockingHeight, this.getSize().width, dockingHeight);
            }
        }
        return priority;
    }

    public boolean addDockable(Dockable dockableToAdd, Point relativeLocation, Point dockableOffset) {
        if (this.getDockPriority(dockableToAdd, relativeLocation) == 0) {
            return false;
        }
        int dockPosition = this.getDockPosition(relativeLocation);
        int dockingMode = this.getDockingMode(dockPosition);
        Dock childDock = this.childDockFactory.createDock(dockableToAdd, dockingMode);
        childDock.setParentDock(this);
        childDock.addDockable(dockableToAdd, new Point(0, 0), new Point(0, 0));
        int position = this.getDockPosition(relativeLocation);
        this.addChildDock(childDock, new Position(position));
        SwingUtil.repaintParent(this);
        return true;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isFull() {
        return (this.centerChildDock != null || this.centerComponent != null) && this.leftChildDock != null && this.rightChildDock != null && this.topChildDock != null && this.bottomChildDock != null;
    }

    public CompositeDock getParentDock() {
        return this.parentDock;
    }

    public void setParentDock(CompositeDock parentDock) {
        this.parentDock = parentDock;
    }

    public void saveProperties(String prefix, Properties properties, Map childDockIds) {
        String className = this.childDockFactory.getClass().getName();
        PropertiesUtil.setString(properties, prefix + "childDockFactory", className);
        this.childDockFactory.saveProperties(prefix + "childDockFactory.", properties);
        this.savePosition(this.centerChildDock, prefix, properties, childDockIds);
        this.savePosition(this.leftChildDock, prefix, properties, childDockIds);
        this.savePosition(this.rightChildDock, prefix, properties, childDockIds);
        this.savePosition(this.topChildDock, prefix, properties, childDockIds);
        this.savePosition(this.bottomChildDock, prefix, properties, childDockIds);
        PropertiesUtil.setInteger(properties, prefix + "leftDockingMode", this.leftDockingMode);
        PropertiesUtil.setInteger(properties, prefix + "rightDockingMode", this.rightDockingMode);
        PropertiesUtil.setInteger(properties, prefix + "topDockingMode", this.topDockingMode);
        PropertiesUtil.setInteger(properties, prefix + "bottomDockingMode", this.bottomDockingMode);
    }

    public void loadProperties(String prefix, Properties properties, Map childDocks, Map dockablesMap, Window owner) throws IOException {
        int leftDockingMode = 1;
        int rightDockingMode = 2;
        int topDockingMode = 4;
        int bottomDockingMode = 8;
        leftDockingMode = PropertiesUtil.getInteger(properties, prefix + "leftDockingMode", leftDockingMode);
        rightDockingMode = PropertiesUtil.getInteger(properties, prefix + "rightDockingMode", rightDockingMode);
        topDockingMode = PropertiesUtil.getInteger(properties, prefix + "topDockingMode", topDockingMode);
        bottomDockingMode = PropertiesUtil.getInteger(properties, prefix + "bottomDockingMode", bottomDockingMode);
        this.setLeftDockingMode(leftDockingMode);
        this.setRightDockingMode(rightDockingMode);
        this.setTopDockingMode(topDockingMode);
        this.setBottomDockingMode(bottomDockingMode);
        try {
            String className = SingleDockFactory.class.getName();
            className = PropertiesUtil.getString(properties, prefix + "childDockFactory", className);
            Class<?> clazz = Class.forName(className);
            this.childDockFactory = (DockFactory)clazz.newInstance();
            this.childDockFactory.loadProperties(prefix + "childDockFactory.", properties);
        }
        catch (ClassNotFoundException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        catch (IllegalAccessException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        catch (InstantiationException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        if (childDocks != null) {
            Iterator iterator = childDocks.keySet().iterator();
            while (iterator.hasNext()) {
                String childDockId = (String)iterator.next();
                Dock childDock = (Dock)childDocks.get(childDockId);
                Position position = null;
                position = Position.getPositionProperty(properties, prefix + "childDock" + childDockId + "." + "position", position);
                this.addChildDock(childDock, position);
            }
        }
    }

    public void addDockingListener(DockingListener listener) {
        this.dockingEventSupport.addDockingListener(listener);
    }

    public void removeDockingListener(DockingListener listener) {
        this.dockingEventSupport.removeDockingListener(listener);
    }

    public void addChildDock(Dock dock, Position position) throws IllegalStateException {
        if (this.isFull()) {
            throw new IllegalStateException("This dock is full.");
        }
        this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, null, this, dock));
        int borderPosition = this.verifyPosition(position);
        boolean added = false;
        if (borderPosition == 0 && this.centerChildDock == null && this.centerComponent == null) {
            this.centerChildDock = dock;
            this.centerChildDock.setParentDock(this);
            this.add((Component)((Object)this.centerChildDock), "Center");
            added = true;
        } else if (borderPosition == 3 && this.topChildDock == null) {
            this.topChildDock = dock;
            this.topChildDock.setParentDock(this);
            this.add((Component)((Object)this.topChildDock), "North");
            added = true;
        } else if (borderPosition == 4 && this.bottomChildDock == null) {
            this.bottomChildDock = dock;
            this.bottomChildDock.setParentDock(this);
            this.add((Component)((Object)this.bottomChildDock), "South");
            added = true;
        } else if (borderPosition == 1 && this.leftChildDock == null) {
            this.leftChildDock = dock;
            this.leftChildDock.setParentDock(this);
            this.add((Component)((Object)this.leftChildDock), "West");
            added = true;
        } else if (borderPosition == 2 && this.rightChildDock == null) {
            this.rightChildDock = dock;
            this.rightChildDock.setParentDock(this);
            this.add((Component)((Object)this.rightChildDock), "East");
            added = true;
        }
        if (!added) {
            if (this.centerChildDock == null && this.centerComponent != null) {
                this.centerChildDock = dock;
                this.centerChildDock.setParentDock(this);
                this.add((Component)((Object)this.centerChildDock), "Center");
                added = true;
            } else if (this.topChildDock == null) {
                this.topChildDock = dock;
                this.topChildDock.setParentDock(this);
                this.add((Component)((Object)this.topChildDock), "North");
                added = true;
            } else if (this.bottomChildDock == null) {
                this.bottomChildDock = dock;
                this.bottomChildDock.setParentDock(this);
                this.add((Component)((Object)this.bottomChildDock), "South");
                added = true;
            } else if (this.leftChildDock == null) {
                this.leftChildDock = dock;
                this.leftChildDock.setParentDock(this);
                this.add((Component)((Object)this.leftChildDock), "West");
                added = true;
            } else if (this.rightChildDock == null) {
                this.rightChildDock = dock;
                this.rightChildDock.setParentDock(this);
                this.add((Component)((Object)this.rightChildDock), "East");
                added = true;
            }
        }
        if (!added) {
            throw new IllegalStateException("The dock is not full, but all the positions are occupied.");
        }
        this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, null, this, dock));
        SwingUtil.repaintParent(this);
    }

    public int getChildDockCount() {
        int count = 0;
        if (this.centerChildDock != null) {
            ++count;
        }
        if (this.leftChildDock != null) {
            ++count;
        }
        if (this.rightChildDock != null) {
            ++count;
        }
        if (this.topChildDock != null) {
            ++count;
        }
        if (this.bottomChildDock != null) {
            ++count;
        }
        return count;
    }

    public Dock getChildDock(int index) throws IndexOutOfBoundsException {
        int count = 0;
        if (this.centerChildDock != null) {
            if (index == count) {
                return this.centerChildDock;
            }
            ++count;
        }
        if (this.leftChildDock != null) {
            if (index == count) {
                return this.leftChildDock;
            }
            ++count;
        }
        if (this.rightChildDock != null) {
            if (index == count) {
                return this.rightChildDock;
            }
            ++count;
        }
        if (this.topChildDock != null) {
            if (index == count) {
                return this.topChildDock;
            }
            ++count;
        }
        if (this.bottomChildDock != null) {
            if (index == count) {
                return this.bottomChildDock;
            }
            ++count;
        }
        throw new IndexOutOfBoundsException("Index " + index);
    }

    public Position getChildDockPosition(Dock childDock) throws IllegalArgumentException {
        if (childDock.equals(this.centerChildDock)) {
            return new Position(0);
        }
        if (childDock.equals(this.leftChildDock)) {
            return new Position(1);
        }
        if (childDock.equals(this.rightChildDock)) {
            return new Position(2);
        }
        if (childDock.equals(this.topChildDock)) {
            return new Position(3);
        }
        if (childDock.equals(this.bottomChildDock)) {
            return new Position(4);
        }
        throw new IllegalArgumentException("The dock is not docked in this composite dock.");
    }

    public void emptyChild(Dock emptyChildDock) {
        if (this.centerChildDock != null && this.centerChildDock.equals(emptyChildDock)) {
            return;
        }
        this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, emptyChildDock));
        if (this.leftChildDock != null && this.leftChildDock.equals(emptyChildDock)) {
            this.remove((Component)((Object)this.leftChildDock));
            this.leftChildDock = null;
        } else if (this.rightChildDock != null && this.rightChildDock.equals(emptyChildDock)) {
            this.remove((Component)((Object)this.rightChildDock));
            this.rightChildDock = null;
        } else if (this.topChildDock != null && this.topChildDock.equals(emptyChildDock)) {
            this.remove((Component)((Object)this.topChildDock));
            this.topChildDock = null;
        } else if (this.bottomChildDock != null && this.bottomChildDock.equals(emptyChildDock)) {
            this.remove((Component)((Object)this.bottomChildDock));
            this.bottomChildDock = null;
        }
        this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, emptyChildDock));
        SwingUtil.repaintParent(this);
    }

    public void ghostChild(Dock childDock) {
        if (this.centerChildDock != null && this.centerChildDock.equals(childDock)) {
            return;
        }
        this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, childDock));
        if (this.leftChildDock != null && this.leftChildDock.equals(childDock)) {
            this.ghostChild = this.leftChildDock;
            ((Component)((Object)this.ghostChild)).setVisible(false);
            this.leftChildDock = null;
        } else if (this.rightChildDock != null && this.rightChildDock.equals(childDock)) {
            this.ghostChild = this.rightChildDock;
            ((Component)((Object)this.ghostChild)).setVisible(false);
            this.rightChildDock = null;
        } else if (this.topChildDock != null && this.topChildDock.equals(childDock)) {
            this.ghostChild = this.topChildDock;
            ((Component)((Object)this.ghostChild)).setVisible(false);
            this.topChildDock = null;
        } else if (this.bottomChildDock != null && this.bottomChildDock.equals(childDock)) {
            this.ghostChild = this.bottomChildDock;
            ((Component)((Object)this.ghostChild)).setVisible(false);
            this.bottomChildDock = null;
        }
        SwingUtil.repaintParent(this);
    }

    public void clearGhosts() {
        if (this.ghostChild != null) {
            this.remove((Component)((Object)this.ghostChild));
            Dock oldGhostChild = this.ghostChild;
            this.ghostChild = null;
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, oldGhostChild));
        }
    }

    public DockFactory getChildDockFactory() {
        return this.childDockFactory;
    }

    public void setChildDockFactory(DockFactory childDockFactory) {
        if (childDockFactory == null) {
            throw new IllegalArgumentException("The child dock factory cannot be null.");
        }
        this.childDockFactory = childDockFactory;
    }

    public Dock getChildDockOfPosition(int position) {
        if (position == 0) {
            return this.centerChildDock;
        }
        if (position == 4) {
            return this.bottomChildDock;
        }
        if (position == 3) {
            return this.topChildDock;
        }
        if (position == 1) {
            return this.leftChildDock;
        }
        if (position == 2) {
            return this.rightChildDock;
        }
        throw new IllegalArgumentException("Illegal position.");
    }

    protected int getDockPosition(Point relativePosition) {
        Dimension dimension = this.getSize();
        int halfWidth = dimension.width / 2;
        int halfHeight = dimension.height / 2;
        if (relativePosition.x < halfWidth) {
            if (relativePosition.y < halfHeight) {
                if (relativePosition.x < relativePosition.y) {
                    return 1;
                }
                return 3;
            }
            if (relativePosition.x < dimension.height - relativePosition.y) {
                return 1;
            }
            return 4;
        }
        if (relativePosition.y < halfHeight) {
            if (dimension.width - relativePosition.x < relativePosition.y) {
                return 2;
            }
            return 3;
        }
        if (dimension.width - relativePosition.x < dimension.height - relativePosition.y) {
            return 2;
        }
        return 4;
    }

    protected void getPriorityRectangle(Rectangle rectangle, int position) {
        Dimension size = this.getSize();
        switch (position) {
            case 1: {
                int y = 0;
                int height = 0;
                if (this.centerChildDock != null) {
                    y = ((Component)((Object)this.centerChildDock)).getLocation().y;
                    height = ((Component)((Object)this.centerChildDock)).getHeight();
                } else {
                    y = this.centerComponent.getLocation().y;
                    height = this.centerComponent.getHeight();
                }
                rectangle.setBounds(0, y, (int)((double)size.width * 0.125), height);
                break;
            }
            case 2: {
                int y = 0;
                int height = 0;
                if (this.centerChildDock != null) {
                    y = ((Component)((Object)this.centerChildDock)).getLocation().y;
                    height = ((Component)((Object)this.centerChildDock)).getHeight();
                } else {
                    y = this.centerComponent.getLocation().y;
                    height = this.centerComponent.getHeight();
                }
                rectangle.setBounds((int)((double)size.width * 0.875), y, (int)((double)size.width * 0.125), height);
                break;
            }
            case 3: {
                rectangle.setBounds(0, 0, size.width, (int)((double)size.height * 0.125));
                break;
            }
            case 4: {
                rectangle.setBounds(0, (int)((double)size.height * 0.875), size.width, (int)((double)size.height * 0.125));
            }
        }
    }

    protected void getDockingRectangle(Rectangle rectangle, int position) {
        Dimension size = this.getSize();
        switch (position) {
            case 1: {
                rectangle.setBounds(0, 0, (int)((double)size.width * 0.25), size.height);
                break;
            }
            case 2: {
                rectangle.setBounds((int)((double)size.width * 0.25), 0, (int)((double)size.width * 0.75), size.height);
                break;
            }
            case 3: {
                rectangle.setBounds(0, 0, size.width, (int)((double)size.height * 0.25));
                break;
            }
            case 4: {
                rectangle.setBounds(0, (int)((double)size.height * 0.25), size.width, (int)((double)size.height * 0.75));
            }
        }
    }

    private void savePosition(Dock childDock, String prefix, Properties properties, Map childDockIds) {
        if (childDock != null) {
            String childDockKey = (String)childDockIds.get(childDock);
            Position.setPositionProperty(properties, prefix + "childDock" + childDockKey + "." + "position", this.getChildDockPosition(childDock));
        }
    }

    private int verifyPosition(Position position) {
        int possiblePosition;
        if (this.isFull()) {
            throw new IllegalStateException("This dock is full.");
        }
        int borderPosition = 2;
        if (position != null && position.getDimensions() == 1 && ((possiblePosition = position.getPosition(0)) == 0 || possiblePosition == 1 || possiblePosition == 2 || possiblePosition == 3 || possiblePosition == 4)) {
            borderPosition = possiblePosition;
        }
        if (this.isFree(borderPosition)) {
            return borderPosition;
        }
        int[] alternatePositions = this.getAlternatePositions(borderPosition);
        for (int index = 0; index < alternatePositions.length; ++index) {
            if (!this.isFree(alternatePositions[index])) continue;
            return alternatePositions[index];
        }
        throw new IllegalStateException("We should never come here.");
    }

    protected boolean isFree(int position) {
        if (position == 0) {
            return this.centerChildDock == null;
        }
        if (position == 1) {
            return this.leftChildDock == null;
        }
        if (position == 2) {
            return this.rightChildDock == null;
        }
        if (position == 3) {
            return this.topChildDock == null;
        }
        if (position == 4) {
            return this.bottomChildDock == null;
        }
        throw new IllegalArgumentException("Illegal position for a border dock [" + position + "].");
    }

    public Component getCenterComponent() {
        return this.centerComponent;
    }

    public void setCenterComponent(Component centerComponent) {
        if (this.centerChildDock != null) {
            throw new IllegalStateException("There is already a dock in the center of the border dock.");
        }
        if (this.centerComponent != null) {
            throw new IllegalStateException("There is already a component in the center of the border dock.");
        }
        this.centerComponent = centerComponent;
        this.add(centerComponent, "Center");
    }

    public void removeCenterComponent() {
        if (this.centerComponent == null) {
            throw new IllegalStateException("There is no component in the center of the border dock.");
        }
        if (this.centerComponent != null) {
            this.remove(this.centerComponent);
            this.centerComponent = null;
        }
    }

    private int[] getAlternatePositions(int position) {
        if (position == 0) {
            int[] positions = new int[]{1, 2, 3, 4};
            return positions;
        }
        if (position == 1) {
            int[] positions = new int[]{2, 3, 4, 0};
            return positions;
        }
        if (position == 2) {
            int[] positions = new int[]{1, 3, 4, 0};
            return positions;
        }
        if (position == 3) {
            int[] positions = new int[]{4, 1, 2, 0};
            return positions;
        }
        if (position == 4) {
            int[] positions = new int[]{3, 1, 2, 0};
            return positions;
        }
        throw new IllegalArgumentException("Illegal position for a border dock [" + position + "].");
    }

    public int getBottomDockingMode() {
        return this.bottomDockingMode;
    }

    public void setBottomDockingMode(int bottomDockingMode) {
        this.bottomDockingMode = bottomDockingMode;
    }

    public int getLeftDockingMode() {
        return this.leftDockingMode;
    }

    public void setLeftDockingMode(int leftDockingMode) {
        this.leftDockingMode = leftDockingMode;
    }

    public int getRightDockingMode() {
        return this.rightDockingMode;
    }

    public void setRightDockingMode(int rightDockingMode) {
        this.rightDockingMode = rightDockingMode;
    }

    public int getTopDockingMode() {
        return this.topDockingMode;
    }

    public void setTopDockingMode(int topDockingMode) {
        this.topDockingMode = topDockingMode;
    }

    private boolean checkDockingModes(Dockable dockable) {
        int dockPositions = dockable.getDockingModes();
        return (dockPositions & this.topDockingMode) != 0 || (dockPositions & this.rightDockingMode) != 0 || (dockPositions & this.leftDockingMode) != 0 || (dockPositions & this.bottomDockingMode) != 0;
    }

    private boolean canAddDockableWithPriority(Dockable dockable, Point relativeLocation) {
        int dockModes = dockable.getDockingModes();
        if ((dockModes & this.leftDockingMode) != 0 && this.getChildDockOfPosition(1) == null) {
            this.getPriorityRectangle(this.priorityRectangle, 1);
            if (this.priorityRectangle.contains(relativeLocation)) {
                return true;
            }
        }
        if ((dockModes & this.rightDockingMode) != 0 && this.getChildDockOfPosition(2) == null) {
            this.getPriorityRectangle(this.priorityRectangle, 2);
            if (this.priorityRectangle.contains(relativeLocation)) {
                return true;
            }
        }
        if ((dockModes & this.topDockingMode) != 0 && this.getChildDockOfPosition(3) == null) {
            this.getPriorityRectangle(this.priorityRectangle, 3);
            if (this.priorityRectangle.contains(relativeLocation)) {
                return true;
            }
        }
        if ((dockModes & this.bottomDockingMode) != 0 && this.getChildDockOfPosition(4) == null) {
            this.getPriorityRectangle(this.priorityRectangle, 4);
            if (this.priorityRectangle.contains(relativeLocation)) {
                return true;
            }
        }
        return false;
    }

    public int getDockingMode(int dockPosition) {
        switch (dockPosition) {
            case 3: {
                return this.topDockingMode;
            }
            case 4: {
                return this.bottomDockingMode;
            }
            case 1: {
                return this.leftDockingMode;
            }
            case 2: {
                return this.rightDockingMode;
            }
            case 0: {
                return 128;
            }
        }
        throw new IllegalArgumentException("Position [" + dockPosition + "] is not a valid position in a BorderDock.");
    }

    protected int getChildDockWidth(int preferredWidth, int totalWidth, int position) {
        if (preferredWidth < totalWidth / 2) {
            return preferredWidth;
        }
        return totalWidth / 2;
    }

    public void setDock(Dock dock, int position) {
        if (dock instanceof LineDock) {
            LineDock lineDock = (LineDock)dock;
            if (position == 3) {
                lineDock.setOrientation(0);
            } else if (position == 4) {
                lineDock.setOrientation(0);
            } else if (position == 1) {
                lineDock.setOrientation(1);
            } else if (position == 2) {
                lineDock.setOrientation(1);
            }
        }
        this.addChildDock(dock, new Position(position));
    }

    public void setMode(int mode) {
        switch (mode) {
            case 0: {
                this.setTopDockingMode(4);
                this.setBottomDockingMode(8);
                this.setLeftDockingMode(1);
                this.setRightDockingMode(2);
                break;
            }
            case 1: {
                this.setTopDockingMode(2048);
                this.setBottomDockingMode(2048);
                this.setLeftDockingMode(4096);
                this.setRightDockingMode(4096);
                break;
            }
            case 2: {
                this.setTopDockingMode(16384);
                this.setBottomDockingMode(16384);
                this.setLeftDockingMode(32768);
                this.setRightDockingMode(32768);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode.");
            }
        }
    }
}

