/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock.factory;

import com.javadocking.dock.Dock;
import com.javadocking.dock.SingleDock;
import com.javadocking.dock.factory.DockFactory;
import com.javadocking.dock.factory.LeafDockFactory;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.util.PropertiesUtil;
import java.awt.Dimension;
import java.util.Properties;

public class SingleDockFactory
implements DockFactory {
    private DockFactory alternativeDockFactory = new LeafDockFactory();

    public SingleDockFactory() {
        this(new LeafDockFactory());
    }

    public SingleDockFactory(DockFactory alternativeDockFactory) {
        this.alternativeDockFactory = alternativeDockFactory;
    }

    public Dock createDock(Dockable dockable, int dockingMode) {
        int dockingModes = dockable.getDockingModes();
        if ((dockingModes & 0x40) != 0) {
            if (dockable instanceof CompositeDockable) {
                CompositeDockable compositeDockable = (CompositeDockable)dockable;
                if (compositeDockable.getDockableCount() == 1) {
                    return new SingleDock();
                }
            } else {
                return new SingleDock();
            }
        }
        if (this.alternativeDockFactory != null) {
            return this.alternativeDockFactory.createDock(dockable, dockingMode);
        }
        return null;
    }

    public Dimension getDockPreferredSize(Dockable dockable, int dockingMode) {
        int dockingModes = dockable.getDockingModes();
        if ((dockingModes & 0x40) != 0) {
            if (dockable instanceof CompositeDockable) {
                CompositeDockable compositeDockable = (CompositeDockable)dockable;
                if (compositeDockable.getDockableCount() == 1) {
                    return compositeDockable.getDockable(0).getContent().getPreferredSize();
                }
            } else {
                return dockable.getContent().getPreferredSize();
            }
        }
        if (this.alternativeDockFactory != null) {
            return this.alternativeDockFactory.getDockPreferredSize(dockable, dockingMode);
        }
        return new Dimension(0, 0);
    }

    public void saveProperties(String prefix, Properties properties) {
        if (this.alternativeDockFactory != null) {
            String alternativeDockFactoryClassName = this.alternativeDockFactory.getClass().getName();
            PropertiesUtil.setString(properties, prefix + "alternativeDockFactory", alternativeDockFactoryClassName);
            this.alternativeDockFactory.saveProperties(prefix + "alternativeDockFactory.", properties);
        }
    }

    public void loadProperties(String prefix, Properties properties) {
        try {
            String alternativeDockFactoryClassName = LeafDockFactory.class.getName();
            if (alternativeDockFactoryClassName != null) {
                alternativeDockFactoryClassName = PropertiesUtil.getString(properties, prefix + "alternativeDockFactory", alternativeDockFactoryClassName);
                Class<?> alternativeDockFactoryClazz = Class.forName(alternativeDockFactoryClassName);
                this.alternativeDockFactory = (DockFactory)alternativeDockFactoryClazz.newInstance();
                this.alternativeDockFactory.loadProperties(prefix + "alternativeDockFactory.", properties);
            } else {
                this.alternativeDockFactory = null;
            }
        }
        catch (ClassNotFoundException exception) {
            System.out.println("Could not create the alternative dock factory.");
            exception.printStackTrace();
            this.alternativeDockFactory = new LeafDockFactory();
        }
        catch (IllegalAccessException exception) {
            System.out.println("Could not create the alternative dock factory.");
            exception.printStackTrace();
            this.alternativeDockFactory = new LeafDockFactory();
        }
        catch (InstantiationException exception) {
            System.out.println("Could not create the alternative dock factory.");
            exception.printStackTrace();
            this.alternativeDockFactory = new LeafDockFactory();
        }
    }

    public DockFactory getAlternativeDockFactory() {
        return this.alternativeDockFactory;
    }

    public void setAlternativeDockFactory(DockFactory alternativeDockFactory) {
        if (alternativeDockFactory == null) {
            throw new IllegalArgumentException("The alternative dock factory cannot be null.");
        }
        this.alternativeDockFactory = alternativeDockFactory;
    }
}

