/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dockable;

import com.javadocking.dock.LeafDock;
import com.javadocking.dockable.Dockable;
import com.javadocking.event.DockableEvent;
import com.javadocking.event.DockingListener;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;

public class ActionDockable
implements Dockable {
    private Dockable delegate;
    private Action[][] actionsToAdd;

    public ActionDockable(Dockable delegate) {
        this(delegate, new Action[0][]);
    }

    public ActionDockable(Dockable delegate, Action[][] actionsToAdd) {
        this.delegate = delegate;
        this.actionsToAdd = actionsToAdd;
    }

    public Action[][] getActions() {
        int index;
        Action[][] delegateActions = this.delegate.getActions();
        Action[][] currentActionsToAdd = this.getActionsToAdd();
        if (delegateActions == null) {
            return currentActionsToAdd;
        }
        Action[][] combinedActions = new Action[delegateActions.length + currentActionsToAdd.length][];
        for (index = 0; index < delegateActions.length; ++index) {
            combinedActions[index] = delegateActions[index];
        }
        for (index = 0; index < currentActionsToAdd.length; ++index) {
            combinedActions[delegateActions.length + index] = currentActionsToAdd[index];
        }
        return combinedActions;
    }

    public Component getContent() {
        return this.delegate.getContent();
    }

    public LeafDock getDock() {
        return this.delegate.getDock();
    }

    public int getDockingModes() {
        return this.delegate.getDockingModes();
    }

    public Icon getIcon() {
        return this.delegate.getIcon();
    }

    public String getID() {
        return this.delegate.getID();
    }

    public int getLastDockingMode() {
        return this.delegate.getLastDockingMode();
    }

    public int getPossibleStates() {
        return this.delegate.getPossibleStates();
    }

    public int getState() {
        return this.delegate.getState();
    }

    public String getTitle() {
        return this.delegate.getTitle();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public boolean isWithHeader() {
        return this.delegate.isWithHeader();
    }

    public void setDock(LeafDock dock) {
        this.delegate.setDock(dock);
    }

    public void setLastDockingMode(int dockingMode) {
        this.delegate.setLastDockingMode(dockingMode);
    }

    public Object getVisualizer() {
        return this.delegate.getVisualizer();
    }

    public void setState(int state, Object visualizer) {
        this.delegate.setState(state, visualizer);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.delegate.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.delegate.removePropertyChangeListener(listener);
    }

    public void addDockingListener(DockingListener listener) {
        this.delegate.addDockingListener(listener);
    }

    public void removeDockingListener(DockingListener listener) {
        this.delegate.removeDockingListener(listener);
    }

    public void fireDockingWillChange(DockableEvent dockableEvent) {
        this.delegate.fireDockingWillChange(dockableEvent);
    }

    public void fireDockingChanged(DockableEvent dockableEvent) {
        this.delegate.fireDockingChanged(dockableEvent);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Dockable)) {
            return false;
        }
        Dockable other = (Dockable)object;
        return this.getID().equals(other.getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void setActionsToAdd(Action[][] actions) {
        this.actionsToAdd = actions;
    }

    public Action[][] getActionsToAdd() {
        return this.actionsToAdd;
    }

    public Dockable getDelegate() {
        return this.delegate;
    }
}

