/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dockable;

import com.javadocking.DockingManager;
import com.javadocking.dock.LeafDock;
import com.javadocking.dockable.Dockable;
import com.javadocking.dockable.DraggableContent;
import com.javadocking.drag.DragListener;
import com.javadocking.event.DockableEvent;
import com.javadocking.event.DockingEventSupport;
import com.javadocking.event.DockingListener;
import com.javadocking.visualizer.Externalizer;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Action;
import javax.swing.Icon;

public class DefaultDockable
implements Dockable {
    private String id;
    private Component content;
    private String title;
    private String description;
    private Icon icon;
    private int dockingModes = 2147354623;
    private int lastDockingMode = 0;
    private boolean withHeader = true;
    private LeafDock dock;
    private int possibleStates = 31;
    private int state = 2;
    private Object visualizer;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private DockingEventSupport dockingEventSupport = new DockingEventSupport();

    public DefaultDockable(String id, Component content) {
        this(id, content, "");
    }

    public DefaultDockable(String id, Component content, String title) {
        this(id, content, title, null);
    }

    public DefaultDockable(String id, Component content, String title, Icon icon) {
        this(id, content, title, icon, 2147354623);
    }

    public DefaultDockable(String id, Component content, String title, Icon icon, int dockingModes) {
        if (id == null) {
            throw new IllegalArgumentException("Dockable with ID null.");
        }
        this.id = id;
        if (content == null) {
            throw new IllegalArgumentException("The content of a dockable may not be null.");
        }
        this.content = content;
        if (content instanceof DraggableContent) {
            this.addDraggerInDockable((DraggableContent)((Object)content));
        }
        this.title = title;
        this.icon = icon;
        this.dockingModes = dockingModes;
    }

    public String getID() {
        return this.id;
    }

    public void setDock(LeafDock dock) {
        LeafDock oldValue = this.dock;
        this.dock = dock;
        this.propertyChangeSupport.firePropertyChange("dock", oldValue, dock);
    }

    public LeafDock getDock() {
        return this.dock;
    }

    public Component getContent() {
        return this.content;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getDockingModes() {
        return this.dockingModes;
    }

    public void setLastDockingMode(int dockPosition) {
        this.lastDockingMode = dockPosition;
    }

    public int getLastDockingMode() {
        return this.lastDockingMode;
    }

    public boolean isWithHeader() {
        return this.withHeader;
    }

    public void setState(int state, Object visualizer) {
        this.state = state;
        if (state == 2) {
            this.setDock(null);
        } else if (state == 1) {
            if (!(visualizer instanceof LeafDock)) {
                if (visualizer == null) {
                    throw new NullPointerException("Visualizer is null.");
                }
                throw new IllegalArgumentException("The visualizer should be a com.javadocking.dock.LeafDock when the dockable is in state DockableState.NORMAL, not [" + visualizer.getClass() + "].");
            }
            this.setDock((LeafDock)visualizer);
            this.visualizer = visualizer;
        } else if (state == 16) {
            if (!(visualizer instanceof Externalizer)) {
                if (visualizer == null) {
                    throw new NullPointerException("Visualizer is null.");
                }
                throw new IllegalArgumentException("The visualizer should be a com.javadocking.visualizer.Externalizer when the dockable is in state DockableState.EXTERNALIZED, not [" + visualizer.getClass() + "].");
            }
            this.visualizer = visualizer;
        } else {
            this.visualizer = visualizer;
        }
    }

    public Object getVisualizer() {
        if (this.state == 1) {
            return this.dock;
        }
        if (this.state == 2) {
            return null;
        }
        return this.visualizer;
    }

    public int getState() {
        return this.state;
    }

    public int getPossibleStates() {
        return this.possibleStates;
    }

    public Action[][] getActions() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addDockingListener(DockingListener listener) {
        this.dockingEventSupport.addDockingListener(listener);
    }

    public void removeDockingListener(DockingListener listener) {
        this.dockingEventSupport.removeDockingListener(listener);
    }

    public void fireDockingWillChange(DockableEvent dockableEvent) {
        this.dockingEventSupport.fireDockingWillChange(dockableEvent);
    }

    public void fireDockingChanged(DockableEvent dockableEvent) {
        this.dockingEventSupport.fireDockingChanged(dockableEvent);
    }

    public void setWithHeader(boolean withHeader) {
        this.withHeader = withHeader;
    }

    public void setDockingModes(int dockingModes) {
        this.dockingModes = dockingModes;
    }

    public void setIcon(Icon icon) {
        Icon oldValue = this.icon;
        this.icon = icon;
        this.propertyChangeSupport.firePropertyChange("icon", oldValue, icon);
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        this.propertyChangeSupport.firePropertyChange("title", oldValue, title);
    }

    public void setDescription(String description) {
        String oldValue = this.description;
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", oldValue, description);
    }

    public void setPossibleStates(int possibleStates) {
        this.possibleStates = possibleStates;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Dockable)) {
            return false;
        }
        Dockable other = (Dockable)object;
        return this.getID().equals(other.getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public String toString() {
        return "dockable [" + this.getID() + "]";
    }

    private void addDraggerInDockable(DraggableContent draggableComponent) {
        DragListener dragListener = DockingManager.getDockableDragListenerFactory().createDragListener(this);
        draggableComponent.addDragListener(dragListener);
    }
}

