/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dockable;

import com.javadocking.dockable.ActionDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.dockable.action.DockableStateAction;
import com.javadocking.dockable.action.DockableStateActionFactory;
import java.util.ArrayList;
import javax.swing.Action;

public class StateActionDockable
extends ActionDockable {
    private DockableStateActionFactory dockableStateActionFactory;
    private int[] newDockableStates;
    private Dockable delegate;

    public StateActionDockable(Dockable delegate, DockableStateActionFactory dockableStateActionFactory, int[] newDockableStates) {
        super(delegate);
        if (dockableStateActionFactory == null) {
            throw new IllegalArgumentException("The DockableStateActionFactory is null.");
        }
        this.dockableStateActionFactory = dockableStateActionFactory;
        this.newDockableStates = newDockableStates;
        this.delegate = delegate;
        DockableStateAction[] dockableStateActions = new DockableStateAction[newDockableStates.length];
        for (int stateIndex = 0; stateIndex < dockableStateActions.length; ++stateIndex) {
            dockableStateActions[stateIndex] = dockableStateActionFactory.createDockableStateAction(delegate, newDockableStates[stateIndex]);
        }
        Action[][] actionsToAdd = new Action[][]{dockableStateActions};
    }

    public Action[][] getActionsToAdd() {
        int currentDockableState = this.getState();
        ArrayList<DockableStateAction> dockableStateActions = new ArrayList<DockableStateAction>();
        for (int stateIndex = 0; stateIndex < this.newDockableStates.length; ++stateIndex) {
            int dockableState = this.newDockableStates[stateIndex];
            if (currentDockableState == dockableState) continue;
            DockableStateAction dockableStateAction = this.dockableStateActionFactory.createDockableStateAction(this.delegate, this.newDockableStates[stateIndex]);
            dockableStateActions.add(dockableStateAction);
        }
        Action[] dockableStateActionsArray = new DockableStateAction[dockableStateActions.size()];
        dockableStateActionsArray = dockableStateActions.toArray(dockableStateActionsArray);
        Action[][] actionsToAdd = new Action[][]{dockableStateActionsArray};
        return actionsToAdd;
    }
}

