/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag;

import com.javadocking.DockingManager;
import com.javadocking.dock.Dock;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.DragListener;
import com.javadocking.drag.Dragger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class DefaultDragListener
implements DragListener {
    public static final int NO_MASK = 0;
    private static final int NO_DRAGGING = 0;
    private static final int START_DRAGGING = 1;
    private static final int DRAGGING = 2;
    private static final int DELAY = 150;
    private Dock dock;
    private Dockable dockable;
    private Dragger dragger;
    private int dragState = 0;
    private int cancelButtonMask = 4;
    private int cancelModifierMask = 0;
    private int startButtonMask = 16;
    private int startModifierMask = 0;
    private Timer timer;
    private int eventID = Integer.MIN_VALUE;
    private long eventWhen = Long.MIN_VALUE;

    public DefaultDragListener(Dock dock) {
        if (dock == null) {
            throw new IllegalArgumentException("Dock null.");
        }
        this.dock = dock;
    }

    public DefaultDragListener(Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("Dockable null.");
        }
        this.dockable = dockable;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.eventID == mouseEvent.getID() && this.eventWhen == mouseEvent.getWhen()) {
            return;
        }
        this.eventID = mouseEvent.getID();
        this.eventWhen = mouseEvent.getWhen();
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (this.dragState == 0) {
            if (this.canStartDragging(mouseEvent)) {
                this.dragger = this.createDragger();
                if (this.dragger.startDragging(mouseEvent)) {
                    this.dragState = 1;
                    this.startDragDelay();
                } else {
                    this.dragger = null;
                }
            }
            if (this.dragState == 0 && this.canShowPopup(mouseEvent)) {
                this.dragger = this.createDragger();
                this.dragger.showPopupMenu(mouseEvent);
                this.dragger = null;
            }
        } else if (this.canCancelDragging(mouseEvent)) {
            this.dragger.cancelDragging(mouseEvent);
            this.dragState = 0;
            this.dragger = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.eventID == mouseEvent.getID() && this.eventWhen == mouseEvent.getWhen()) {
            return;
        }
        this.eventID = mouseEvent.getID();
        this.eventWhen = mouseEvent.getWhen();
        if (this.dragState == 2) {
            this.dragger.drag(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.eventID == mouseEvent.getID() && this.eventWhen == mouseEvent.getWhen()) {
            return;
        }
        this.eventID = mouseEvent.getID();
        this.eventWhen = mouseEvent.getWhen();
        if (this.dragState == 2) {
            if (this.canCancelDragging(mouseEvent)) {
                this.dragger.cancelDragging(mouseEvent);
            } else {
                this.dragger.stopDragging(mouseEvent);
            }
        } else if (this.canShowPopup(mouseEvent)) {
            this.dragger = this.createDragger();
            this.dragger.showPopupMenu(mouseEvent);
        }
        this.dragState = 0;
        this.dragger = null;
        this.cancelDragDelay();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public int getCancelButtonMask() {
        return this.cancelButtonMask;
    }

    public void setCancelButtonMask(int cancelButtonMask) {
        this.cancelButtonMask = cancelButtonMask;
    }

    public int getCancelModifierMask() {
        return this.cancelModifierMask;
    }

    public void setCancelModifierMask(int cancelModifierMask) {
        this.cancelModifierMask = cancelModifierMask;
    }

    public int getStartButtonMask() {
        return this.startButtonMask;
    }

    public void setStartButtonMask(int startButtonMask) {
        this.startButtonMask = startButtonMask;
    }

    public int getStartModifierMask() {
        return this.startModifierMask;
    }

    public void setStartModifierMask(int startModifierMask) {
        this.startModifierMask = startModifierMask;
    }

    protected boolean canStartDragging(MouseEvent mouseEvent) {
        boolean buttonOk = false;
        boolean modifierOk = false;
        if (this.startButtonMask == 0) {
            buttonOk = true;
        } else if ((mouseEvent.getModifiers() & this.startButtonMask) != 0) {
            buttonOk = true;
        }
        if (this.startModifierMask == 0) {
            modifierOk = true;
        } else if ((this.startModifierMask & mouseEvent.getModifiersEx()) != 0) {
            modifierOk = true;
        }
        return buttonOk && modifierOk;
    }

    protected boolean canCancelDragging(MouseEvent mouseEvent) {
        boolean buttonOk = false;
        boolean modifierOk = false;
        if (this.cancelButtonMask == 0) {
            buttonOk = false;
        } else if ((mouseEvent.getModifiers() & this.cancelButtonMask) != 0) {
            buttonOk = true;
        }
        if (this.cancelModifierMask == 0) {
            modifierOk = true;
        } else if ((this.cancelModifierMask & mouseEvent.getModifiersEx()) != 0) {
            modifierOk = true;
        }
        return buttonOk && modifierOk;
    }

    protected boolean canShowPopup(MouseEvent mouseEvent) {
        return SwingUtilities.isRightMouseButton(mouseEvent);
    }

    private Dragger createDragger() {
        if (this.dock != null) {
            return DockingManager.getDraggerFactory().createDragger(this.dock);
        }
        if (this.dockable != null) {
            return DockingManager.getDraggerFactory().createDragger(this.dockable);
        }
        throw new IllegalStateException("The dock and dockable are null.");
    }

    private void startDragDelay() {
        ActionListener taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DefaultDragListener.this.dragDelayFinished();
            }
        };
        this.timer = new Timer(150, taskPerformer);
        this.timer.setRepeats(false);
        this.timer.start();
    }

    private void dragDelayFinished() {
        this.timer = null;
        if (this.dragState == 1) {
            this.dragState = 2;
        }
    }

    private void cancelDragDelay() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }
}

