/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag;

import com.javadocking.DockingManager;
import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dock.LeafDock;
import com.javadocking.dock.SingleDock;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.DefaultCompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.DragCursorManager;
import com.javadocking.drag.Dragger;
import com.javadocking.drag.ExternalizedDraggerSupport;
import com.javadocking.drag.dockretriever.DockRetriever;
import com.javadocking.drag.dockretriever.DynamicDockRetriever;
import com.javadocking.util.CollectionUtil;
import com.javadocking.util.DockingUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class DynamicDragger
implements Dragger {
    private static final boolean TEST = false;
    private static final int FLOAT_DELAY = 150;
    private static final int NO_FLOATING = 0;
    private static final int START_FLOATING = 1;
    private static final int FLOATING = 2;
    private DockRetriever dockRetriever = new DynamicDockRetriever();
    private boolean undocked;
    private boolean floating;
    private int floatingDelay = 0;
    private Timer timer;
    private LeafDock originDock;
    private LeafDock previousDock;
    private boolean mouseExitedPreviousDock;
    private Rectangle previousDockRectangle = new Rectangle();
    private LeafDock currentDock;
    private Dock currentRootDock;
    private Dock currentChildOfRootDock;
    private Point screenLocation = new Point();
    private Point locationInDestinationDock = new Point();
    private Rectangle dockableDragRectangle = new Rectangle();
    private Point dockableOffset = new Point();
    private Point helpPoint = new Point();
    private Dockable draggedDockable;
    private Dockable fixedDockable;
    private boolean firstRemoved;
    private CompositeDock dockWithGhost;
    private Set singleDocksWithGhosts = new HashSet();
    private DragCursorManager cursorManager = new DragCursorManager();

    public DynamicDragger() {
    }

    public DynamicDragger(Dockable fixedDockable) {
        if (fixedDockable == null) {
            throw new IllegalArgumentException("Dockable null");
        }
        this.fixedDockable = fixedDockable;
    }

    public boolean startDragging(MouseEvent mouseEvent) {
        Component mouseComponent = (Component)mouseEvent.getSource();
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        this.reset();
        Component pressedComponent = SwingUtilities.getDeepestComponentAt(mouseComponent, x, y);
        LeafDock ancestorDock = (LeafDock)((Object)SwingUtilities.getAncestorOfClass(LeafDock.class, pressedComponent));
        if (ancestorDock.getDockableCount() > 0) {
            if (this.fixedDockable == null) {
                this.originDock = ancestorDock;
                int count = this.originDock.getDockableCount();
                Dimension dockableSize = null;
                if (count > 0) {
                    this.dockableOffset.setLocation(x, y);
                    this.dockableOffset = SwingUtilities.convertPoint(mouseComponent, this.dockableOffset, (Component)((Object)this.originDock));
                    if (count == 1) {
                        this.draggedDockable = this.originDock.getDockable(0);
                        dockableSize = this.draggedDockable.getContent().getPreferredSize();
                    } else {
                        Dockable[] dockables = new Dockable[this.originDock.getDockableCount()];
                        for (int index = 0; index < this.originDock.getDockableCount(); ++index) {
                            dockables[index] = this.originDock.getDockable(index);
                        }
                        this.draggedDockable = new DefaultCompositeDockable(dockables, -1);
                        dockableSize = DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)this.draggedDockable, 16);
                        this.draggedDockable.setDock(this.originDock);
                        this.draggedDockable.setState(1, this.originDock);
                    }
                    if ((double)this.dockableOffset.x > dockableSize.getWidth()) {
                        this.dockableOffset.x = (int)Math.round(dockableSize.getWidth());
                    }
                    if ((double)this.dockableOffset.y > dockableSize.getHeight()) {
                        this.dockableOffset.y = (int)Math.round(dockableSize.getHeight());
                    }
                    this.cursorManager.setCursor(mouseComponent, this.retrieveCanDockCursor());
                    return true;
                }
            } else {
                this.originDock = ancestorDock;
                if (this.originDock.containsDockable(this.fixedDockable)) {
                    this.draggedDockable = this.fixedDockable;
                    this.dockableOffset.setLocation(x, y);
                    this.dockableOffset = SwingUtilities.convertPoint(mouseComponent, this.dockableOffset, this.draggedDockable.getContent());
                    Dimension dockableSize = this.draggedDockable.getContent().getPreferredSize();
                    if ((double)this.dockableOffset.x > dockableSize.getWidth()) {
                        this.dockableOffset.x = (int)Math.round(dockableSize.getWidth());
                    }
                    if ((double)this.dockableOffset.y > dockableSize.getHeight()) {
                        this.dockableOffset.y = (int)Math.round(dockableSize.getHeight());
                    }
                    this.cursorManager.setCursor(mouseComponent, this.retrieveCanDockCursor());
                    return true;
                }
            }
        }
        return false;
    }

    public void drag(MouseEvent mouseEvent) {
        if (this.draggedDockable == null) {
            return;
        }
        this.computeScreenLocation(mouseEvent);
        if (this.draggedDockable.getState() == 16) {
            ExternalizedDraggerSupport.moveExternalizedDockable(this.draggedDockable, this.screenLocation, this.dockableOffset);
            return;
        }
        if (!this.mouseExitedPreviousDock && !this.previousDockRectangle.contains(this.screenLocation)) {
            this.mouseExitedPreviousDock = true;
        }
        this.currentDock = this.draggedDockable.getDock();
        if (this.currentDock == null) {
            this.stopDragging(mouseEvent);
            return;
        }
        Dock[] destinationDocks = this.dockRetriever.retrieveHighestPriorityDock(this.screenLocation, this.draggedDockable);
        if (destinationDocks == null) {
            return;
        }
        Dock destinationDock = destinationDocks[0];
        if (destinationDock != null) {
            if (!destinationDock.equals(this.currentDock)) {
                this.floating = this.isFloating();
                boolean changeDock = this.changeDock(mouseEvent, destinationDock);
                boolean moveInFloat = false;
                if (!changeDock) {
                    if (destinationDocks.length > 1) {
                        destinationDock = destinationDocks[1];
                        if (!destinationDock.equals(this.currentDock)) {
                            changeDock = this.changeDock(mouseEvent, destinationDock);
                        } else if (this.floating) {
                            changeDock = true;
                            moveInFloat = true;
                        }
                    } else if (this.floating) {
                        changeDock = true;
                        moveInFloat = true;
                    }
                }
                if (changeDock) {
                    if (moveInFloat) {
                        destinationDock = this.currentRootDock;
                    }
                    this.locationInDestinationDock.setLocation(this.screenLocation.x, this.screenLocation.y);
                    if (destinationDock instanceof Component) {
                        SwingUtilities.convertPointFromScreen(this.locationInDestinationDock, (Component)((Object)destinationDock));
                    }
                    if (destinationDock instanceof FloatDock) {
                        if (this.floating) {
                            ((FloatDock)this.currentRootDock).moveDock(this.currentChildOfRootDock, this.locationInDestinationDock, this.dockableOffset);
                            this.undocked = true;
                            this.floatingDelay = 0;
                            return;
                        }
                        if (this.floatingDelay == 0) {
                            this.floatingDelay = 1;
                            this.startFloatDelay();
                            return;
                        }
                        if (this.floatingDelay == 1) {
                            return;
                        }
                    } else {
                        this.floatingDelay = 0;
                    }
                    this.previousDock = this.currentDock;
                    if (!this.floating) {
                        Component previousDockComponent = (Component)((Object)this.previousDock);
                        this.previousDockRectangle.setSize(previousDockComponent.getSize());
                        this.previousDockRectangle.setLocation(previousDockComponent.getLocationOnScreen());
                        this.mouseExitedPreviousDock = false;
                    } else {
                        this.mouseExitedPreviousDock = true;
                    }
                    if (!this.currentDock.equals(this.draggedDockable.getDock())) {
                        throw new IllegalStateException("The origin dock is not the parent of the dockable.");
                    }
                    DockingManager.getDockingExecutor().changeDocking(this.draggedDockable, destinationDock, this.locationInDestinationDock, this.dockableOffset);
                    this.undocked = true;
                    if (this.currentDock instanceof SingleDock) {
                        this.singleDocksWithGhosts.add(this.currentDock);
                    }
                    if (this.firstRemoved) {
                        DockingManager.getDockingExecutor().cleanDock(this.currentDock, false);
                    } else {
                        this.dockWithGhost = DockingManager.getDockingExecutor().cleanDock(this.currentDock, true);
                    }
                    this.firstRemoved = true;
                }
            } else if (!(this.draggedDockable instanceof CompositeDockable)) {
                this.locationInDestinationDock.setLocation(this.screenLocation.x, this.screenLocation.y);
                if (destinationDock instanceof Component) {
                    SwingUtilities.convertPointFromScreen(this.locationInDestinationDock, (Component)((Object)destinationDock));
                }
                DockingManager.getDockingExecutor().changeDocking(this.draggedDockable, destinationDock, this.locationInDestinationDock, new Point(0, 0));
            }
        }
    }

    public void cancelDragging(MouseEvent mouseEvent) {
        this.stopDragging(mouseEvent);
    }

    public void stopDragging(MouseEvent mouseEvent) {
        this.cursorManager.resetCursor();
        if (this.dockWithGhost != null) {
            this.dockWithGhost.clearGhosts();
        }
        Iterator iterator = this.singleDocksWithGhosts.iterator();
        while (iterator.hasNext()) {
            ((SingleDock)iterator.next()).clearGhosts();
        }
        this.reset();
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        Component mouseComponent = (Component)mouseEvent.getSource();
        this.originDock = (LeafDock)((Object)SwingUtilities.getAncestorOfClass(LeafDock.class, mouseComponent));
        if (this.originDock != null) {
            if (this.originDock.getDockableCount() == 1) {
                Dockable clickedDockable = this.originDock.getDockable(0);
                JPopupMenu popupMenu = DockingManager.getComponentFactory().createPopupMenu(clickedDockable, null);
                if (popupMenu != null) {
                    popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            } else {
                Dockable[] dockableArray = new Dockable[this.originDock.getDockableCount()];
                for (int index = 0; index < this.originDock.getDockableCount(); ++index) {
                    dockableArray[index] = this.originDock.getDockable(index);
                }
                DefaultCompositeDockable compositeDockable = new DefaultCompositeDockable(dockableArray);
                JPopupMenu popupMenu = DockingManager.getComponentFactory().createPopupMenu(null, compositeDockable);
                if (popupMenu != null) {
                    popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    protected Cursor retrieveCanDockCursor() {
        return DockingManager.getCanDockCursor();
    }

    private void reset() {
        this.undocked = false;
        this.originDock = null;
        this.previousDock = null;
        this.draggedDockable = null;
    }

    private void computeScreenLocation(MouseEvent mouseEvent) {
        this.screenLocation.setLocation(mouseEvent.getX(), mouseEvent.getY());
        SwingUtilities.convertPointToScreen(this.screenLocation, (Component)mouseEvent.getSource());
    }

    private boolean isFloating() {
        this.currentRootDock = this.draggedDockable.getDock();
        this.currentChildOfRootDock = null;
        while (this.currentRootDock.getParentDock() != null) {
            this.currentChildOfRootDock = this.currentRootDock;
            this.currentRootDock = this.currentRootDock.getParentDock();
        }
        if (this.currentRootDock instanceof FloatDock) {
            ArrayList childrenOfDockable = new ArrayList();
            ArrayList childrenOfDock = new ArrayList();
            DockingUtil.retrieveDockables(this.draggedDockable, childrenOfDockable);
            DockingUtil.retrieveDockables(this.currentChildOfRootDock, childrenOfDock);
            if (CollectionUtil.sameElements(childrenOfDockable, childrenOfDock)) {
                return true;
            }
        }
        return false;
    }

    private boolean changeDock(MouseEvent mouseEvent, Dock destinationDock) {
        boolean changeDock = false;
        if (!this.undocked) {
            changeDock = true;
        } else if (this.floating) {
            if (destinationDock instanceof FloatDock) {
                changeDock = true;
            } else if (!destinationDock.equals(this.previousDock)) {
                this.locationInDestinationDock.setLocation(this.screenLocation.x, this.screenLocation.y);
                SwingUtilities.convertPointFromScreen(this.locationInDestinationDock, (Component)((Object)destinationDock));
                destinationDock.retrieveDockingRectangle(this.draggedDockable, this.locationInDestinationDock, this.dockableOffset, this.dockableDragRectangle);
                if (this.dockableDragRectangle.contains(this.locationInDestinationDock)) {
                    changeDock = true;
                }
            } else {
                changeDock = this.mouseExitedPreviousDock;
            }
        } else if (destinationDock instanceof FloatDock) {
            Component currentDockComponent = (Component)((Object)this.currentDock);
            this.helpPoint.setLocation(this.screenLocation.x, this.screenLocation.y);
            SwingUtilities.convertPointFromScreen(this.helpPoint, currentDockComponent);
            changeDock = !currentDockComponent.contains(this.helpPoint);
        } else {
            changeDock = true;
        }
        return changeDock;
    }

    private void floatDelayFinished() {
        this.timer = null;
        if (this.floatingDelay == 1) {
            this.floatingDelay = 2;
        }
    }

    private void startFloatDelay() {
        ActionListener taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DynamicDragger.this.floatDelayFinished();
            }
        };
        this.timer = new Timer(150, taskPerformer);
        this.timer.setRepeats(false);
        this.timer.start();
    }
}

