/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag;

import com.javadocking.dock.CompositeTabDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.LeafDock;
import com.javadocking.dock.SingleDock;
import com.javadocking.dock.TabDock;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.Dragger;
import com.javadocking.drag.DraggerFactory;
import com.javadocking.drag.StaticCompositeTabDragger;
import com.javadocking.drag.StaticDockableDragger;
import com.javadocking.drag.StaticDragger;
import com.javadocking.drag.StaticSingleDragger;
import com.javadocking.drag.StaticTabDragger;
import com.javadocking.drag.painter.DefaultRectanglePainter;
import com.javadocking.drag.painter.DockableDragPainter;
import com.javadocking.drag.painter.SwDockableDragPainter;

public class StaticDraggerFactory
implements DraggerFactory {
    private DockableDragPainter dockableDragPainter = new SwDockableDragPainter(new DefaultRectanglePainter());

    public StaticDraggerFactory() {
    }

    public StaticDraggerFactory(DockableDragPainter dockableDragPainter) {
        this.dockableDragPainter = dockableDragPainter;
    }

    public Dragger createDragger(Dock dock) {
        if (dock instanceof SingleDock) {
            return new StaticSingleDragger(this.dockableDragPainter);
        }
        if (dock instanceof TabDock) {
            return new StaticTabDragger(this.dockableDragPainter);
        }
        if (dock instanceof LeafDock) {
            return new StaticDragger(this.dockableDragPainter);
        }
        if (dock instanceof CompositeTabDock) {
            return new StaticCompositeTabDragger(this.dockableDragPainter);
        }
        return null;
    }

    public Dragger createDragger(Dockable dockable) {
        return new StaticDockableDragger(dockable, this.dockableDragPainter);
    }

    public DockableDragPainter getDockableDragPainter() {
        return this.dockableDragPainter;
    }

    public void setDockableDragPainter(DockableDragPainter dockableDragPainter) {
        this.dockableDragPainter = dockableDragPainter;
    }
}

