/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag;

import com.javadocking.DockingManager;
import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dock.TabDock;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.DefaultCompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.DragCursorManager;
import com.javadocking.drag.Dragger;
import com.javadocking.drag.dockretriever.DockRetriever;
import com.javadocking.drag.dockretriever.StaticDockRetriever;
import com.javadocking.drag.painter.DefaultRectanglePainter;
import com.javadocking.drag.painter.DockableDragPainter;
import com.javadocking.drag.painter.SwDockableDragPainter;
import com.javadocking.util.CollectionUtil;
import com.javadocking.util.DockingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class StaticTabDragger
implements Dragger {
    private DockRetriever dockRetriever = new StaticDockRetriever();
    private TabDock originDock;
    private Dock currentRootDock;
    private Dock currentChildOfRootDock;
    private Point screenLocation = new Point();
    private Point locationInDestinationDock = new Point();
    private Point currentOffsetInTabbedPane = new Point();
    private Point dockableOffset = new Point();
    private Dockable draggedDockable;
    private JTabbedPane sourceTabbedPane;
    private int oldTabIndex;
    private DragCursorManager cursorManager = new DragCursorManager();
    private DockableDragPainter dockableDragPainter;
    private Rectangle dockableDragRectangle = new Rectangle();

    public StaticTabDragger() {
        this(new SwDockableDragPainter(new DefaultRectanglePainter()));
    }

    public StaticTabDragger(DockableDragPainter dockableDragPainter) {
        this.dockableDragPainter = dockableDragPainter;
    }

    public boolean startDragging(MouseEvent mouseEvent) {
        TabDock tabDock;
        Container ancestorComponent;
        Component mouseComponent = (Component)mouseEvent.getSource();
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        this.reset();
        if (mouseComponent instanceof JTabbedPane && (ancestorComponent = SwingUtilities.getAncestorOfClass(Component.class, mouseComponent)) instanceof TabDock && (tabDock = (TabDock)ancestorComponent).getDockableCount() > 0) {
            this.sourceTabbedPane = (JTabbedPane)mouseComponent;
            this.originDock = tabDock;
            this.dockableOffset.setLocation(x, y);
            this.dockableOffset = SwingUtilities.convertPoint(mouseComponent, this.dockableOffset, this.sourceTabbedPane);
            this.oldTabIndex = this.sourceTabbedPane.indexAtLocation(this.dockableOffset.x, this.dockableOffset.y);
            if (this.oldTabIndex >= 0) {
                Component tabComponent = this.sourceTabbedPane.getComponentAt(this.oldTabIndex);
                this.draggedDockable = tabDock.retrieveDockableOfComponent(tabComponent);
                if (this.draggedDockable != null) {
                    Dimension size = this.draggedDockable.getContent().getPreferredSize();
                    if ((double)this.dockableOffset.x > size.getWidth()) {
                        this.dockableOffset.x = (int)Math.round(size.getWidth());
                    }
                    if ((double)this.dockableOffset.y > size.getHeight()) {
                        this.dockableOffset.y = (int)Math.round(size.getHeight());
                    }
                    return true;
                }
            } else {
                if (this.sourceTabbedPane.getTabCount() <= 0) {
                    return false;
                }
                Component selectedComponent = this.sourceTabbedPane.getSelectedComponent();
                Point helpPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                if (selectedComponent.contains(helpPoint = SwingUtilities.convertPoint(mouseComponent, helpPoint, selectedComponent))) {
                    return false;
                }
                Dockable[] dockables = new Dockable[this.sourceTabbedPane.getTabCount()];
                for (int index = 0; index < this.sourceTabbedPane.getTabCount(); ++index) {
                    dockables[index] = tabDock.retrieveDockableOfComponent(this.sourceTabbedPane.getComponentAt(index));
                    if (dockables[index] != null) continue;
                    return false;
                }
                this.draggedDockable = new DefaultCompositeDockable(dockables, this.sourceTabbedPane.getSelectedIndex());
                this.draggedDockable.setState(1, this.originDock);
                Dimension size = DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)this.draggedDockable, 16);
                if ((double)this.dockableOffset.x > size.getWidth()) {
                    this.dockableOffset.x = (int)Math.round(size.getWidth());
                }
                if ((double)this.dockableOffset.y > size.getHeight()) {
                    this.dockableOffset.y = (int)Math.round(size.getHeight());
                }
                return true;
            }
        }
        return false;
    }

    public void drag(MouseEvent mouseEvent) {
        Component mouseComponent = (Component)mouseEvent.getSource();
        if (this.tabDragged(mouseEvent) >= 0) {
            this.clearPainting();
            this.cursorManager.setCursor(mouseComponent, this.retrieveCanDockCursor());
            return;
        }
        this.computeScreenLocation(mouseEvent);
        Dock[] destinationDocks = this.dockRetriever.retrieveHighestPriorityDock(this.screenLocation, this.draggedDockable);
        if (destinationDocks == null) {
            this.dockableDragPainter.paintDockableDrag(this.draggedDockable, null, null, this.screenLocation);
            this.cursorManager.setCursor(mouseComponent, this.retrieveCanNotDockCursor());
            return;
        }
        Dock destinationDock = destinationDocks[0];
        if (destinationDock != null) {
            if (!destinationDock.equals(this.originDock) || !this.isFloating()) {
                if (destinationDock instanceof Component) {
                    this.locationInDestinationDock.setLocation(this.screenLocation.x, this.screenLocation.y);
                    SwingUtilities.convertPointFromScreen(this.locationInDestinationDock, (Component)((Object)destinationDock));
                    destinationDock.retrieveDockingRectangle(this.draggedDockable, this.locationInDestinationDock, this.dockableOffset, this.dockableDragRectangle);
                    this.dockableDragPainter.paintDockableDrag(this.draggedDockable, destinationDock, this.dockableDragRectangle, this.locationInDestinationDock);
                    this.cursorManager.setCursor((Component)((Object)destinationDock), this.retrieveCanDockCursor());
                } else if (destinationDock instanceof FloatDock) {
                    boolean move = false;
                    Dock rootDock = this.originDock;
                    TabDock dockUnderRoot = null;
                    while (rootDock.getParentDock() != null) {
                        dockUnderRoot = rootDock;
                        rootDock = rootDock.getParentDock();
                    }
                    if (rootDock instanceof FloatDock) {
                        ArrayList childrenOfDockable = new ArrayList();
                        ArrayList childrenOfDock = new ArrayList();
                        DockingUtil.retrieveDockables(this.draggedDockable, childrenOfDockable);
                        DockingUtil.retrieveDockables(dockUnderRoot, childrenOfDock);
                        if (this.sameElements(childrenOfDockable, childrenOfDock)) {
                            move = true;
                        }
                    }
                    if (move) {
                        this.locationInDestinationDock.setLocation(this.screenLocation.x - this.dockableOffset.x, this.screenLocation.y - this.dockableOffset.y);
                        this.dockableDragRectangle.setLocation(this.locationInDestinationDock);
                        Window window = SwingUtilities.getWindowAncestor(dockUnderRoot);
                        this.dockableDragRectangle.setSize(window.getSize());
                        this.locationInDestinationDock.setLocation(this.locationInDestinationDock.x + this.dockableOffset.x, this.locationInDestinationDock.y + this.dockableOffset.y);
                    } else {
                        destinationDock.retrieveDockingRectangle(this.draggedDockable, this.screenLocation, this.dockableOffset, this.dockableDragRectangle);
                        this.locationInDestinationDock.setLocation(this.dockableDragRectangle.x, this.dockableDragRectangle.y);
                        this.dockableDragRectangle.setLocation(this.locationInDestinationDock);
                        this.locationInDestinationDock.setLocation(this.locationInDestinationDock.x + this.dockableOffset.x, this.locationInDestinationDock.y + this.dockableOffset.y);
                    }
                    this.dockableDragPainter.paintDockableDrag(this.draggedDockable, destinationDock, this.dockableDragRectangle, this.locationInDestinationDock);
                    this.cursorManager.setCursor(mouseComponent, this.retrieveCanDockCursor());
                } else {
                    this.dockableDragPainter.paintDockableDrag(this.draggedDockable, destinationDock, null, this.screenLocation);
                    this.cursorManager.setCursor(mouseComponent, this.retrieveCanDockCursor());
                }
            } else {
                destinationDock = this.currentRootDock;
                this.locationInDestinationDock.setLocation(this.screenLocation.x - this.dockableOffset.x, this.screenLocation.y - this.dockableOffset.y);
                SwingUtilities.convertPointFromScreen(this.locationInDestinationDock, this.originDock);
                this.dockableDragRectangle.setLocation(this.locationInDestinationDock);
                Window window = SwingUtilities.getWindowAncestor((Component)((Object)this.currentChildOfRootDock));
                this.dockableDragRectangle.setSize(window.getSize());
                this.dockableDragPainter.paintDockableDrag(this.draggedDockable, this.originDock, this.dockableDragRectangle, this.locationInDestinationDock);
                this.cursorManager.setCursor(mouseComponent, this.retrieveCanDockCursor());
            }
        } else {
            this.dockableDragPainter.paintDockableDrag(this.draggedDockable, null, null, this.screenLocation);
            this.cursorManager.setCursor(mouseComponent, this.retrieveCanNotDockCursor());
        }
    }

    public void cancelDragging(MouseEvent mouseEvent) {
        this.cursorManager.resetCursor();
        this.clearPainting();
        this.reset();
    }

    public void stopDragging(MouseEvent mouseEvent) {
        this.cursorManager.resetCursor();
        this.clearPainting();
        int tabIndex = this.tabDragged(mouseEvent);
        if (tabIndex >= 0) {
            if (this.oldTabIndex >= 0 && tabIndex != this.oldTabIndex) {
                Point locationInOriginDock = new Point(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                locationInOriginDock = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), locationInOriginDock, this.originDock);
                if (!this.originDock.equals(this.draggedDockable.getDock())) {
                    throw new IllegalStateException("The origin dock is not the parent of the dockable.");
                }
                DockingManager.getDockingExecutor().changeDocking(this.draggedDockable, this.originDock, locationInOriginDock, new Point(0, 0));
            }
            this.reset();
            return;
        }
        this.computeScreenLocation(mouseEvent);
        Dock[] destinationDocks = this.dockRetriever.retrieveHighestPriorityDock(this.screenLocation, this.draggedDockable);
        if (destinationDocks == null) {
            return;
        }
        Dock destinationDock = destinationDocks[0];
        if (destinationDock != null) {
            if (!destinationDock.equals(this.originDock)) {
                this.locationInDestinationDock.setLocation(this.screenLocation.x, this.screenLocation.y);
                if (destinationDock instanceof Component) {
                    SwingUtilities.convertPointFromScreen(this.locationInDestinationDock, (Component)((Object)destinationDock));
                }
                if (destinationDock instanceof FloatDock) {
                    Dock rootDock = this.originDock;
                    TabDock dockUnderRoot = null;
                    while (rootDock.getParentDock() != null) {
                        dockUnderRoot = rootDock;
                        rootDock = rootDock.getParentDock();
                    }
                    if (rootDock instanceof FloatDock) {
                        ArrayList childrenOfDockable = new ArrayList();
                        ArrayList childrenOfDock = new ArrayList();
                        DockingUtil.retrieveDockables(this.draggedDockable, childrenOfDockable);
                        DockingUtil.retrieveDockables(dockUnderRoot, childrenOfDock);
                        if (this.sameElements(childrenOfDockable, childrenOfDock)) {
                            ((FloatDock)rootDock).moveDock(dockUnderRoot, this.locationInDestinationDock, this.dockableOffset);
                            return;
                        }
                    }
                }
                if (!this.originDock.equals(this.draggedDockable.getDock())) {
                    throw new IllegalStateException("The origin dock is not the parent of the dockable.");
                }
                DockingManager.getDockingExecutor().changeDocking(this.draggedDockable, destinationDock, this.locationInDestinationDock, this.dockableOffset);
                DockingManager.getDockingExecutor().cleanDock(this.originDock, false);
            } else if (this.isFloating()) {
                destinationDock = this.currentRootDock;
                this.locationInDestinationDock.setLocation(this.screenLocation.x, this.screenLocation.y);
                ((FloatDock)this.currentRootDock).moveDock(this.currentChildOfRootDock, this.locationInDestinationDock, this.dockableOffset);
            }
        }
        this.reset();
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        Container ancestorComponent;
        Component mouseComponent = (Component)mouseEvent.getSource();
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        Component pressedComponent = SwingUtilities.getDeepestComponentAt(mouseComponent, x, y);
        JTabbedPane pressedTabbedPane = null;
        pressedTabbedPane = pressedComponent instanceof JTabbedPane ? (JTabbedPane)pressedComponent : (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, pressedComponent);
        if (pressedTabbedPane != null && (ancestorComponent = SwingUtilities.getAncestorOfClass(Component.class, pressedTabbedPane)) instanceof TabDock) {
            TabDock clickedDock = (TabDock)ancestorComponent;
            this.dockableOffset.setLocation(x, y);
            this.dockableOffset = SwingUtilities.convertPoint(mouseComponent, this.dockableOffset, pressedTabbedPane);
            int oldTabIndex = pressedTabbedPane.indexAtLocation(this.dockableOffset.x, this.dockableOffset.y);
            Dockable clickedDockable = null;
            if (oldTabIndex >= 0) {
                Component tabComponent = pressedTabbedPane.getComponentAt(oldTabIndex);
                clickedDockable = clickedDock.retrieveDockableOfComponent(tabComponent);
            }
            Dockable[] dockableArray = new Dockable[clickedDock.getDockableCount()];
            int selectedIndex = -1;
            for (int index = 0; index < clickedDock.getDockableCount(); ++index) {
                dockableArray[index] = clickedDock.getDockable(index);
                if (!dockableArray[index].equals(clickedDockable)) continue;
                selectedIndex = index;
            }
            DefaultCompositeDockable compositeDockable = new DefaultCompositeDockable(dockableArray, selectedIndex);
            JPopupMenu popupMenu = DockingManager.getComponentFactory().createPopupMenu(clickedDockable, compositeDockable);
            if (popupMenu != null) {
                popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public DockableDragPainter getDockableDragPainter() {
        return this.dockableDragPainter;
    }

    public void setDockableDragPainter(DockableDragPainter dockableDragPainter) {
        this.dockableDragPainter = dockableDragPainter;
    }

    protected Cursor retrieveCanDockCursor() {
        return DockingManager.getCanDockCursor();
    }

    protected Cursor retrieveCanNotDockCursor() {
        return DockingManager.getCanNotDockCursor();
    }

    private void reset() {
        this.originDock = null;
        this.draggedDockable = null;
    }

    private void clearPainting() {
        this.dockableDragPainter.clear();
    }

    private void computeScreenLocation(MouseEvent mouseEvent) {
        this.screenLocation.setLocation(mouseEvent.getX(), mouseEvent.getY());
        SwingUtilities.convertPointToScreen(this.screenLocation, (Component)mouseEvent.getSource());
    }

    private int tabDragged(MouseEvent mouseEvent) {
        if (!(this.draggedDockable instanceof CompositeDockable) && this.sourceTabbedPane != null) {
            this.currentOffsetInTabbedPane.setLocation(mouseEvent.getX(), mouseEvent.getY());
            this.currentOffsetInTabbedPane = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), this.currentOffsetInTabbedPane, this.sourceTabbedPane);
            return this.sourceTabbedPane.indexAtLocation(this.currentOffsetInTabbedPane.x, this.currentOffsetInTabbedPane.y);
        }
        return -1;
    }

    private boolean sameElements(List firstList, List secondList) {
        if (firstList.size() != secondList.size()) {
            return false;
        }
        for (int index = 0; index < firstList.size(); ++index) {
            if (secondList.contains(firstList.get(index))) continue;
            return false;
        }
        return true;
    }

    private boolean isFloating() {
        this.currentRootDock = this.draggedDockable.getDock();
        this.currentChildOfRootDock = null;
        while (this.currentRootDock.getParentDock() != null) {
            this.currentChildOfRootDock = this.currentRootDock;
            this.currentRootDock = this.currentRootDock.getParentDock();
        }
        if (this.currentRootDock instanceof FloatDock) {
            ArrayList childrenOfDockable = new ArrayList();
            ArrayList childrenOfDock = new ArrayList();
            DockingUtil.retrieveDockables(this.draggedDockable, childrenOfDockable);
            DockingUtil.retrieveDockables(this.currentChildOfRootDock, childrenOfDock);
            if (CollectionUtil.sameElements(childrenOfDockable, childrenOfDock)) {
                return true;
            }
        }
        return false;
    }
}

