/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag.dockretriever;

import com.javadocking.DockingManager;
import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.dockretriever.DockRetriever;
import com.javadocking.model.DockModel;
import com.javadocking.util.CollectionUtil;
import com.javadocking.util.DockingUtil;
import com.javadocking.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class DynamicDockRetriever
implements DockRetriever {
    private Dock currentRootDock;
    private Dock currentChildOfRootDock;
    private Dockable currentDockable;

    public Dock[] retrieveHighestPriorityDock(Point screenLocation, Dockable dockable) {
        this.currentDockable = dockable;
        DockPossibilities dockPossibilities = this.retrieveDocksOfPosition(screenLocation, dockable);
        if (dockPossibilities != null) {
            Dock preferenceDock = this.getHighestPriorityDock(screenLocation, dockable, dockPossibilities.preferenceDocks);
            Dock reserveDock = this.getHighestPriorityDock(screenLocation, dockable, dockPossibilities.reserveDocks);
            if (preferenceDock == null && reserveDock == null) {
                return null;
            }
            if (preferenceDock != null && reserveDock != null) {
                Dock[] docks = new Dock[]{preferenceDock, reserveDock};
                return docks;
            }
            Dock[] docks = new Dock[]{preferenceDock != null ? preferenceDock : reserveDock};
            return docks;
        }
        return null;
    }

    private Dock getHighestPriorityDock(Point screenLocation, Dockable dockable, List possibleDocks) {
        if (possibleDocks != null && possibleDocks.size() > 0) {
            Dock dockWithHighestPriority = null;
            int highestPriority = 0;
            for (int index = 0; index < possibleDocks.size(); ++index) {
                int dockPriority;
                Dock possibleDock = (Dock)possibleDocks.get(index);
                Point relativeLocation = new Point(screenLocation.x, screenLocation.y);
                if (possibleDock instanceof Component) {
                    SwingUtilities.convertPointFromScreen(relativeLocation, (Component)((Object)possibleDock));
                }
                if ((dockPriority = possibleDock.getDockPriority(dockable, relativeLocation)) <= highestPriority) continue;
                dockWithHighestPriority = possibleDock;
                highestPriority = dockPriority;
            }
            return dockWithHighestPriority;
        }
        return null;
    }

    private DockPossibilities retrieveDocksOfPosition(Point screenLocation, Dockable dockable) {
        DockPossibilities possibleDocks;
        DockModel dockModel = DockingManager.getDockModel();
        if (dockModel == null) {
            throw new NullPointerException("Dock model of docking manager null.");
        }
        Window currentOwner = null;
        if (dockable.getDock() != null) {
            Dock rootDock = DockingUtil.getRootDock(dockable.getDock());
            String rootDockKey = DockingUtil.getRootDockKey(rootDock);
            currentOwner = DockingUtil.getWindowOwner(rootDockKey);
        }
        if (currentOwner != null && (possibleDocks = this.retrieveDocksOfPosition(screenLocation, currentOwner, dockable, true)) != null) {
            return possibleDocks;
        }
        for (int ownerIndex = 0; ownerIndex < dockModel.getOwnerCount(); ++ownerIndex) {
            DockPossibilities possibleDocks2;
            Window owner = dockModel.getOwner(ownerIndex);
            if (owner.equals(currentOwner) || (possibleDocks2 = this.retrieveDocksOfPosition(screenLocation, owner, dockable, false)) == null) continue;
            return possibleDocks2;
        }
        if ((dockable.getDockingModes() & 0x20) != 0) {
            if (currentOwner == null && dockModel.getOwnerCount() > 0) {
                currentOwner = dockModel.getOwner(0);
            }
            if (currentOwner != null) {
                FloatDock floatDock = dockModel.getFloatDock(currentOwner);
                if (floatDock != null) {
                    ArrayList<FloatDock> docks = new ArrayList<FloatDock>();
                    docks.add(floatDock);
                    DockPossibilities dockPossibilities = new DockPossibilities();
                    dockPossibilities.preferenceDocks = docks;
                    return dockPossibilities;
                }
                return null;
            }
        }
        return null;
    }

    private DockPossibilities retrieveDocksOfPosition(Point screenLocation, Window ownerWindow, Dockable dockable, boolean inOwner) {
        ArrayList<FloatDock> possibleDocks;
        DockPossibilities dockPossibilities = new DockPossibilities();
        DockModel dockModel = DockingManager.getDockModel();
        if (dockModel == null) {
            throw new NullPointerException("Dock model of docking manager null.");
        }
        String floatDockKey = dockModel.getFloatDockKey(ownerWindow);
        FloatDock floatDock = dockModel.getFloatDock(ownerWindow);
        if (floatDock != null && (dockable.getDockingModes() & 0x20) != 0) {
            for (int index = 0; index < floatDock.getChildDockCount(); ++index) {
                Dock childDock = floatDock.getChildDock(index);
                possibleDocks = this.retrieveDocksOfPosition(screenLocation, childDock);
                if (possibleDocks == null || possibleDocks.size() <= 0) continue;
                possibleDocks.add(floatDock);
                if (inOwner && this.isFloating()) {
                    if (childDock.equals(this.currentChildOfRootDock)) {
                        dockPossibilities.reserveDocks = possibleDocks;
                        continue;
                    }
                    dockPossibilities.preferenceDocks = possibleDocks;
                    return dockPossibilities;
                }
                dockPossibilities.preferenceDocks = possibleDocks;
                return dockPossibilities;
            }
        }
        Iterator dockIdIterator = dockModel.getRootKeys(ownerWindow);
        ArrayList<List> listWithPossibleDocksLists = new ArrayList<List>();
        while (dockIdIterator.hasNext()) {
            List possibleDocks2;
            Dock rootDock;
            boolean visible;
            String rootDockId = (String)dockIdIterator.next();
            if (rootDockId.equals(floatDockKey) || !(visible = SwingUtil.locationInComponentVisible(screenLocation, (Component)((Object)(rootDock = dockModel.getRootDock(rootDockId))))) || (possibleDocks2 = this.retrieveDocksOfPosition(screenLocation, rootDock)) == null || possibleDocks2.size() <= 0) continue;
            if (floatDock != null) {
                possibleDocks2.add(floatDock);
            }
            listWithPossibleDocksLists.add(possibleDocks2);
        }
        if (listWithPossibleDocksLists.size() == 1) {
            dockPossibilities.preferenceDocks = (List)listWithPossibleDocksLists.get(0);
            return dockPossibilities;
        }
        if (listWithPossibleDocksLists.size() > 0) {
            List result = (List)listWithPossibleDocksLists.get(0);
            Component resultComponent = (Component)result.get(0);
            for (int nextListIndex = 1; nextListIndex < listWithPossibleDocksLists.size(); ++nextListIndex) {
                List nextList = (List)listWithPossibleDocksLists.get(nextListIndex);
                Component nextListComponent = (Component)nextList.get(0);
                if (!SwingUtilities.isDescendingFrom(nextListComponent, resultComponent)) continue;
                result = nextList;
                resultComponent = nextListComponent;
            }
            dockPossibilities.preferenceDocks = result;
            return dockPossibilities;
        }
        if (dockPossibilities.reserveDocks != null) {
            if (floatDock != null) {
                possibleDocks = new ArrayList<FloatDock>();
                possibleDocks.add(floatDock);
                dockPossibilities.preferenceDocks = possibleDocks;
            }
            return dockPossibilities;
        }
        return null;
    }

    private List retrieveDocksOfPosition(Point screenLocation, Dock rootDock) {
        Point rootLocation = new Point(screenLocation.x, screenLocation.y);
        SwingUtilities.convertPointFromScreen(rootLocation, (Component)((Object)rootDock));
        Component component = SwingUtilities.getDeepestComponentAt((Component)((Object)rootDock), rootLocation.x, rootLocation.y);
        if (component != null) {
            return this.getDockAncestors(component);
        }
        return null;
    }

    private List getDockAncestors(Component component) {
        ArrayList<Component> dockAncestors = new ArrayList<Component>();
        if (component instanceof Dock) {
            dockAncestors.add(component);
        }
        Container dockAncestor = SwingUtilities.getAncestorOfClass(Dock.class, component);
        while (dockAncestor != null) {
            dockAncestors.add(dockAncestor);
            dockAncestor = SwingUtilities.getAncestorOfClass(class$com$javadocking$dock$Dock == null ? DynamicDockRetriever.class$("com.javadocking.dock.Dock") : class$com$javadocking$dock$Dock, dockAncestor);
        }
        return dockAncestors;
    }

    private boolean isFloating() {
        this.currentRootDock = this.currentDockable.getDock();
        this.currentChildOfRootDock = null;
        while (this.currentRootDock.getParentDock() != null) {
            this.currentChildOfRootDock = this.currentRootDock;
            this.currentRootDock = this.currentRootDock.getParentDock();
        }
        if (this.currentRootDock instanceof FloatDock) {
            ArrayList childrenOfDockable = new ArrayList();
            ArrayList childrenOfDock = new ArrayList();
            DockingUtil.retrieveDockables(this.currentDockable, childrenOfDockable);
            DockingUtil.retrieveDockables(this.currentChildOfRootDock, childrenOfDock);
            if (CollectionUtil.sameElements(childrenOfDockable, childrenOfDock)) {
                return true;
            }
        }
        return false;
    }

    private static class DockPossibilities {
        List preferenceDocks;
        List reserveDocks;

        private DockPossibilities() {
        }
    }
}

