/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag.dockretriever;

import com.javadocking.DockingManager;
import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.dockretriever.DockRetriever;
import com.javadocking.model.DockModel;
import com.javadocking.util.DockingUtil;
import com.javadocking.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class StaticDockRetriever
implements DockRetriever {
    private static final boolean TEST = false;

    public Dock[] retrieveHighestPriorityDock(Point screenLocation, Dockable dockable) {
        List possibleDocks = this.retrieveDocksOfPosition(screenLocation, dockable);
        if (possibleDocks != null && possibleDocks.size() > 0) {
            Dock dockWithHighestPriority = null;
            int highestPriority = 0;
            for (int index = 0; index < possibleDocks.size(); ++index) {
                int dockPriority;
                Dock possibleDock = (Dock)possibleDocks.get(index);
                Point relativeLocation = new Point(screenLocation.x, screenLocation.y);
                if (possibleDock instanceof Component) {
                    SwingUtilities.convertPointFromScreen(relativeLocation, (Component)((Object)possibleDock));
                }
                if ((dockPriority = possibleDock.getDockPriority(dockable, relativeLocation)) <= highestPriority) continue;
                dockWithHighestPriority = possibleDock;
                highestPriority = dockPriority;
            }
            Dock[] docks = new Dock[]{dockWithHighestPriority};
            return docks;
        }
        return null;
    }

    private List retrieveDocksOfPosition(Point screenLocation, Dockable dockable) {
        List possibleDocks;
        DockModel dockModel = DockingManager.getDockModel();
        if (dockModel == null) {
            throw new NullPointerException("Dock model of docking manager null.");
        }
        Window currentOwner = null;
        if (dockable.getDock() != null) {
            Dock rootDock = DockingUtil.getRootDock(dockable.getDock());
            String rootDockKey = DockingUtil.getRootDockKey(rootDock);
            currentOwner = DockingUtil.getWindowOwner(rootDockKey);
        }
        if (currentOwner != null && (possibleDocks = this.retrieveDocksOfPosition(screenLocation, currentOwner, dockable)) != null && possibleDocks.size() > 0) {
            return possibleDocks;
        }
        for (int ownerIndex = 0; ownerIndex < dockModel.getOwnerCount(); ++ownerIndex) {
            List possibleDocks2;
            Window owner = dockModel.getOwner(ownerIndex);
            if (owner.equals(currentOwner) || (possibleDocks2 = this.retrieveDocksOfPosition(screenLocation, owner, dockable)) == null || possibleDocks2.size() <= 0) continue;
            return possibleDocks2;
        }
        if ((dockable.getDockingModes() & 0x20) != 0) {
            if (currentOwner == null && dockModel.getOwnerCount() > 0) {
                currentOwner = dockModel.getOwner(0);
            }
            if (currentOwner != null) {
                FloatDock floatDock = dockModel.getFloatDock(currentOwner);
                if (floatDock != null) {
                    ArrayList<FloatDock> docks = new ArrayList<FloatDock>();
                    docks.add(floatDock);
                    return docks;
                }
                return null;
            }
        }
        return null;
    }

    private List retrieveDocksOfPosition(Point screenLocation, Window ownerWindow, Dockable dockable) {
        DockModel dockModel = DockingManager.getDockModel();
        if (dockModel == null) {
            throw new NullPointerException("Dock model of docking manager null.");
        }
        String floatDockKey = dockModel.getFloatDockKey(ownerWindow);
        FloatDock floatDock = dockModel.getFloatDock(ownerWindow);
        if (floatDock != null && (dockable.getDockingModes() & 0x20) != 0) {
            for (int index = 0; index < floatDock.getChildDockCount(); ++index) {
                Dock childDock = floatDock.getChildDock(index);
                List possibleDocks = this.retrieveDocksOfPosition(screenLocation, childDock);
                if (possibleDocks == null || possibleDocks.size() <= 0) continue;
                possibleDocks.add(floatDock);
                return possibleDocks;
            }
        }
        ArrayList<List> listWithPossibleDocksLists = new ArrayList<List>();
        Iterator dockIdIterator = dockModel.getRootKeys(ownerWindow);
        while (dockIdIterator.hasNext()) {
            List possibleDocks;
            Dock rootDock;
            boolean visible;
            String rootDockId = (String)dockIdIterator.next();
            if (rootDockId.equals(floatDockKey) || !(visible = SwingUtil.locationInComponentVisible(screenLocation, (Component)((Object)(rootDock = dockModel.getRootDock(rootDockId))))) || (possibleDocks = this.retrieveDocksOfPosition(screenLocation, rootDock)) == null || possibleDocks.size() <= 0) continue;
            if (floatDock != null) {
                possibleDocks.add(floatDock);
            }
            listWithPossibleDocksLists.add(possibleDocks);
        }
        if (listWithPossibleDocksLists.size() == 1) {
            return (List)listWithPossibleDocksLists.get(0);
        }
        if (listWithPossibleDocksLists.size() > 0) {
            List result = (List)listWithPossibleDocksLists.get(0);
            Component resultComponent = (Component)result.get(0);
            for (int nextListIndex = 1; nextListIndex < listWithPossibleDocksLists.size(); ++nextListIndex) {
                List nextList = (List)listWithPossibleDocksLists.get(nextListIndex);
                Component nextListComponent = (Component)nextList.get(0);
                if (!SwingUtilities.isDescendingFrom(nextListComponent, resultComponent)) continue;
                result = nextList;
                resultComponent = nextListComponent;
            }
            return result;
        }
        return null;
    }

    private List retrieveDocksOfPosition(Point screenLocation, Dock rootDock) {
        Point rootLocation = new Point(screenLocation.x, screenLocation.y);
        SwingUtilities.convertPointFromScreen(rootLocation, (Component)((Object)rootDock));
        Component component = SwingUtilities.getDeepestComponentAt((Component)((Object)rootDock), rootLocation.x, rootLocation.y);
        if (component != null) {
            return this.getDockAncestors(component);
        }
        return null;
    }

    private List getDockAncestors(Component component) {
        ArrayList<Component> dockAncestors = new ArrayList<Component>();
        if (component instanceof Dock) {
            dockAncestors.add(component);
        }
        Container dockAncestor = SwingUtilities.getAncestorOfClass(Dock.class, component);
        while (dockAncestor != null) {
            dockAncestors.add(dockAncestor);
            dockAncestor = SwingUtilities.getAncestorOfClass(class$com$javadocking$dock$Dock == null ? StaticDockRetriever.class$("com.javadocking.dock.Dock") : class$com$javadocking$dock$Dock, dockAncestor);
        }
        return dockAncestors;
    }
}

