/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag.painter;

import com.javadocking.DockingManager;
import com.javadocking.dock.Dock;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.painter.DockableDragPainter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class LabelDockableDragPainter
implements DockableDragPainter {
    private JWindow window;
    private JPanel contentPanel;
    private Dockable dockable;
    private Point windowLocation = new Point();
    private int verticalShift = 5;

    public void clear() {
        this.dockable = null;
        if (this.window != null) {
            this.window.dispose();
            this.window = null;
        }
    }

    public void paintDockableDrag(Dockable newDockable, Dock dock, Rectangle rectangle, Point locationInDestinationDock) {
        if (this.window == null) {
            this.window = new JWindow();
            this.contentPanel = new JPanel(new BorderLayout());
            this.contentPanel.setBackground(Color.white);
            this.contentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            this.window.getContentPane().add(this.contentPanel);
        }
        if (dock == null) {
            this.window.setCursor(DockingManager.getCanNotDockCursor());
        } else {
            this.window.setCursor(DockingManager.getCanDockCursor());
        }
        if (newDockable.getTitle() == null) {
            this.window.setVisible(false);
            return;
        }
        if (!newDockable.equals(this.dockable)) {
            this.dockable = newDockable;
            JLabel component = new JLabel(this.dockable.getTitle());
            component.setBackground(Color.white);
            this.contentPanel.removeAll();
            this.contentPanel.add(component);
            this.window.pack();
        }
        this.windowLocation.move(locationInDestinationDock.x - this.window.getSize().width / 2, locationInDestinationDock.y - this.window.getSize().height / 2 - this.verticalShift);
        if (dock instanceof Component) {
            SwingUtilities.convertPointToScreen(this.windowLocation, (Component)((Object)dock));
        }
        this.window.setLocation(this.windowLocation);
        if (!this.window.isVisible()) {
            this.window.setVisible(true);
        }
    }

    public int getVerticalShift() {
        return this.verticalShift;
    }

    public void setVerticalShift(int verticalShift) {
        this.verticalShift = verticalShift;
    }
}

