/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag.painter;

import com.javadocking.DockingManager;
import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.painter.DockableDragPainter;
import com.javadocking.drag.painter.PaintWindow;
import com.javadocking.drag.painter.RectanglePainter;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class WindowDockableDragPainter
implements DockableDragPainter {
    private PaintWindow window;
    private RectanglePainter rectanglePainter;
    private boolean drawLabel;
    private Dockable previousDockable;
    private Rectangle previousRectangle = new Rectangle();

    public WindowDockableDragPainter(RectanglePainter rectanglePainter) {
        this(rectanglePainter, false);
    }

    public WindowDockableDragPainter(RectanglePainter rectanglePainter, boolean drawLabel) {
        this.rectanglePainter = rectanglePainter;
        this.drawLabel = drawLabel;
    }

    public void clear() {
        if (this.window != null) {
            this.window.setVisible(false);
        }
    }

    public void paintDockableDrag(Dockable dockable, Dock dock, Rectangle rectangle, Point locationInDestinationDock) {
        if (dock instanceof FloatDock && rectangle != null) {
            if (this.window == null) {
                this.window = new PaintWindow(this.rectanglePainter, ((FloatDock)dock).getOwner());
                this.window.setCursor(DockingManager.getCanDockCursor());
            }
            if (dockable != null && this.drawLabel && !dockable.equals(this.previousDockable)) {
                this.rectanglePainter.setLabel(dockable.getTitle());
            }
            if (!rectangle.equals(this.previousRectangle)) {
                this.window.setSize(new Dimension(rectangle.width, rectangle.height));
                this.window.setLocation(rectangle.x, rectangle.y);
            }
            if (!this.window.isVisible()) {
                this.window.setVisible(true);
                this.window.doRepaint();
            }
            if (this.previousRectangle == null || this.previousRectangle.width != rectangle.width || this.previousRectangle.height != rectangle.height || !dockable.equals(this.previousDockable)) {
                this.window.doRepaint();
                this.previousDockable = dockable;
                this.previousRectangle.setRect(rectangle);
            }
        } else if (this.window != null) {
            this.window.setVisible(false);
        }
    }

    public boolean isDrawLabel() {
        return this.drawLabel;
    }

    public void setDrawLabel(boolean drawLabel) {
        this.drawLabel = drawLabel;
    }
}

