/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.model;

import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.LeafDock;
import com.javadocking.dock.Position;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.model.DockingPath;
import com.javadocking.util.DockingUtil;
import com.javadocking.util.PropertiesUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class DefaultDockingPath
implements DockingPath {
    private String id;
    private String rootDockKey;
    private Dock[] docks;
    private Position[] positions;

    public DefaultDockingPath() {
    }

    public DefaultDockingPath(String id, String rootDockKey, Dock[] docks, Position[] positions) {
        if (docks == null) {
            throw new NullPointerException("Docks null.");
        }
        if (positions == null) {
            throw new NullPointerException("Positions null.");
        }
        if (docks.length == 0) {
            throw new IllegalArgumentException("A docking path has at least one roo dock.");
        }
        if (docks.length != positions.length) {
            throw new IllegalArgumentException("Different number of docks and positions.");
        }
        for (int index = 0; index < docks.length; ++index) {
            if (docks[index] == null) {
                throw new NullPointerException("Dock with index [" + index + "] is null. ");
            }
            if (positions[index] != null) continue;
            throw new NullPointerException("Position with index [" + index + "] is null. ");
        }
        this.id = id;
        this.rootDockKey = rootDockKey;
        this.docks = docks;
        this.positions = positions;
    }

    public static DefaultDockingPath createDockingPath(Dockable dockable) {
        if (dockable instanceof CompositeDockable) {
            throw new IllegalArgumentException("Can not create a docking path for a composite dockable.");
        }
        DefaultDockingPath dockingPath = new DefaultDockingPath();
        dockingPath.id = dockable.getID();
        ArrayList<Position> positionsList = new ArrayList<Position>();
        ArrayList<Dock> docksList = new ArrayList<Dock>();
        LeafDock leafDock = dockable.getDock();
        if (leafDock == null) {
            throw new IllegalArgumentException("The dockable is not docked in a dock.");
        }
        docksList.add(0, leafDock);
        Position position = leafDock.getDockablePosition(dockable);
        positionsList.add(0, position);
        Dock childDock = leafDock;
        CompositeDock parentDock = leafDock.getParentDock();
        while (parentDock != null) {
            docksList.add(0, parentDock);
            position = parentDock.getChildDockPosition(childDock);
            positionsList.add(0, position);
            childDock = parentDock;
            parentDock = childDock.getParentDock();
        }
        dockingPath.docks = new Dock[docksList.size()];
        dockingPath.docks = docksList.toArray(dockingPath.docks);
        dockingPath.positions = new Position[positionsList.size()];
        dockingPath.positions = positionsList.toArray(dockingPath.positions);
        dockingPath.rootDockKey = DockingUtil.getRootDockKey(childDock);
        if (dockingPath.rootDockKey == null) {
            throw new IllegalArgumentException("The dockable is not docked in the given dock model.");
        }
        return dockingPath;
    }

    public static DefaultDockingPath copyDockingPath(Dockable dockableForPath, DockingPath dockingPathToCopy) {
        int index;
        if (dockableForPath instanceof CompositeDockable) {
            throw new IllegalArgumentException("Can not create a docking path for a composite dockable.");
        }
        if (dockingPathToCopy == null) {
            throw new IllegalArgumentException("Could not find the docking path to copy in the docking path model.");
        }
        DefaultDockingPath dockingPath = new DefaultDockingPath();
        dockingPath.id = dockableForPath.getID();
        dockingPath.docks = new Dock[dockingPathToCopy.getDockCount()];
        for (index = 0; index < dockingPathToCopy.getDockCount(); ++index) {
            dockingPath.docks[index] = dockingPathToCopy.getDock(index);
        }
        dockingPath.positions = new Position[dockingPathToCopy.getDockCount()];
        for (index = 0; index < dockingPathToCopy.getDockCount(); ++index) {
            dockingPath.positions[index] = dockingPathToCopy.getPositionInDock(index);
        }
        dockingPath.rootDockKey = dockingPathToCopy.getRootDockKey();
        return dockingPath;
    }

    public String getID() {
        return this.id;
    }

    public String getRootDockKey() {
        return this.rootDockKey;
    }

    public Position getPositionInDock(int index) {
        return this.positions[index];
    }

    public Dock getDock(int index) {
        return this.docks[index];
    }

    public int getDockCount() {
        return this.docks.length;
    }

    public void saveProperties(String prefix, Properties properties, Map dockIds) {
        PropertiesUtil.setString(properties, prefix + ".id", this.id);
        PropertiesUtil.setString(properties, prefix + ".rootDockKey", this.rootDockKey);
        PropertiesUtil.setInteger(properties, prefix + ".dockCount", this.getDockCount());
        for (int index = 0; index < this.getDockCount(); ++index) {
            PropertiesUtil.setString(properties, prefix + ".dockId." + index + ".", (String)dockIds.get(this.getDock(index)));
            Position positionInDock = this.getPositionInDock(index);
            Position.setPositionProperty(properties, prefix + ".positionInDock." + index, positionInDock);
        }
    }

    public void loadProperties(String prefix, Properties properties, Map idDockMap) {
        this.id = PropertiesUtil.getString(properties, prefix + ".id", this.id);
        this.rootDockKey = PropertiesUtil.getString(properties, prefix + ".rootDockKey", this.rootDockKey);
        int count = PropertiesUtil.getInteger(properties, prefix + ".dockCount", 0);
        ArrayList<Dock> docksList = new ArrayList<Dock>();
        ArrayList<Position> positionsList = new ArrayList<Position>();
        for (int index = 0; index < count; ++index) {
            String dockId = PropertiesUtil.getString(properties, prefix + ".dockId." + index + ".", null);
            Dock dock = (Dock)idDockMap.get(dockId);
            Position position = Position.getPositionProperty(properties, prefix + ".positionInDock." + index, null);
            if (dock == null) break;
            if (position == null) {
                throw new IllegalStateException("Could not decode the position: index [" + index + "]");
            }
            docksList.add(dock);
            positionsList.add(position);
        }
        this.docks = new Dock[docksList.size()];
        this.positions = new Position[this.docks.length];
        this.docks = docksList.toArray(this.docks);
        this.positions = positionsList.toArray(this.positions);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DockingPath)) {
            return false;
        }
        DockingPath other = (DockingPath)object;
        return this.getID().equals(other.getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }
}

