/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.model;

import com.javadocking.dock.FloatDock;
import com.javadocking.dock.factory.DockFactory;
import com.javadocking.dock.factory.SingleDockFactory;
import com.javadocking.model.FloatDockFactory;
import com.javadocking.util.PropertiesUtil;
import java.awt.Window;
import java.util.Properties;

public class DefaultFloatDockFactory
implements FloatDockFactory {
    private DockFactory childDockFactory;

    public DefaultFloatDockFactory() {
    }

    public DefaultFloatDockFactory(DockFactory childDockFactory) {
        this.childDockFactory = childDockFactory;
    }

    public FloatDock createFloatDock(Window owner) {
        if (this.childDockFactory != null) {
            return new FloatDock(owner, this.childDockFactory);
        }
        return new FloatDock(owner);
    }

    public void loadProperties(String prefix, Properties properties) {
        try {
            String className = null;
            className = PropertiesUtil.getString(properties, prefix + "childDockFactory", className);
            if (className != null) {
                Class<?> clazz = Class.forName(className);
                this.childDockFactory = (DockFactory)clazz.newInstance();
                this.childDockFactory.loadProperties(prefix + "childDockFactory.", properties);
            }
        }
        catch (ClassNotFoundException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        catch (IllegalAccessException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        catch (InstantiationException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = null;
        }
    }

    public void saveProperties(String prefix, Properties properties) {
        if (this.childDockFactory != null) {
            String className = this.childDockFactory.getClass().getName();
            PropertiesUtil.setString(properties, prefix + "childDockFactory", className);
            this.childDockFactory.saveProperties(prefix + "childDockFactory.", properties);
        }
    }

    public DockFactory getChildDockFactory() {
        return this.childDockFactory;
    }

    public void setChildDockFactory(DockFactory childDockFactory) {
        this.childDockFactory = childDockFactory;
    }
}

