/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.model;

import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.Dock;
import com.javadocking.model.DockModel;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.visualizer.Visualizer;
import java.awt.Window;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

class DockModelPropertiesUtil {
    private static final String PROPERTY_CHILD_DOCK_KEYS = "childKeys";
    private static final String PROPERTY_ROOT_DOCK_KEYS = "rootDockKeys";
    private static final String PROPERTY_VISUALIZER_KEYS = "visualizerKeys";
    private static final String PROPERTY_OWNER_IDS = "dockModelIds";
    private static final String PROPERTY_ROOT_DOCK_KEY = "rootDockKey";
    private static final String PROPERTY_WINDOW_RECTANGLE = "windowRectangle";
    public static final String DOCK_CLASS = "class";
    public static final String VISUALIZER_CLASS = "class";

    public static void saveDockModelProperties(DockModel dockModel, String prefix, Properties properties, Map docks) {
        Window ownerWindow;
        int ownerIndex;
        DockKeyManager dockKeyManager = new DockKeyManager(docks);
        String[] dockModelOwnerIdsArray = new String[dockModel.getOwnerCount()];
        for (ownerIndex = 0; ownerIndex < dockModel.getOwnerCount(); ++ownerIndex) {
            ownerWindow = dockModel.getOwner(ownerIndex);
            dockModelOwnerIdsArray[ownerIndex] = dockModel.getOwnerID(ownerWindow);
        }
        PropertiesUtil.setStringArray(properties, prefix + PROPERTY_OWNER_IDS, dockModelOwnerIdsArray);
        for (ownerIndex = 0; ownerIndex < dockModel.getOwnerCount(); ++ownerIndex) {
            ownerWindow = dockModel.getOwner(ownerIndex);
            String ownerId = dockModel.getOwnerID(ownerWindow);
            int[] rectangle = new int[]{ownerWindow.getLocation().x, ownerWindow.getLocation().y, ownerWindow.getSize().width, ownerWindow.getSize().height};
            PropertiesUtil.setIntegerArray(properties, prefix + ownerId + "." + PROPERTY_WINDOW_RECTANGLE, rectangle);
            Iterator rootDockKeyIterator = dockModel.getRootKeys(ownerWindow);
            int rootDockCount = 0;
            while (rootDockKeyIterator.hasNext()) {
                String rootDockKey = (String)rootDockKeyIterator.next();
                Dock rootDock = dockModel.getRootDock(rootDockKey);
                ++rootDockCount;
                DockModelPropertiesUtil.saveDock(rootDock, prefix, properties, dockKeyManager, rootDockKey);
            }
            String[] rootDockIdsArray = new String[rootDockCount];
            rootDockKeyIterator = dockModel.getRootKeys(ownerWindow);
            int rootDockIndex = 0;
            while (rootDockKeyIterator.hasNext()) {
                String rootDockExternalId = (String)rootDockKeyIterator.next();
                Dock rootDock = dockModel.getRootDock(rootDockExternalId);
                rootDockIdsArray[rootDockIndex] = dockKeyManager.getKey(rootDock);
                ++rootDockIndex;
            }
            PropertiesUtil.setStringArray(properties, prefix + ownerId + "." + PROPERTY_ROOT_DOCK_KEYS, rootDockIdsArray);
            Iterator visualizerKeyIterator = dockModel.getVisualizerKeys(ownerWindow);
            int visualizerCount = 0;
            while (visualizerKeyIterator.hasNext()) {
                String visualizerKey = (String)visualizerKeyIterator.next();
                Visualizer visualizer = dockModel.getVisualizer(visualizerKey);
                ++visualizerCount;
                DockModelPropertiesUtil.saveVisualizer(visualizer, prefix, properties, visualizerKey, dockKeyManager.getDockKeys());
            }
            String[] visualizerKeysArray = new String[visualizerCount];
            visualizerKeyIterator = dockModel.getVisualizerKeys(ownerWindow);
            int visualizerIndex = 0;
            while (visualizerKeyIterator.hasNext()) {
                String visualizerKey;
                visualizerKeysArray[visualizerIndex] = visualizerKey = (String)visualizerKeyIterator.next();
                ++visualizerIndex;
            }
            PropertiesUtil.setStringArray(properties, prefix + ownerId + "." + PROPERTY_VISUALIZER_KEYS, visualizerKeysArray);
        }
    }

    public static void loadDockModelProperties(DockModel dockModel, String prefix, Properties properties, Map dockablesMap, Map ownersMap, Map docksMap, Map visualizersMap, boolean loadOwnerRectangle) throws IOException {
        String[] ownerIdsArray = null;
        ownerIdsArray = PropertiesUtil.getStringArray(properties, prefix + PROPERTY_OWNER_IDS, ownerIdsArray);
        for (int ownerWindowIndex = 0; ownerWindowIndex < ownerIdsArray.length; ++ownerWindowIndex) {
            String ownerId = ownerIdsArray[ownerWindowIndex];
            Object ownerObject = ownersMap.get(ownerId);
            if (!(ownerObject instanceof Window)) {
                throw new IOException("The values in the owner windows mapping should be of type java.awt.Window.");
            }
            Window owner = (Window)ownerObject;
            dockModel.addOwner(ownerId, owner);
            if (loadOwnerRectangle) {
                int[] rectangle = null;
                rectangle = PropertiesUtil.getIntegerArray(properties, prefix + ownerId + "." + PROPERTY_WINDOW_RECTANGLE, rectangle);
                if (rectangle != null && rectangle.length == 4) {
                    owner.setLocation(rectangle[0], rectangle[1]);
                    owner.setSize(rectangle[2], rectangle[3]);
                }
            }
            String[] visualizerKeysArray = null;
            visualizerKeysArray = PropertiesUtil.getStringArray(properties, prefix + ownerId + "." + PROPERTY_VISUALIZER_KEYS, visualizerKeysArray);
            if (visualizerKeysArray != null && visualizerKeysArray.length > 0) {
                for (int index = 0; index < visualizerKeysArray.length; ++index) {
                    String visualizerKey = visualizerKeysArray[index];
                    Visualizer visualizer = DockModelPropertiesUtil.loadVisualizer(visualizerKey, prefix, properties, dockablesMap, owner, visualizersMap);
                    if (visualizer == null) continue;
                    dockModel.addVisualizer(visualizerKey, visualizer, owner);
                }
            }
            String[] rootDockIdsArray = null;
            rootDockIdsArray = PropertiesUtil.getStringArray(properties, prefix + ownerId + "." + PROPERTY_ROOT_DOCK_KEYS, rootDockIdsArray);
            if (rootDockIdsArray == null || rootDockIdsArray.length <= 0) continue;
            for (int index = 0; index < rootDockIdsArray.length; ++index) {
                String rootDockId = rootDockIdsArray[index];
                DockWithKey rootDockWithId = DockModelPropertiesUtil.loadDock(rootDockId, prefix, properties, dockablesMap, owner, docksMap);
                Dock rootDock = rootDockWithId.getDock();
                dockModel.addRootDock(rootDockWithId.getKey(), rootDock, owner);
            }
        }
    }

    private static void saveVisualizer(Visualizer visualizer, String prefix, Properties properties, String visualizerKey, Map dockKeys) {
        String propertiesPrefix = visualizerKey + ".";
        PropertiesUtil.setString(properties, propertiesPrefix + "class", visualizer.getClass().getName());
        visualizer.saveProperties(propertiesPrefix, properties);
    }

    private static Visualizer loadVisualizer(String visualizerKey, String prefix, Properties properties, Map dockablesMap, Window owner, Map visualizersMap) throws IOException {
        String propertiesPrefix = visualizerKey + ".";
        Visualizer visualizerObject = (Visualizer)visualizersMap.get(visualizerKey);
        if (visualizerObject != null) {
            if (visualizerObject instanceof Visualizer) {
                Visualizer visualizer = visualizerObject;
                visualizer.loadProperties(propertiesPrefix, properties, dockablesMap, owner);
                return visualizer;
            }
            throw new IOException("The values in the dockables mapping should be of type com.javadocking.Dockable.");
        }
        return null;
    }

    private static void saveDock(Dock dock, String prefix, Properties properties, DockKeyManager dockKeyManager, String rootDockKey) {
        String dockId = dockKeyManager.createKey(dock);
        String propertiesPrefix = dockId + ".";
        HashMap<Dock, String> childDockIds = new HashMap<Dock, String>();
        if (dock instanceof CompositeDock) {
            CompositeDock parentDock = (CompositeDock)dock;
            String[] childKeyArray = new String[parentDock.getChildDockCount()];
            for (int index = 0; index < parentDock.getChildDockCount(); ++index) {
                String childDockKey;
                Dock childDock = parentDock.getChildDock(index);
                DockModelPropertiesUtil.saveDock(childDock, prefix, properties, dockKeyManager, null);
                childKeyArray[index] = childDockKey = dockKeyManager.getKey(childDock);
                childDockIds.put(childDock, childDockKey);
            }
            PropertiesUtil.setStringArray(properties, propertiesPrefix + PROPERTY_CHILD_DOCK_KEYS, childKeyArray);
        }
        PropertiesUtil.setString(properties, propertiesPrefix + "class", dock.getClass().getName());
        if (rootDockKey != null) {
            PropertiesUtil.setString(properties, propertiesPrefix + PROPERTY_ROOT_DOCK_KEY, rootDockKey);
        }
        dock.saveProperties(propertiesPrefix, properties, childDockIds);
    }

    private static DockWithKey loadDock(String dockId, String prefix, Properties properties, Map dockablesMap, Window ownersMap, Map docksMap) throws IOException {
        String propertiesPrefix = dockId + ".";
        String className = null;
        className = PropertiesUtil.getString(properties, propertiesPrefix + "class", className);
        Class<?> clazz = null;
        Dock dock = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Could not find class [" + className + "] (ClassNotFoundException).");
        }
        try {
            dock = (Dock)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Illegal acces to class [" + className + "] (IllegalAccessException).");
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Could not instantiate class [" + className + "] (InstantiationException).");
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Class [" + className + "] is not a Dock. (ClassCastException).");
        }
        String externalId = null;
        externalId = PropertiesUtil.getString(properties, propertiesPrefix + PROPERTY_ROOT_DOCK_KEY, externalId);
        HashMap<String, Dock> childDocks = new HashMap<String, Dock>();
        if (dock instanceof CompositeDock) {
            CompositeDock parentDock = (CompositeDock)dock;
            String[] childIdArray = new String[]{};
            childIdArray = PropertiesUtil.getStringArray(properties, propertiesPrefix + PROPERTY_CHILD_DOCK_KEYS, childIdArray);
            for (int index = 0; index < childIdArray.length; ++index) {
                DockWithKey childDockWithId = DockModelPropertiesUtil.loadDock(childIdArray[index], prefix, properties, dockablesMap, ownersMap, docksMap);
                Dock childDock = childDockWithId.getDock();
                if (childDock == null) continue;
                childDock.setParentDock(parentDock);
                childDocks.put(childIdArray[index], childDock);
            }
        }
        dock.loadProperties(propertiesPrefix, properties, childDocks, dockablesMap, ownersMap);
        docksMap.put(dockId, dock);
        return new DockWithKey(dock, externalId);
    }

    private DockModelPropertiesUtil() {
    }

    private static class DockKeyManager {
        private static final String KEY_PREFIX = "Dock";
        private int count = 0;
        private Map dockKeys;

        public DockKeyManager(Map dockKeys) {
            this.dockKeys = dockKeys;
        }

        public String createKey(Dock dock) {
            String key = KEY_PREFIX + this.count++;
            this.dockKeys.put(dock, key);
            return key;
        }

        public String getKey(Dock dock) {
            return (String)this.dockKeys.get(dock);
        }

        public Map getDockKeys() {
            return this.dockKeys;
        }
    }

    private static class DockWithKey {
        private Dock dock;
        private String key;

        public DockWithKey(Dock dock, String key) {
            this.dock = dock;
            this.key = key;
        }

        public Dock getDock() {
            return this.dock;
        }

        public String getKey() {
            return this.key;
        }
    }
}

