/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.model;

import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dock.factory.SingleDockFactory;
import com.javadocking.model.DefaultDockModel;
import com.javadocking.model.DefaultFloatDockFactory;
import com.javadocking.model.FloatDockFactory;
import com.javadocking.util.PropertiesUtil;
import java.awt.Window;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class FloatDockModel
extends DefaultDockModel {
    public static final String FLOAT_DOCK_KEY = "FloatDock";
    private FloatDockFactory floatDockFactory;

    public FloatDockModel() {
        this(null, new DefaultFloatDockFactory());
    }

    public FloatDockModel(String source) {
        this(source, new DefaultFloatDockFactory());
    }

    public FloatDockModel(FloatDockFactory floatDockFactory) {
        this(null, floatDockFactory);
    }

    public FloatDockModel(String source, FloatDockFactory floatDockFactory) {
        super(source);
        this.floatDockFactory = floatDockFactory;
    }

    public void addOwner(String ownerId, Window ownerWindow) {
        super.addOwner(ownerId, ownerWindow);
        FloatDock floatDock = this.floatDockFactory.createFloatDock(ownerWindow);
        super.addRootDock(this.getFloatDockKey(ownerWindow), floatDock, ownerWindow);
    }

    public void addRootDock(String rootKey, Dock dock, Window owner) {
        if (dock instanceof FloatDock && !this.getFloatDockKey(owner).equals(rootKey)) {
            throw new IllegalArgumentException("Invalid key for a float dock. Use getFloatDockKey(String).");
        }
        super.addRootDock(rootKey, dock, owner);
    }

    public FloatDock getFloatDock(Window owner) {
        return (FloatDock)this.getRootDock(this.getFloatDockKey(owner));
    }

    public String getFloatDockKey(Window owner) {
        return this.getOwnerID(owner) + FLOAT_DOCK_KEY;
    }

    public FloatDockFactory getFloatDockFactory() {
        return this.floatDockFactory;
    }

    public void setFloatDockFactory(FloatDockFactory floatDockProvider) {
        this.floatDockFactory = floatDockProvider;
    }

    public void loadProperties(String sourceName, String prefix, Properties properties, Map dockablesMap, Map ownersMap, Map docks, Map visualizersMap) throws IOException {
        try {
            String className = SingleDockFactory.class.getName();
            className = PropertiesUtil.getString(properties, prefix + "floatDockFactory", className);
            Class<?> clazz = Class.forName(className);
            this.floatDockFactory = (FloatDockFactory)clazz.newInstance();
            this.floatDockFactory.loadProperties(prefix + "floatDockFactory.", properties);
        }
        catch (ClassNotFoundException exception) {
            System.out.println("Could not create the float dock factory.");
            exception.printStackTrace();
            this.floatDockFactory = new DefaultFloatDockFactory();
        }
        catch (IllegalAccessException exception) {
            System.out.println("Could not create the float dock factory.");
            exception.printStackTrace();
            this.floatDockFactory = new DefaultFloatDockFactory();
        }
        catch (InstantiationException exception) {
            System.out.println("Could not create the float dock factory.");
            exception.printStackTrace();
            this.floatDockFactory = new DefaultFloatDockFactory();
        }
        super.loadProperties(sourceName, prefix, properties, dockablesMap, ownersMap, docks, visualizersMap);
    }

    public void saveProperties(String prefix, Properties properties, Map docks) {
        String className = this.floatDockFactory.getClass().getName();
        PropertiesUtil.setString(properties, prefix + "floatDockFactory", className);
        this.floatDockFactory.saveProperties(prefix + "floatDockFactory.", properties);
        super.saveProperties(prefix, properties, docks);
    }
}

