/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class SwingUtil {
    public static void repaintParent(JComponent component) {
        JComponent parentComponent = (JComponent)SwingUtilities.getAncestorOfClass(JComponent.class, component);
        if (parentComponent != null) {
            parentComponent.revalidate();
            parentComponent.repaint();
        } else {
            component.revalidate();
            component.repaint();
        }
    }

    public static JRootPane getRootPane(Component component) {
        if (component instanceof JRootPane) {
            return (JRootPane)component;
        }
        if (component.getParent() != null) {
            return SwingUtil.getRootPane(component.getParent());
        }
        Window window = SwingUtilities.windowForComponent(component);
        return SwingUtil.getRootPane(window);
    }

    public static JRootPane getRootPane(Window window) {
        if (window == null) {
            return null;
        }
        if (window instanceof JFrame) {
            return ((JFrame)window).getRootPane();
        }
        if (window instanceof JWindow) {
            return ((JWindow)window).getRootPane();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getRootPane();
        }
        return null;
    }

    public static JLayeredPane getLayeredPane(JRootPane rootPane) {
        Window window = SwingUtilities.getWindowAncestor(rootPane);
        if (window != null) {
            if (window instanceof JFrame) {
                return ((JFrame)window).getLayeredPane();
            }
            if (window instanceof JDialog) {
                return ((JDialog)window).getLayeredPane();
            }
            if (window instanceof JWindow) {
                return ((JWindow)window).getLayeredPane();
            }
        }
        return rootPane.getLayeredPane();
    }

    public static Container getContentPane(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getContentPane();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getContentPane();
        }
        if (window instanceof JWindow) {
            return ((JWindow)window).getContentPane();
        }
        return null;
    }

    public static boolean isLocationInScreenBounds(Point location) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDevices = graphicsEnvironment.getScreenDevices();
        Rectangle graphicsConfigurationBounds = new Rectangle();
        for (int j = 0; j < graphicsDevices.length; ++j) {
            GraphicsDevice graphicsDevice = graphicsDevices[j];
            graphicsConfigurationBounds.setRect(graphicsDevice.getDefaultConfiguration().getBounds());
            graphicsConfigurationBounds.setRect(graphicsConfigurationBounds.x, graphicsConfigurationBounds.y, graphicsConfigurationBounds.width, graphicsConfigurationBounds.height);
            if (!graphicsConfigurationBounds.contains(location.x, location.y)) continue;
            return true;
        }
        return false;
    }

    public static boolean locationInComponentVisible(Point location, Component component) {
        Container rootComponent;
        JRootPane rootPane = SwingUtil.getRootPane(component);
        if (rootPane != null && (rootComponent = rootPane.getContentPane()) != null) {
            Point locationInRoot = new Point(location);
            SwingUtilities.convertPointFromScreen(locationInRoot, rootComponent);
            Component deepestComponent = SwingUtilities.getDeepestComponentAt(rootComponent, locationInRoot.x, locationInRoot.y);
            if (deepestComponent != null) {
                boolean result = SwingUtilities.isDescendingFrom(deepestComponent, component);
                return result;
            }
        }
        return false;
    }

    private SwingUtil() {
    }
}

