/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.visualizer;

import com.javadocking.DockingManager;
import com.javadocking.component.SelectableDockableHeader;
import com.javadocking.component.SelectableHeader;
import com.javadocking.dock.Dock;
import com.javadocking.dock.LeafDock;
import com.javadocking.dock.docker.Docker;
import com.javadocking.dockable.ButtonDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.visualizer.Visualizer;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DockingMinimizer
implements Visualizer {
    private static final String MINIMIZED_DOCKABLE_ID_SUFFIX = "[MINIMIZED]";
    private static final String PROPERTY_DOCKABLE_IDS = "dockableIds";
    private static final String PROPERTY_SELECTED_DOCKABLE_IDS = "selectedDockableIds";
    private List minimizedDockables = new ArrayList();
    private Map minimizedHeaders = new HashMap();
    private Map minimizedHeaderDockables = new HashMap();
    private Docker docker;
    private SelectionChangeListener selectionChangeListener = new SelectionChangeListener();

    public DockingMinimizer(Docker docker) {
        if (docker == null) {
            throw new NullPointerException("Docker null");
        }
        this.docker = docker;
    }

    public int getState() {
        return 8;
    }

    public boolean canVisualizeDockable(Dockable dockableToVisualize) {
        if (dockableToVisualize == null) {
            throw new NullPointerException("Dockable to minimize null.");
        }
        return !this.minimizedDockables.contains(dockableToVisualize);
    }

    public void visualizeDockable(Dockable dockableToVisualize) {
        if (dockableToVisualize == null) {
            throw new NullPointerException("Dockable to minimize null.");
        }
        if (this.minimizedDockables.contains(dockableToVisualize)) {
            return;
        }
        dockableToVisualize.setState(8, this);
        SelectableHeader dockableHeader = DockingManager.getComponentFactory().createMinimizeHeader(dockableToVisualize, 3);
        dockableHeader.addPropertyChangeListener(this.selectionChangeListener);
        ButtonDockable buttonDockable = new ButtonDockable(this.createMinimizedHeaderDockableID(dockableToVisualize), (Component)((Object)dockableHeader), 114720);
        boolean result = this.docker.dock(buttonDockable);
        if (result) {
            this.minimizedDockables.add(dockableToVisualize);
            this.minimizedHeaderDockables.put(dockableToVisualize, buttonDockable);
            this.minimizedHeaders.put(dockableToVisualize, dockableHeader);
        } else {
            dockableToVisualize.setState(2, null);
        }
    }

    public Dockable getVisualizedDockable(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getVisualizedDockableCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        return (Dockable)this.minimizedDockables.get(index);
    }

    public int getVisualizedDockableCount() {
        return this.minimizedDockables.size();
    }

    public void removeVisualizedDockable(Dockable dockableToRemove) {
        if (!this.minimizedDockables.contains(dockableToRemove)) {
            throw new IllegalArgumentException("The dockable is not minimized in this minimizer.");
        }
        SelectableHeader minimizedComponent = (SelectableHeader)this.minimizedHeaders.get(dockableToRemove);
        minimizedComponent.removePropertyChangeListener(this.selectionChangeListener);
        Dockable buttonDockable = (Dockable)this.minimizedHeaderDockables.get(dockableToRemove);
        LeafDock dockToClean = buttonDockable.getDock();
        DockingManager.getDockingExecutor().changeDocking(buttonDockable, (Dock)null);
        if (dockToClean != null) {
            DockingManager.getDockingExecutor().cleanDock(dockToClean, false);
        }
        this.minimizedHeaders.remove(dockableToRemove);
        this.minimizedDockables.remove(dockableToRemove);
        this.minimizedHeaderDockables.remove(dockableToRemove);
    }

    public void loadProperties(String prefix, Properties properties, Map dockablesMap, Window owner) throws IOException {
        String[] dockableIdArray = new String[]{};
        dockableIdArray = PropertiesUtil.getStringArray(properties, prefix + PROPERTY_DOCKABLE_IDS, dockableIdArray);
        for (int index = 0; index < dockableIdArray.length; ++index) {
            Object dockableObject = dockablesMap.get(dockableIdArray[index]);
            if (dockableObject == null) continue;
            if (dockableObject instanceof Dockable) {
                Dockable dockable = (Dockable)dockableObject;
                dockable.setState(8, this);
                this.minimizedDockables.add(dockable);
                SelectableDockableHeader dockableHeader = (SelectableDockableHeader)DockingManager.getComponentFactory().createMinimizeHeader(dockable, 3);
                dockableHeader.addPropertyChangeListener(this.selectionChangeListener);
                this.minimizedHeaders.put(dockable, dockableHeader);
                ButtonDockable buttonDockable = new ButtonDockable(this.createMinimizedHeaderDockableID(dockable), dockableHeader, 114720);
                dockablesMap.put(buttonDockable.getID(), buttonDockable);
                this.minimizedHeaderDockables.put(dockable, buttonDockable);
                dockable.setState(8, this);
                continue;
            }
            throw new IOException("The values in the dockables mapping should be of type com.javadocking.Dockable.");
        }
        String[] selectedDockableIdArray = new String[]{};
        selectedDockableIdArray = PropertiesUtil.getStringArray(properties, prefix + PROPERTY_SELECTED_DOCKABLE_IDS, selectedDockableIdArray);
        this.deselectAllMinimizedHeaders(null);
        for (int index = 0; index < selectedDockableIdArray.length; ++index) {
            Object dockableObject = dockablesMap.get(selectedDockableIdArray[index]);
            if (dockableObject == null || !(dockableObject instanceof Dockable)) continue;
            Dockable dockable = (Dockable)dockableObject;
            SelectableDockableHeader dockableHeader = (SelectableDockableHeader)this.minimizedHeaders.get(dockable);
            this.selectMinimizedHeader(dockableHeader, true);
        }
        this.docker.loadProperties(prefix + "docker.", properties, dockablesMap);
    }

    public void saveProperties(String prefix, Properties properties) {
        this.docker.saveProperties(prefix + "docker.", properties);
        String[] dockableIdArray = new String[this.getVisualizedDockableCount()];
        ArrayList<String> selectedDockableIDs = new ArrayList<String>(1);
        for (int index = 0; index < dockableIdArray.length; ++index) {
            Dockable minimizedDockable = this.getVisualizedDockable(index);
            dockableIdArray[index] = minimizedDockable.getID();
            SelectableDockableHeader dockableHeader = (SelectableDockableHeader)this.minimizedHeaders.get(minimizedDockable);
            if (!dockableHeader.isSelected()) continue;
            selectedDockableIDs.add(minimizedDockable.getID());
        }
        PropertiesUtil.setStringArray(properties, prefix + PROPERTY_DOCKABLE_IDS, dockableIdArray);
        String[] selectedDockableIdArray = new String[selectedDockableIDs.size()];
        selectedDockableIdArray = selectedDockableIDs.toArray(selectedDockableIdArray);
        PropertiesUtil.setStringArray(properties, prefix + PROPERTY_SELECTED_DOCKABLE_IDS, selectedDockableIdArray);
    }

    protected String createMinimizedHeaderDockableID(Dockable dockable) {
        return dockable.getID() + MINIMIZED_DOCKABLE_ID_SUFFIX;
    }

    private void deselectAllMinimizedHeaders(Object notTodeselectObject) {
        Iterator headerIterator = this.minimizedHeaders.values().iterator();
        while (headerIterator.hasNext()) {
            SelectableHeader selectableDockableHeader = (SelectableHeader)headerIterator.next();
            if (selectableDockableHeader.equals(notTodeselectObject)) continue;
            selectableDockableHeader.removePropertyChangeListener(this.selectionChangeListener);
            selectableDockableHeader.setSelected(false);
            selectableDockableHeader.addPropertyChangeListener(this.selectionChangeListener);
        }
    }

    private void selectMinimizedHeader(Object objectToSelect, boolean selected) {
        Iterator headerIterator = this.minimizedHeaders.values().iterator();
        while (headerIterator.hasNext()) {
            SelectableDockableHeader selectableDockableHeader = (SelectableDockableHeader)headerIterator.next();
            if (!selectableDockableHeader.equals(objectToSelect)) continue;
            selectableDockableHeader.removePropertyChangeListener(this.selectionChangeListener);
            selectableDockableHeader.setSelected(selected);
            selectableDockableHeader.addPropertyChangeListener(this.selectionChangeListener);
        }
    }

    public Docker getDocker() {
        return this.docker;
    }

    public void setDocker(Docker docker) {
        this.docker = docker;
    }

    private class SelectionChangeListener
    implements PropertyChangeListener {
        private SelectionChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object newValue;
            if (propertyChangeEvent.getPropertyName().equals("selected") && (newValue = propertyChangeEvent.getNewValue()) instanceof Boolean) {
                boolean newSelected = (Boolean)newValue;
                Object source = propertyChangeEvent.getSource();
                if (newSelected) {
                    DockingMinimizer.this.deselectAllMinimizedHeaders(source);
                } else {
                    DockingMinimizer.this.selectMinimizedHeader(source, false);
                }
            }
        }
    }
}

