/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.visualizer;

import com.javadocking.dockable.Dockable;
import com.javadocking.visualizer.MinimizerPanel;
import com.javadocking.visualizer.Visualizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;

public class LineMinimizer
extends JPanel
implements Visualizer {
    private Component content;
    private MinimizerPanel minimizerPanel;
    private JPanel borderPanel = new JPanel(new BorderLayout());

    public LineMinimizer() {
        super(new BorderLayout());
        this.add((Component)this.borderPanel, "South");
        this.minimizerPanel = new MinimizerPanel(0);
        this.borderPanel.setVisible(false);
        this.borderPanel.add((Component)this.minimizerPanel, "West");
        this.borderPanel.add((Component)new JPanel(), "Center");
    }

    public LineMinimizer(Component content) {
        this();
        this.setContent(content);
    }

    public boolean canVisualizeDockable(Dockable dockableToVisualize) {
        return this.minimizerPanel.canVisualizeDockable(dockableToVisualize);
    }

    public void visualizeDockable(Dockable dockableToVisualize) {
        this.minimizerPanel.visualizeDockable(dockableToVisualize);
        if (this.minimizerPanel.getVisualizedDockableCount() > 0) {
            this.borderPanel.setVisible(true);
        }
        dockableToVisualize.setState(8, this);
        this.revalidate();
        this.repaint();
    }

    public int getState() {
        return this.minimizerPanel.getState();
    }

    public int getVisualizedDockableCount() {
        return this.minimizerPanel.getVisualizedDockableCount();
    }

    public Dockable getVisualizedDockable(int index) throws IndexOutOfBoundsException {
        return this.minimizerPanel.getVisualizedDockable(index);
    }

    public void removeVisualizedDockable(Dockable dockableToRemove) {
        this.minimizerPanel.removeVisualizedDockable(dockableToRemove);
        if (this.minimizerPanel.getVisualizedDockableCount() == 0) {
            this.borderPanel.setVisible(false);
        }
        this.revalidate();
        this.repaint();
    }

    public void loadProperties(String prefix, Properties properties, Map dockablesMap, Window owner) throws IOException {
        this.minimizerPanel.loadProperties(prefix, properties, dockablesMap, owner);
    }

    public void saveProperties(String prefix, Properties properties) {
        this.minimizerPanel.saveProperties(prefix, properties);
    }

    public void setContent(Component component) {
        if (component == null) {
            throw new NullPointerException("Null content.");
        }
        if (this.content != null) {
            throw new IllegalStateException("There is already a content.");
        }
        this.content = component;
        this.add(this.content, "Center");
    }

    public Component getContent() {
        return this.content;
    }

    public int getHeaderPosition() {
        return this.minimizerPanel.getHeaderPosition();
    }

    public void setHeaderPosition(int newHeaderPosition) {
        this.minimizerPanel.setHeaderPosition(newHeaderPosition);
    }
}

