/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.visualizer;

import com.javadocking.DockingManager;
import com.javadocking.component.SelectableDockableHeader;
import com.javadocking.dockable.Dockable;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.visualizer.Visualizer;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class MinimizerPanel
extends JPanel
implements Visualizer {
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    private static final String PROPERTY_DOCKABLE_IDS = "dockableIds";
    private static final String PROPERTY_SELECTED_DOCKABLE_IDS = "selectedDockableIds";
    private int headerPosition = 3;
    private int orientation = 1;
    private List minimizedDockables = new ArrayList();
    private Map minimizedHeaders = new HashMap();
    private SelectionChangeListener selectionChangeListener = new SelectionChangeListener();

    public MinimizerPanel() {
        this(1);
    }

    public MinimizerPanel(int orientation) {
        this.orientation = orientation;
        this.rebuildUI();
    }

    public int getState() {
        return 8;
    }

    public boolean canVisualizeDockable(Dockable dockableToVisualize) {
        if (dockableToVisualize == null) {
            throw new NullPointerException("Dockable to minimize null.");
        }
        return !this.minimizedDockables.contains(dockableToVisualize);
    }

    public void visualizeDockable(Dockable dockableToVisualize) {
        if (dockableToVisualize == null) {
            throw new NullPointerException("Dockable to minimize null.");
        }
        if (this.minimizedDockables.contains(dockableToVisualize)) {
            return;
        }
        dockableToVisualize.setState(8, this);
        this.minimizedDockables.add(dockableToVisualize);
        SelectableDockableHeader dockableHeader = (SelectableDockableHeader)DockingManager.getComponentFactory().createMinimizeHeader(dockableToVisualize, this.headerPosition);
        dockableHeader.addPropertyChangeListener(this.selectionChangeListener);
        this.minimizedHeaders.put(dockableToVisualize, dockableHeader);
        this.removeAll();
        for (int index = 0; index < this.minimizedDockables.size(); ++index) {
            this.add((Component)this.minimizedHeaders.get(this.minimizedDockables.get(index)));
        }
        this.revalidate();
        this.repaint();
    }

    public int getVisualizedDockableCount() {
        return this.minimizedDockables.size();
    }

    public Dockable getVisualizedDockable(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getVisualizedDockableCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        return (Dockable)this.minimizedDockables.get(index);
    }

    public void removeVisualizedDockable(Dockable dockableToRemove) {
        if (!this.minimizedDockables.contains(dockableToRemove)) {
            throw new IllegalArgumentException("The dockable is not minimized in this minimizer.");
        }
        SelectableDockableHeader minimizedComponent = (SelectableDockableHeader)this.minimizedHeaders.get(dockableToRemove);
        minimizedComponent.removePropertyChangeListener(this.selectionChangeListener);
        this.remove(minimizedComponent);
        this.minimizedHeaders.remove(dockableToRemove);
        this.minimizedDockables.remove(dockableToRemove);
        this.revalidate();
        this.repaint();
    }

    public void loadProperties(String prefix, Properties properties, Map dockablesMap, Window owner) throws IOException {
        int orientation = 0;
        orientation = PropertiesUtil.getInteger(properties, prefix + "orientation", orientation);
        this.setOrientation(orientation);
        int headerPosition = 3;
        headerPosition = PropertiesUtil.getInteger(properties, prefix + "headerPosition", headerPosition);
        this.setHeaderPosition(headerPosition);
        String[] dockableIdArray = new String[]{};
        dockableIdArray = PropertiesUtil.getStringArray(properties, prefix + PROPERTY_DOCKABLE_IDS, dockableIdArray);
        for (int index = 0; index < dockableIdArray.length; ++index) {
            Object dockableObject = dockablesMap.get(dockableIdArray[index]);
            if (dockableObject == null) continue;
            if (dockableObject instanceof Dockable) {
                Dockable dockable = (Dockable)dockableObject;
                this.visualizeDockable(dockable);
                dockable.setState(8, this);
                continue;
            }
            throw new IOException("The values in the dockables mapping should be of type com.javadocking.Dockable.");
        }
        String[] selectedDockableIdArray = new String[]{};
        selectedDockableIdArray = PropertiesUtil.getStringArray(properties, prefix + PROPERTY_SELECTED_DOCKABLE_IDS, selectedDockableIdArray);
        this.deselectAllMinimizedHeaders(null);
        for (int index = 0; index < selectedDockableIdArray.length; ++index) {
            Object dockableObject = dockablesMap.get(selectedDockableIdArray[index]);
            if (dockableObject == null || !(dockableObject instanceof Dockable)) continue;
            Dockable dockable = (Dockable)dockableObject;
            SelectableDockableHeader dockableHeader = (SelectableDockableHeader)this.minimizedHeaders.get(dockable);
            this.selectMinimizedHeader(dockableHeader, true);
        }
    }

    public void saveProperties(String prefix, Properties properties) {
        PropertiesUtil.setInteger(properties, prefix + "headerPosition", this.headerPosition);
        PropertiesUtil.setInteger(properties, prefix + "orientation", this.orientation);
        String[] dockableIdArray = new String[this.getVisualizedDockableCount()];
        ArrayList<String> selectedDockableIDs = new ArrayList<String>(1);
        for (int index = 0; index < dockableIdArray.length; ++index) {
            Dockable minimizedDockable = this.getVisualizedDockable(index);
            dockableIdArray[index] = minimizedDockable.getID();
            SelectableDockableHeader dockableHeader = (SelectableDockableHeader)this.minimizedHeaders.get(minimizedDockable);
            if (!dockableHeader.isSelected()) continue;
            selectedDockableIDs.add(minimizedDockable.getID());
        }
        PropertiesUtil.setStringArray(properties, prefix + PROPERTY_DOCKABLE_IDS, dockableIdArray);
        String[] selectedDockableIdArray = new String[selectedDockableIDs.size()];
        selectedDockableIdArray = selectedDockableIDs.toArray(selectedDockableIdArray);
        PropertiesUtil.setStringArray(properties, prefix + PROPERTY_SELECTED_DOCKABLE_IDS, selectedDockableIdArray);
    }

    public int getHeaderPosition() {
        return this.headerPosition;
    }

    public void setHeaderPosition(int newHeaderPosition) {
        if (newHeaderPosition != this.headerPosition) {
            this.headerPosition = newHeaderPosition;
            this.rebuildUI();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int newOrientation) {
        if (newOrientation != this.orientation) {
            this.orientation = newOrientation;
            this.rebuildUI();
        }
    }

    private void rebuildUI() {
        this.removeAll();
        int layout = 1;
        if (this.orientation == 0) {
            layout = 0;
        }
        this.setLayout(new BoxLayout(this, layout));
        for (int index = 0; index < this.minimizedDockables.size(); ++index) {
            Dockable dockable = (Dockable)this.minimizedDockables.get(index);
            SelectableDockableHeader oldMinimizeHeader = (SelectableDockableHeader)this.minimizedHeaders.get(dockable);
            oldMinimizeHeader.removePropertyChangeListener(this.selectionChangeListener);
            boolean selected = oldMinimizeHeader.isSelected();
            SelectableDockableHeader minimizeHeader = (SelectableDockableHeader)DockingManager.getComponentFactory().createMinimizeHeader(dockable, this.headerPosition);
            minimizeHeader.setSelected(selected);
            minimizeHeader.addPropertyChangeListener(this.selectionChangeListener);
            this.minimizedHeaders.put(dockable, minimizeHeader);
            this.add(minimizeHeader);
        }
    }

    private void deselectAllMinimizedHeaders(Object notTodeselectObject) {
        Iterator headerIterator = this.minimizedHeaders.values().iterator();
        while (headerIterator.hasNext()) {
            SelectableDockableHeader selectableDockableHeader = (SelectableDockableHeader)headerIterator.next();
            if (selectableDockableHeader.equals(notTodeselectObject)) continue;
            selectableDockableHeader.removePropertyChangeListener(this.selectionChangeListener);
            selectableDockableHeader.setSelected(false);
            selectableDockableHeader.addPropertyChangeListener(this.selectionChangeListener);
        }
    }

    private void selectMinimizedHeader(Object objectToSelect, boolean selected) {
        Iterator headerIterator = this.minimizedHeaders.values().iterator();
        while (headerIterator.hasNext()) {
            SelectableDockableHeader selectableDockableHeader = (SelectableDockableHeader)headerIterator.next();
            if (!selectableDockableHeader.equals(objectToSelect)) continue;
            selectableDockableHeader.removePropertyChangeListener(this.selectionChangeListener);
            selectableDockableHeader.setSelected(selected);
            selectableDockableHeader.addPropertyChangeListener(this.selectionChangeListener);
        }
    }

    private class SelectionChangeListener
    implements PropertyChangeListener {
        private SelectionChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object newValue;
            if (propertyChangeEvent.getPropertyName().equals("selected") && (newValue = propertyChangeEvent.getNewValue()) instanceof Boolean) {
                boolean newSelected = (Boolean)newValue;
                Object source = propertyChangeEvent.getSource();
                if (newSelected) {
                    MinimizerPanel.this.deselectAllMinimizedHeaders(source);
                } else {
                    MinimizerPanel.this.selectMinimizedHeader(source, false);
                }
            }
        }
    }
}

