/*
 * Decompiled with CFR 0.152.
 */
package org.dozer;

import java.util.ServiceLoader;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import org.dozer.DozerModule;
import org.dozer.config.BeanContainer;
import org.dozer.config.GlobalSettings;
import org.dozer.jmx.DozerAdminController;
import org.dozer.jmx.DozerStatisticsController;
import org.dozer.jmx.JMXPlatform;
import org.dozer.jmx.JMXPlatformImpl;
import org.dozer.loader.xml.ELEngine;
import org.dozer.loader.xml.ExpressionElementReader;
import org.dozer.util.DefaultClassLoader;
import org.dozer.util.DozerClassLoader;
import org.dozer.util.DozerConstants;
import org.dozer.util.DozerProxyResolver;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DozerInitializer {
    private final Logger log = LoggerFactory.getLogger(DozerInitializer.class);
    private static final String DOZER_STATISTICS_CONTROLLER = "org.dozer.jmx:type=DozerStatisticsController";
    private static final String DOZER_ADMIN_CONTROLLER = "org.dozer.jmx:type=DozerAdminController";
    private static final DozerInitializer instance = new DozerInitializer();
    private volatile boolean isInitialized = false;

    private DozerInitializer() {
    }

    public void init() {
        this.init(this.getClass().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ClassLoader classLoader) {
        DozerInitializer dozerInitializer = this;
        synchronized (dozerInitializer) {
            if (this.isInitialized) {
                this.log.debug("Tried to perform initialization when Dozer was already started.");
                return;
            }
            this.log.info("Initializing Dozer. Version: {}, Thread Name: {}", (Object)"5.5.0", (Object)Thread.currentThread().getName());
            GlobalSettings globalSettings = GlobalSettings.getInstance();
            this.initialize(globalSettings, classLoader);
            this.isInitialized = true;
        }
    }

    void initialize(GlobalSettings globalSettings, ClassLoader classLoader) {
        if (globalSettings.isAutoregisterJMXBeans()) {
            try {
                this.registerJMXBeans(new JMXPlatformImpl());
            }
            catch (Throwable t) {
                this.log.warn("Unable to register Dozer JMX MBeans with the PlatformMBeanServer.  Dozer will still function normally, but management via JMX may not be available", t);
            }
        }
        BeanContainer beanContainer = BeanContainer.getInstance();
        this.registerClassLoader(globalSettings, classLoader, beanContainer);
        this.registerProxyResolver(globalSettings, beanContainer);
        if (globalSettings.isElEnabled()) {
            ELEngine engine = new ELEngine();
            engine.init();
            beanContainer.setElEngine(engine);
            beanContainer.setElementReader(new ExpressionElementReader(engine));
        }
        for (DozerModule module : ServiceLoader.load(DozerModule.class)) {
            module.init();
        }
    }

    private void registerClassLoader(GlobalSettings globalSettings, ClassLoader classLoader, BeanContainer beanContainer) {
        String classLoaderName = globalSettings.getClassLoaderName();
        if (!DozerConstants.DEFAULT_CLASS_LOADER_BEAN.equals(classLoaderName)) {
            DefaultClassLoader defaultClassLoader = new DefaultClassLoader(classLoader);
            Class<DozerClassLoader> classLoaderType = this.loadBeanType(classLoaderName, defaultClassLoader, DozerClassLoader.class);
            DozerClassLoader classLoaderBean = ReflectionUtils.newInstance(classLoaderType);
            beanContainer.setClassLoader(classLoaderBean);
        }
    }

    private void registerProxyResolver(GlobalSettings globalSettings, BeanContainer beanContainer) {
        String proxyResolverName = globalSettings.getProxyResolverName();
        if (!DozerConstants.DEFAULT_PROXY_RESOLVER_BEAN.equals(proxyResolverName)) {
            DozerClassLoader initializedClassLoader = beanContainer.getClassLoader();
            Class<DozerProxyResolver> proxyResolverType = this.loadBeanType(proxyResolverName, initializedClassLoader, DozerProxyResolver.class);
            DozerProxyResolver proxyResolverBean = ReflectionUtils.newInstance(proxyResolverType);
            beanContainer.setProxyResolver(proxyResolverBean);
        }
    }

    private <T> Class<? extends T> loadBeanType(String classLoaderName, DozerClassLoader classLoader, Class<T> iface) {
        Class<?> beanType = classLoader.loadClass(classLoaderName);
        if (beanType != null && !iface.isAssignableFrom(beanType)) {
            MappingUtils.throwMappingException("Incompatible types: " + iface.getName() + " and " + classLoaderName);
        }
        return beanType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        DozerInitializer dozerInitializer = this;
        synchronized (dozerInitializer) {
            if (!this.isInitialized) {
                this.log.debug("Tried to destroy when no Dozer instance started.");
                return;
            }
            try {
                this.unregisterJMXBeans(new JMXPlatformImpl());
            }
            catch (Throwable e) {
                this.log.warn("Exception caught while disposing Dozer JMX MBeans.", e);
            }
            this.isInitialized = false;
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    private void registerJMXBeans(JMXPlatform platform) throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException {
        if (platform.isAvailable()) {
            platform.registerMBean(DOZER_STATISTICS_CONTROLLER, new DozerStatisticsController());
            platform.registerMBean(DOZER_ADMIN_CONTROLLER, new DozerAdminController());
        } else {
            this.log.warn("jdk1.5 jmx management classes unavailable. Dozer JMX MBeans will not be auto registered.");
        }
    }

    private void unregisterJMXBeans(JMXPlatform platform) throws MBeanRegistrationException, MalformedObjectNameException {
        if (platform.isAvailable()) {
            platform.unregisterMBean(DOZER_ADMIN_CONTROLLER);
            platform.unregisterMBean(DOZER_STATISTICS_CONTROLLER);
        } else {
            this.log.warn("jdk1.5 jmx management classes unavailable.");
        }
    }

    public static DozerInitializer getInstance() {
        return instance;
    }
}

