/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.stats;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.dozer.stats.StatisticType;
import org.dozer.stats.StatisticsManager;
import org.dozer.util.MappingUtils;

public class StatisticsInterceptor
implements InvocationHandler {
    private final Object delegate;
    private final StatisticsManager statsMgr;

    public StatisticsInterceptor(Object delegate, StatisticsManager statsMgr) {
        this.delegate = delegate;
        this.statsMgr = statsMgr;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            Object result = method.invoke(this.delegate, args);
            long stop = System.currentTimeMillis();
            this.statsMgr.increment(StatisticType.MAPPING_SUCCESS_COUNT);
            this.statsMgr.increment(StatisticType.MAPPING_TIME, stop - start);
            return result;
        }
        catch (InvocationTargetException e) {
            Throwable ex = e.getTargetException();
            this.statsMgr.increment(StatisticType.MAPPING_FAILURE_COUNT);
            Throwable rootCause = MappingUtils.getRootCause(ex);
            this.statsMgr.increment(StatisticType.MAPPING_FAILURE_EX_TYPE_COUNT, rootCause.getClass());
            this.incrementClassMappingFailureTypeStat(args);
            throw ex;
        }
    }

    private void incrementClassMappingFailureTypeStat(Object[] args) {
        String srcClassName = null;
        if (args[0] != null) {
            srcClassName = args[0].getClass().getName();
        }
        String destClassName = null;
        if (args[1] != null) {
            destClassName = args[1] instanceof Class ? ((Class)args[1]).getName() : args[1].getClass().getName();
        }
        this.statsMgr.increment(StatisticType.MAPPING_FAILURE_TYPE_COUNT, srcClassName + "-->" + destClassName);
    }
}

