/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

public class ConsolePrintingCacheEventListener
implements CacheEventListener {
    private volatile int eventsReceivedCount;

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        Serializable key = null;
        if (element != null) {
            key = element.getKey();
        }
        ++this.eventsReceivedCount;
        System.out.println("Received remove notification for element " + key);
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        ++this.eventsReceivedCount;
        System.out.println("Received put notification for element " + element);
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        ++this.eventsReceivedCount;
        System.out.println("Received update notification for element " + element);
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        Serializable key = null;
        if (element != null) {
            key = element.getKey();
        }
        ++this.eventsReceivedCount;
        System.out.println("Received expired notification for element " + key);
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        Serializable key = null;
        if (element != null) {
            key = element.getKey();
        }
        ++this.eventsReceivedCount;
        System.out.println("Received eviction notification for element " + key);
    }

    public void notifyRemoveAll(Ehcache cache) {
        ++this.eventsReceivedCount;
        System.out.println("Received removeAll notification.");
    }

    public void dispose() {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Not supported");
    }

    public int getEventsReceivedCount() {
        return this.eventsReceivedCount;
    }
}

