/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.jms.AcknowledgementMode;
import net.sf.ehcache.distribution.jms.Action;
import net.sf.ehcache.distribution.jms.JMSEventMessage;
import net.sf.ehcache.distribution.jms.JMSUtil;
import net.sf.ehcache.loader.CacheLoader;

public class JMSCacheLoader
implements CacheLoader {
    protected static final int HIGHEST_JMS_PRORITY = 9;
    private static final Logger LOG = Logger.getLogger(JMSCacheLoader.class.getName());
    protected QueueSender getQueueSender;
    protected QueueSession getQueueSession;
    protected int timeoutMillis;
    protected Ehcache cache;
    private AcknowledgementMode acknowledgementMode;
    private Status status;
    private QueueConnection getQueueConnection;
    private String defaultLoaderArgument;
    private Queue getQueue;

    public JMSCacheLoader(Ehcache cache, String defaultLoaderArgument, QueueConnection getQueueConnection, Queue getQueue, AcknowledgementMode acknowledgementMode, int timeoutMillis) {
        this.cache = cache;
        this.defaultLoaderArgument = defaultLoaderArgument;
        this.getQueueConnection = getQueueConnection;
        this.acknowledgementMode = acknowledgementMode;
        this.getQueue = getQueue;
        this.timeoutMillis = timeoutMillis;
        this.status = Status.STATUS_UNINITIALISED;
    }

    public Object load(Object key) throws CacheException {
        return this.load(key, null);
    }

    public Object load(Object key, Object argument) throws CacheException {
        Serializable keyAsSerializable = (Serializable)key;
        Serializable effectiveLoaderArgument = this.effectiveLoaderArgument(argument);
        JMSEventMessage jmsEventMessage = new JMSEventMessage(Action.GET, keyAsSerializable, null, this.cache.getName(), effectiveLoaderArgument);
        return this.loadFromJMS(jmsEventMessage);
    }

    protected Object loadFromJMS(JMSEventMessage jmsEventMessage) throws CacheException {
        Serializable value;
        MessageConsumer replyReceiver = null;
        TemporaryQueue temporaryReplyQueue = null;
        try {
            ObjectMessage loadRequest = this.getQueueSession.createObjectMessage((Serializable)((Object)jmsEventMessage));
            temporaryReplyQueue = this.getQueueSession.createTemporaryQueue();
            replyReceiver = this.getQueueSession.createConsumer((Destination)temporaryReplyQueue);
            loadRequest.setJMSReplyTo((Destination)temporaryReplyQueue);
            loadRequest.setIntProperty("cacheManagerUniqueId", JMSUtil.localCacheManagerUid(this.cache));
            this.getQueueSender.send((Message)loadRequest, 1, 9, (long)this.timeoutMillis);
            String initialMessageId = loadRequest.getJMSMessageID();
            ObjectMessage reply = (ObjectMessage)replyReceiver.receive((long)this.timeoutMillis);
            if (reply == null) {
                Object var8_9 = null;
                return var8_9;
            }
            String messageId = reply.getJMSCorrelationID();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Initial ID: " + initialMessageId + ". Reply Correlation ID. " + messageId);
            }
            String responder = reply.getStringProperty("responder");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Responder: " + responder);
            }
            assert (initialMessageId.equals(messageId)) : "The load request received an uncorrelated request. Request ID was " + messageId;
            value = reply.getObject();
        }
        catch (JMSException e) {
            throw new CacheException("Problem loading: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                replyReceiver.close();
                temporaryReplyQueue.delete();
            }
            catch (JMSException e) {
                LOG.log(Level.SEVERE, "Problem closing JMS Resources: " + e.getMessage(), e);
            }
        }
        return value;
    }

    public Map loadAll(Collection keys) throws CacheException {
        return this.loadAll(keys, null);
    }

    public Map loadAll(Collection keys, Object argument) throws CacheException {
        Serializable effectiveLoaderArgument = this.effectiveLoaderArgument(argument);
        ArrayList<Serializable> requestList = new ArrayList<Serializable>();
        for (Object key : keys) {
            Serializable keyAsSerializable = (Serializable)key;
            requestList.add(keyAsSerializable);
        }
        JMSEventMessage jmsEventMessage = new JMSEventMessage(Action.GET, requestList, null, this.cache.getName(), effectiveLoaderArgument);
        Map responseMap = (Map)this.loadFromJMS(jmsEventMessage);
        return responseMap;
    }

    private Serializable effectiveLoaderArgument(Object argument) {
        Object effectiveLoaderArgument = argument == null ? this.defaultLoaderArgument : (Serializable)argument;
        return effectiveLoaderArgument;
    }

    public String getName() {
        return "JMSCacheLoader with default loaderArgument: " + this.defaultLoaderArgument;
    }

    public CacheLoader clone(Ehcache cache) throws CloneNotSupportedException {
        throw new CloneNotSupportedException("not supported");
    }

    public void init() {
        try {
            this.getQueueConnection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException e) {
                    LOG.log(Level.SEVERE, "Exception on getQueue Connection: " + e.getMessage(), e);
                }
            });
            this.getQueueSession = this.getQueueConnection.createQueueSession(false, this.acknowledgementMode.toInt());
            this.getQueueSender = this.getQueueSession.createSender(this.getQueue);
            this.getQueueConnection.start();
            this.status = Status.STATUS_ALIVE;
        }
        catch (JMSException e) {
            throw new CacheException("Exception while creating JMS connections: " + e.getMessage(), (Throwable)e);
        }
    }

    public void dispose() throws CacheException {
        try {
            this.getQueueConnection.stop();
            this.getQueueSession.close();
            this.getQueueSender.close();
            this.getQueueConnection.close();
        }
        catch (JMSException e) {
            throw new CacheException("Problem stopping queue connection: " + e.getMessage(), (Throwable)e);
        }
        this.status = Status.STATUS_SHUTDOWN;
    }

    public Status getStatus() {
        return this.status;
    }
}

