/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.openjpa.datacache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.openjpa.datacache.AbstractDataCache;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCachePCData;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.util.OpenJPAId;

public class EhCacheDataCache
extends AbstractDataCache
implements DataCache {
    protected static final Localizer LOCALIZER = Localizer.forPackage(EhCacheDataCache.class);
    protected final Map<Class, Ehcache> caches = new HashMap<Class, Ehcache>();
    protected boolean useDefaultForUnnamedCaches;
    protected String defaultName = "openjpa";
    protected ReentrantLock writeLock = new ReentrantLock();

    public boolean isUseDefaultForUnnamedCaches() {
        return this.useDefaultForUnnamedCaches;
    }

    public void setUseDefaultForUnnamedCaches(boolean flag) {
        this.useDefaultForUnnamedCaches = flag;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String defaultName) {
        this.defaultName = defaultName;
    }

    protected void clearInternal() {
        for (Ehcache cache : this.caches.values()) {
            cache.removeAll();
        }
    }

    protected DataCachePCData getInternal(Object oid) {
        Element result = null;
        if (oid instanceof OpenJPAId) {
            Class cls = ((OpenJPAId)oid).getType();
            Ehcache cache = this.findCache(cls);
            if (cache == null) {
                return null;
            }
            result = cache.get(oid);
        } else {
            Ehcache cache;
            Iterator<Ehcache> i$ = this.caches.values().iterator();
            while (i$.hasNext() && (result = (cache = i$.next()).get(oid)) == null) {
            }
        }
        if (result == null) {
            return null;
        }
        return (DataCachePCData)result.getObjectValue();
    }

    protected boolean pinInternal(Object oid) {
        return false;
    }

    protected DataCachePCData putInternal(Object oid, DataCachePCData pc) {
        Ehcache cache = this.findCache(pc.getType());
        if (cache != null) {
            cache.put(new Element(oid, (Object)pc));
        }
        return pc;
    }

    protected void removeAllInternal(Class cls, boolean subclasses) {
        for (Map.Entry<Class, Ehcache> entry : this.caches.entrySet()) {
            if (subclasses) {
                if (!cls.isAssignableFrom(entry.getKey())) continue;
                entry.getValue().removeAll();
                continue;
            }
            if (entry.getKey() != cls) continue;
            entry.getValue().removeAll();
        }
    }

    protected DataCachePCData removeInternal(Object oid) {
        DataCachePCData result = this.getInternal(oid);
        Class cls = this.determineClassFromObjectId(oid);
        if (this.caches.containsKey(cls)) {
            this.caches.get(cls).remove(oid);
        }
        return result;
    }

    protected boolean unpinInternal(Object oid) {
        return false;
    }

    public void writeLock() {
        this.writeLock.lock();
    }

    public void writeUnlock() {
        this.writeLock.unlock();
    }

    protected Ehcache findCache(Class clazz) {
        Ehcache cache = this.caches.get(clazz);
        if (cache == null) {
            ClassMetaData meta = this.conf.getMetaDataRepositoryInstance().getCachedMetaData(clazz);
            String name = null;
            if (meta != null) {
                name = meta.getDataCacheName();
            }
            if ((name == null || "default".equals(name)) && !this.isUseDefaultForUnnamedCaches()) {
                name = clazz.getName();
            } else if (this.isUseDefaultForUnnamedCaches()) {
                name = this.getDefaultName();
            }
            cache = CacheManager.getInstance().getEhcache(name);
            if (cache == null) {
                cache = this.getOrCreateCache(name);
            }
            this.caches.put(clazz, cache);
        }
        return cache;
    }

    protected synchronized Ehcache getOrCreateCache(String name) {
        CacheManager cacheManager = CacheManager.getInstance();
        Ehcache ehCache = cacheManager.getEhcache(name);
        if (ehCache == null) {
            cacheManager.addCache(name);
            ehCache = cacheManager.getEhcache(name);
        }
        return ehCache;
    }

    protected Class determineClassFromObjectId(Object oid) {
        if (oid instanceof OpenJPAId) {
            return ((OpenJPAId)oid).getType();
        }
        return null;
    }
}

