/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.terracotta;

import com.tc.object.bytecode.ManagerUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.TerracottaConfigConfiguration;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreFactory;
import net.sf.ehcache.terracotta.AppLevelTIMLoader;
import net.sf.ehcache.terracotta.L1Loader;
import net.sf.ehcache.terracotta.StandaloneL1Boot;
import org.terracotta.agent.loader.Handler;
import org.terracotta.agent.loader.Jar;
import org.terracotta.agent.loader.JarManager;
import org.terracotta.agent.loader.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneTerracottaStoreFactory
implements StoreFactory {
    private static final String SIGAR_LIB_PATH_PROPERTY_NAME = "org.hyperic.sigar.path";
    private static String computedBaseLibraryName;
    private final JarManager jarManager = new JarManager();
    private final StoreFactory realFactory;

    public StandaloneTerracottaStoreFactory(TerracottaConfigConfiguration terracottaConfig) {
        StandaloneTerracottaStoreFactory.testForBootJar();
        System.setProperty("tc.active", "true");
        System.setProperty("tc.dso.globalmode", "false");
        URL source = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        URL bootJarUrl = null;
        List<Jar> l1Jars = Collections.synchronizedList(new ArrayList());
        List<Jar> timJars = Collections.synchronizedList(new ArrayList());
        ConcurrentHashMap<String, URL> virtualTimJars = new ConcurrentHashMap<String, URL>();
        ZipInputStream standaloneJar = null;
        try {
            File sigarTmpDir = StandaloneTerracottaStoreFactory.createTempDir("tmpSigarJars");
            standaloneJar = new ZipInputStream(source.openStream());
            ZipEntry entry = standaloneJar.getNextEntry();
            while (entry != null) {
                if (entry.getName().startsWith("L1") && entry.getName().endsWith(".jar")) {
                    URL l1Jar = new URL("jar:" + source.toExternalForm() + "!/" + entry.getName());
                    l1Jars.add(this.jarManager.getOrCreate(l1Jar.toExternalForm(), l1Jar));
                } else if (entry.getName().startsWith("TIMs") && entry.getName().endsWith(".jar")) {
                    String baseJar = StandaloneTerracottaStoreFactory.baseName(entry);
                    URL timJarUrl = new URL("jar:" + source.toExternalForm() + "!/" + entry.getName());
                    Jar timJar = this.jarManager.getOrCreate(timJarUrl.toExternalForm(), timJarUrl);
                    timJars.add(timJar);
                    virtualTimJars.put(baseJar, this.newTcJarUrl(timJarUrl));
                } else if (entry.getName().equals("dso-boot.jar")) {
                    bootJarUrl = new URL("jar:" + source.toExternalForm() + "!/" + entry.getName());
                    this.jarManager.getOrCreate(bootJarUrl.toExternalForm(), bootJarUrl);
                } else if (entry.getName().equals("exported-classes.jar")) {
                    URL exports = new URL("jar:" + source.toExternalForm() + "!/" + entry.getName());
                    timJars.add(this.jarManager.getOrCreate(exports.toExternalForm(), exports));
                }
                if (entry.getName().toLowerCase().contains("sigar")) {
                    StandaloneTerracottaStoreFactory.handleSigarZipEntry(standaloneJar, entry, sigarTmpDir);
                }
                entry = standaloneJar.getNextEntry();
            }
            System.setProperty(SIGAR_LIB_PATH_PROPERTY_NAME, sigarTmpDir.getAbsolutePath());
        }
        catch (IOException ioe) {
            throw new CacheException((Throwable)ioe);
        }
        finally {
            if (standaloneJar != null) {
                try {
                    standaloneJar.close();
                }
                catch (IOException ioe) {}
            }
        }
        boolean isURLConfig = terracottaConfig.isUrlConfig();
        String tcConfig = null;
        tcConfig = isURLConfig ? terracottaConfig.getUrl() : terracottaConfig.getEmbeddedConfig();
        String[] timsToLoad = new String[]{"tim-ehcache-1.7"};
        URLClassLoader bootJarLoader = new URLClassLoader(new URL[]{this.newTcJarUrl(bootJarUrl)}, null);
        ClassLoader newL1Loader = this.newL1Loader(l1Jars, bootJarLoader);
        AppLevelTIMLoader appLevelTimLoader = new AppLevelTIMLoader(this.toURLs(timJars), (ClassLoader)bootJarLoader, this.getClass().getClassLoader());
        try {
            Class<?> boot = newL1Loader.loadClass(StandaloneL1Boot.class.getName());
            Constructor<?> cstr = boot.getConstructor(String[].class, Map.class, String.class, Boolean.TYPE, ClassLoader.class);
            Callable call = (Callable)cstr.newInstance(timsToLoad, virtualTimJars, tcConfig, isURLConfig, appLevelTimLoader);
            ClassFileTransformer dsoContext = (ClassFileTransformer)call.call();
            appLevelTimLoader.setTransformer(dsoContext);
            Class<?> factoryClass = appLevelTimLoader.loadClass("org.terracotta.modules.ehcache.store.TerracottaStoreFactory");
            Constructor<?> factoryClassConstructor = factoryClass.getConstructor(TerracottaConfigConfiguration.class);
            this.realFactory = (StoreFactory)factoryClassConstructor.newInstance(terracottaConfig);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static void handleSigarZipEntry(ZipInputStream agentJar, ZipEntry entry, File sigarTmpDir) throws IOException {
        if (entry.getName().contains(StandaloneTerracottaStoreFactory.baseLibraryName())) {
            StandaloneTerracottaStoreFactory.extractSigarZipEntry(agentJar, entry, sigarTmpDir);
        }
    }

    private static void extractSigarZipEntry(ZipInputStream jar, ZipEntry entry, File outputDir) throws IOException {
        byte[] content = StandaloneTerracottaStoreFactory.getCurrentZipEntry(jar);
        String outName = StandaloneTerracottaStoreFactory.baseName(entry);
        File outFile = new File(outputDir, outName);
        StandaloneTerracottaStoreFactory.writeFile(outFile, content);
        outFile.deleteOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(File file, byte[] contents) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(contents);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static byte[] getCurrentZipEntry(ZipInputStream zis) throws IOException {
        int n;
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((n = zis.read(buf, 0, 1024)) > -1) {
            bout.write(buf, 0, n);
        }
        bout.close();
        return bout.toByteArray();
    }

    private static File createTempDir(String prefix) throws IOException {
        File tempDir = File.createTempFile(prefix, Long.toString(System.nanoTime()));
        if (!tempDir.delete()) {
            throw new IOException("Could not delete temp file: " + tempDir.getAbsolutePath());
        }
        if (!tempDir.mkdir()) {
            throw new IOException("Could not create temp directory: " + tempDir.getAbsolutePath());
        }
        tempDir.deleteOnExit();
        return tempDir;
    }

    public Store create(Ehcache cache) {
        return this.realFactory.create(cache);
    }

    private static void testForBootJar() {
        try {
            Class<?> c = Class.forName(ManagerUtil.class.getName());
            if (c.getClassLoader() == null) {
                throw new CacheException("The Terracotta dso-boot.jar is specified via -Xbootclasspath. This is not a correct configuration, please remove it");
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private ClassLoader newL1Loader(List<Jar> l1Jars, ClassLoader bootJarLoader) {
        HashMap<String, byte[]> extraClasses = new HashMap<String, byte[]>();
        extraClasses.put(StandaloneL1Boot.class.getName(), this.getBootClassBytes());
        L1Loader loader = new L1Loader(this.toURLs(l1Jars), bootJarLoader, extraClasses);
        return loader;
    }

    private URL[] toURLs(List<Jar> jars) {
        Jar[] jarArray = jars.toArray(new Jar[0]);
        URL[] urls = new URL[jarArray.length];
        for (int i = 0; i < jarArray.length; ++i) {
            urls[i] = this.newTcJarUrl(jarArray[i].getSource());
        }
        return urls;
    }

    private byte[] getBootClassBytes() {
        ClassLoader loader = this.getClass().getClassLoader();
        String res = StandaloneL1Boot.class.getName().replace('.', '/').concat(".class");
        try {
            return Util.extract(loader.getResourceAsStream(res));
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static String baseName(ZipEntry entry) {
        return new File(entry.getName()).getName();
    }

    private URL newTcJarUrl(URL embedded) {
        try {
            return new URL("tcjar", "", -1, "__TC__" + embedded.toExternalForm() + "__TC__" + "/", new Handler(this.jarManager));
        }
        catch (MalformedURLException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static String baseLibraryName() {
        if (computedBaseLibraryName != null) {
            return computedBaseLibraryName;
        }
        String name = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        String version = System.getProperty("os.version");
        String majorVersion = version.substring(0, 1);
        StringBuffer buf = new StringBuffer();
        if (arch.endsWith("86")) {
            arch = "x86";
        }
        if (name.equals("Linux")) {
            buf.append(arch).append("-linux");
        } else if (name.indexOf("Windows") > -1) {
            buf.append(arch).append("-winnt");
        } else if (name.equals("SunOS")) {
            if (arch.startsWith("sparcv") && "64".equals(System.getProperty("sun.arch.data.model"))) {
                arch = "sparc64";
            }
            buf.append(arch).append("-solaris");
        } else if (name.equals("HP-UX")) {
            arch = arch.startsWith("IA64") ? "ia64" : "pa";
            if (version.indexOf("11") > -1) {
                buf.append(arch).append("-hpux-11");
            }
        } else if (name.equals("AIX")) {
            buf.append("ppc-aix-").append(majorVersion);
        } else if (name.equals("Mac OS X")) {
            buf.append("universal-macosx");
        } else if (name.equals("FreeBSD")) {
            buf.append(arch).append("-freebsd-").append(majorVersion);
        } else if (name.equals("OpenBSD")) {
            buf.append(arch).append("-openbsd-").append(majorVersion);
        } else if (name.equals("NetBSD")) {
            buf.append(arch).append("-netbsd-").append(majorVersion);
        } else if (name.equals("OSF1")) {
            buf.append("alpha-osf1-").append(majorVersion);
        } else if (name.equals("NetWare")) {
            buf.append("x86-netware-").append(majorVersion);
        }
        if (buf.length() == 0) {
            return null;
        }
        String prefix = "libsigar-";
        if (name.startsWith("Windows")) {
            prefix = "sigar-";
        }
        computedBaseLibraryName = prefix + buf.toString();
        return computedBaseLibraryName;
    }
}

