/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveController;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveException;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveStatistics;
import org.terracotta.agent.repkg.de.schlichtherle.io.ChainableIOException;
import org.terracotta.agent.repkg.de.schlichtherle.io.CountingOutputStream;
import org.terracotta.agent.repkg.de.schlichtherle.io.CountingReadOnlyFile;
import org.terracotta.agent.repkg.de.schlichtherle.io.File;
import org.terracotta.agent.repkg.de.schlichtherle.io.Files;
import org.terracotta.agent.repkg.de.schlichtherle.io.UpdatingArchiveController;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.ArchiveDriver;
import org.terracotta.agent.repkg.de.schlichtherle.key.PromptingKeyManager;

final class ArchiveControllers {
    private static final String CLASS_NAME = "de/schlichtherle/io/ArchiveControllers".replace('/', '.');
    private static final Logger logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    private static final Map controllers = new WeakHashMap();
    private static final Comparator REVERSE_CONTROLLERS = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((ArchiveController)o2).getTarget().compareTo(((ArchiveController)o1).getTarget());
        }
    };

    private ArchiveControllers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static ArchiveController get(File file) {
        boolean reconfigure;
        ArchiveController controller;
        ArchiveDriver driver;
        java.io.File target;
        block28: {
            Object value;
            block27: {
                assert (file != null);
                assert (file.isArchive());
                target = file.getDelegate();
                try {
                    target = target.getCanonicalFile();
                }
                catch (IOException failure) {
                    target = Files.normalize(target.getAbsoluteFile());
                }
                driver = file.getArchiveDetector().getArchiveDriver(target.getPath());
                controller = null;
                reconfigure = false;
                Map map = controllers;
                // MONITORENTER : map
                value = controllers.get(target);
                if (!(value instanceof Reference)) break block27;
                controller = (ArchiveController)((Reference)value).get();
                if (controller == null) break block28;
                reconfigure = controller.getDriver() != driver;
                ArchiveController archiveController = controller;
                // MONITOREXIT : map
                if (!reconfigure) return archiveController;
                controller.writeLock().lock();
                try {
                    controller.setDriver(driver);
                    return archiveController;
                }
                finally {
                    controller.writeLock().unlock();
                }
            }
            if (value != null) {
                ArchiveController archiveController = (ArchiveController)value;
                // MONITOREXIT : map
                if (!reconfigure) return archiveController;
                controller.writeLock().lock();
                try {
                    controller.setDriver(driver);
                    return archiveController;
                }
                finally {
                    controller.writeLock().unlock();
                }
            }
        }
        try {
            String enclEntryName;
            ArchiveController enclController;
            File enclArchive = file.getEnclArchive();
            if (enclArchive != null) {
                enclController = enclArchive.getArchiveController();
                enclEntryName = file.getEnclEntryName();
            } else {
                enclController = null;
                enclEntryName = null;
            }
            controller = new UpdatingArchiveController(target, enclController, enclEntryName, driver);
            // MONITOREXIT : map
            return controller;
        }
        finally {
            if (reconfigure) {
                controller.writeLock().lock();
                try {
                    controller.setDriver(driver);
                }
                finally {
                    controller.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void set(java.io.File target, Object controller) {
        assert (target != null);
        assert (!(target instanceof File));
        assert (controller instanceof ArchiveController || ((WeakReference)controller).get() instanceof ArchiveController);
        Map map = controllers;
        synchronized (map) {
            controllers.put(target, controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void umount(String prefix, boolean waitInputStreams, boolean closeInputStreams, boolean waitOutputStreams, boolean closeOutputStreams, boolean umount) throws ArchiveException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (!closeInputStreams && closeOutputStreams) {
            throw new IllegalArgumentException();
        }
        int controllersTotal = 0;
        int controllersTouched = 0;
        logger.log(Level.FINE, "update.entering", new Object[]{prefix, waitInputStreams, closeInputStreams, waitOutputStreams, closeOutputStreams, umount});
        try {
            CountingReadOnlyFile.init();
            CountingOutputStream.init();
            try {
                ChainableIOException exceptionChain = null;
                ControllerEnumeration e = new ControllerEnumeration(prefix, REVERSE_CONTROLLERS);
                while (e.hasMoreElements()) {
                    ArchiveController controller = (ArchiveController)e.nextElement();
                    controller.writeLock().lock();
                    try {
                        if (controller.isTouched()) {
                            ++controllersTouched;
                        }
                        try {
                            controller.umount((ArchiveException)exceptionChain, waitInputStreams, closeInputStreams, waitOutputStreams, closeOutputStreams, umount, true);
                        }
                        catch (ArchiveException exception) {
                            exceptionChain = exception;
                        }
                    }
                    finally {
                        controller.writeLock().unlock();
                    }
                    ++controllersTotal;
                }
                if (exceptionChain != null) {
                    throw (ArchiveException)exceptionChain.sortPriority();
                }
            }
            finally {
                CountingReadOnlyFile.resetOnInit();
                CountingOutputStream.resetOnInit();
            }
        }
        catch (ArchiveException failure) {
            logger.log(Level.FINE, "update.throwing", failure);
            throw failure;
        }
        logger.log(Level.FINE, "update.exiting", new Object[]{new Integer(controllersTotal), new Integer(controllersTouched)});
    }

    static final ArchiveStatistics getLiveArchiveStatistics() {
        return LiveArchiveStatistics.SINGLETON;
    }

    static {
        Runtime.getRuntime().addShutdownHook(ShutdownHook.SINGLETON);
    }

    private static final class ControllerEnumeration
    implements Enumeration {
        private final Iterator it;

        ControllerEnumeration() {
            this("", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ControllerEnumeration(String prefix, Comparator c) {
            AbstractSet snapshot;
            assert (prefix != null);
            Map map = controllers;
            synchronized (map) {
                snapshot = c != null ? new TreeSet(c) : new HashSet((int)((float)controllers.size() / 0.75f));
                for (Object value : controllers.values()) {
                    if (value instanceof Reference && (value = ((Reference)value).get()) == null) continue;
                    assert (value != null);
                    assert (value instanceof ArchiveController);
                    if (!((ArchiveController)value).getPath().startsWith(prefix)) continue;
                    snapshot.add(value);
                }
            }
            this.it = snapshot.iterator();
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }
    }

    private static final class LiveArchiveStatistics
    implements ArchiveStatistics {
        private static final LiveArchiveStatistics SINGLETON = new LiveArchiveStatistics();

        private LiveArchiveStatistics() {
        }

        public long getUpdateTotalByteCountRead() {
            return CountingReadOnlyFile.getTotal();
        }

        public long getUpdateTotalByteCountWritten() {
            return CountingOutputStream.getTotal();
        }

        public int getArchivesTotal() {
            return controllers.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getArchivesTouched() {
            int result = 0;
            ControllerEnumeration e = new ControllerEnumeration();
            while (e.hasMoreElements()) {
                ArchiveController c = (ArchiveController)e.nextElement();
                c.readLock().lock();
                try {
                    if (!c.isTouched()) continue;
                    ++result;
                }
                finally {
                    c.readLock().unlock();
                }
            }
            return result;
        }

        public int getTopLevelArchivesTotal() {
            int result = 0;
            ControllerEnumeration e = new ControllerEnumeration();
            while (e.hasMoreElements()) {
                ArchiveController c = (ArchiveController)e.nextElement();
                if (c.getEnclController() != null) continue;
                ++result;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getTopLevelArchivesTouched() {
            int result = 0;
            ControllerEnumeration e = new ControllerEnumeration();
            while (e.hasMoreElements()) {
                ArchiveController c = (ArchiveController)e.nextElement();
                c.readLock().lock();
                try {
                    if (c.getEnclController() != null || !c.isTouched()) continue;
                    ++result;
                }
                finally {
                    c.readLock().unlock();
                }
            }
            return result;
        }
    }

    static final class ShutdownHook
    extends Thread {
        private static final ShutdownHook SINGLETON = new ShutdownHook();
        static final Set deleteOnExit = Collections.synchronizedSet(new LinkedHashSet());

        private ShutdownHook() {
            super("TrueZIP ArchiveController Shutdown Hook");
            this.setPriority(10);
            PromptingKeyManager.getInstance();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Class<PromptingKeyManager> clazz = PromptingKeyManager.class;
            synchronized (PromptingKeyManager.class) {
                try {
                    PromptingKeyManager.setPrompting(false);
                    logger.setLevel(Level.OFF);
                    for (File file : deleteOnExit) {
                        if (!file.exists() || file.delete()) continue;
                        System.err.println(file.getPath() + ": failed to deleteOnExit()!");
                    }
                }
                finally {
                    try {
                        ArchiveControllers.umount("", false, true, false, true, true);
                    }
                    catch (ArchiveException ouch) {
                        ouch.printStackTrace();
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

