/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveEntryStreamClosedException;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveException;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveWarningException;
import org.terracotta.agent.repkg.de.schlichtherle.io.File;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.Archive;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.ArchiveEntry;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.OutputArchive;
import org.terracotta.agent.repkg.de.schlichtherle.io.util.SynchronizedOutputStream;

public final class OutputArchiveMetaData {
    private static final String CLASS_NAME = "de/schlichtherle/io/OutputArchiveMetaData".replace('/', '.');
    private static final Logger logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    private final Archive archive;
    private final OutputArchive outArchive;
    private final Map streams;
    private volatile boolean stopped;

    OutputArchiveMetaData(Archive archive, OutputArchive outArchive) {
        AbstractMap abstractMap = this.streams = File.isLenient() ? new WeakHashMap() : new HashMap();
        assert (outArchive != null);
        this.archive = archive;
        this.outArchive = outArchive;
    }

    synchronized OutputStream createOutputStream(ArchiveEntry entry, ArchiveEntry srcEntry) throws IOException {
        assert (!this.stopped);
        assert (entry != null);
        OutputStream out = this.outArchive.getOutputStream(entry, srcEntry);
        return out != null ? new EntryOutputStream(out) : null;
    }

    synchronized int waitAllOutputStreamsByOtherThreads(long timeout) {
        assert (!this.stopped);
        long start = System.currentTimeMillis();
        int threadStreams = this.threadStreams();
        try {
            while (this.streams.size() > threadStreams) {
                long toWait;
                if (timeout > 0L) {
                    toWait = timeout - (System.currentTimeMillis() - start);
                    if (toWait <= 0L) {
                        break;
                    }
                } else {
                    toWait = 0L;
                }
                if (File.isLenient()) {
                    System.gc();
                    System.runFinalization();
                }
                this.wait(toWait);
            }
        }
        catch (InterruptedException ignored) {
            logger.warning("interrupted");
        }
        return this.streams.size();
    }

    private int threadStreams() {
        Thread thisThread = Thread.currentThread();
        int n = 0;
        for (Thread thread : this.streams.values()) {
            if (thisThread != thread) continue;
            ++n;
        }
        return n;
    }

    synchronized ArchiveException closeAllOutputStreams(ArchiveException exceptionChain) {
        assert (!this.stopped);
        this.stopped = true;
        for (EntryOutputStream out : this.streams.keySet()) {
            try {
                out.doClose();
            }
            catch (IOException failure) {
                exceptionChain = new ArchiveWarningException(exceptionChain, failure);
            }
        }
        this.streams.clear();
        return exceptionChain;
    }

    private final class EntryOutputStream
    extends SynchronizedOutputStream {
        private boolean closed;

        private EntryOutputStream(OutputStream out) {
            super(out, OutputArchiveMetaData.this);
            assert (out != null);
            OutputArchiveMetaData.this.streams.put(this, Thread.currentThread());
            OutputArchiveMetaData.this.notify();
        }

        private final void ensureNotStopped() throws IOException {
            if (OutputArchiveMetaData.this.stopped) {
                throw new ArchiveEntryStreamClosedException();
            }
        }

        public void write(int b) throws IOException {
            this.ensureNotStopped();
            super.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.ensureNotStopped();
            super.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.ensureNotStopped();
            super.write(b, off, len);
        }

        public void flush() throws IOException {
            this.ensureNotStopped();
            super.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void close() throws IOException {
            assert (OutputArchiveMetaData.this == this.lock);
            OutputArchiveMetaData outputArchiveMetaData = OutputArchiveMetaData.this;
            synchronized (outputArchiveMetaData) {
                if (this.closed) {
                    return;
                }
                try {
                    this.doClose();
                }
                finally {
                    OutputArchiveMetaData.this.streams.remove(this);
                    OutputArchiveMetaData.this.notify();
                }
            }
        }

        protected void doClose() throws IOException {
            assert (!this.closed);
            this.closed = true;
            super.doClose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.closed) {
                    return;
                }
                logger.finer("finalize.open");
                try {
                    this.doClose();
                }
                catch (IOException failure) {
                    logger.log(Level.FINE, "finalize.exception", failure);
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

