/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io.archive.zip;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Icon;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.Archive;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.AbstractArchiveDriver;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.ArchiveEntry;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.InputArchive;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.OutputArchive;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.zip.Zip32Entry;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.zip.Zip32InputArchive;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.zip.Zip32OutputArchive;
import org.terracotta.agent.repkg.de.schlichtherle.io.rof.ReadOnlyFile;

public class Zip32Driver
extends AbstractArchiveDriver {
    private static final long serialVersionUID = -7061546656075796996L;
    static final String TEMP_FILE_PREFIX = "tzp-zip";
    public static final String DEFAULT_CHARSET = "IBM437";
    public static final int DEFAULT_LEVEL = 9;
    private final boolean preambled;
    private final boolean postambled;
    private final int level;

    public Zip32Driver() {
        this(DEFAULT_CHARSET, null, null, false, false, 9);
    }

    public Zip32Driver(String charset) {
        this(charset, null, null, false, false, 9);
    }

    public Zip32Driver(int level) {
        this(DEFAULT_CHARSET, null, null, false, false, level);
    }

    public Zip32Driver(String charset, boolean preambled, boolean postambled, Icon openIcon, Icon closedIcon) {
        this(charset, openIcon, closedIcon, preambled, postambled, 9);
    }

    public Zip32Driver(String charset, Icon openIcon, Icon closedIcon, boolean preambled, boolean postambled, int level) {
        super(charset, openIcon, closedIcon);
        if ((level < 1 || level > 9) && level != -1) {
            throw new IllegalArgumentException();
        }
        this.preambled = preambled;
        this.postambled = postambled;
        this.level = level;
    }

    public final boolean getPreambled() {
        return this.preambled;
    }

    public final boolean getPostambled() {
        return this.postambled;
    }

    public final int getLevel() {
        return this.level;
    }

    public ArchiveEntry createArchiveEntry(Archive archive, String entryName, ArchiveEntry template) throws CharConversionException {
        Zip32Entry entry;
        this.ensureEncodable(entryName);
        if (template != null) {
            if (template instanceof Zip32Entry) {
                entry = new Zip32Entry((Zip32Entry)template);
                entry.setName(entryName);
            } else {
                entry = new Zip32Entry(entryName);
                entry.setTime(template.getTime());
                entry.setSize(template.getSize());
            }
        } else {
            entry = new Zip32Entry(entryName);
        }
        return entry;
    }

    public InputArchive createInputArchive(Archive archive, ReadOnlyFile rof) throws IOException {
        return this.createZip32InputArchive(archive, rof);
    }

    protected Zip32InputArchive createZip32InputArchive(Archive archive, ReadOnlyFile rof) throws IOException {
        return new Zip32InputArchive(rof, this.getCharset(), this.preambled, this.postambled);
    }

    public OutputArchive createOutputArchive(Archive archive, OutputStream out, InputArchive source) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Zip32OutputArchive createZip32OutputArchive(Archive archive, OutputStream out, Zip32InputArchive source) throws IOException {
        return new Zip32OutputArchive(out, this.getCharset(), this.level, source);
    }
}

