/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.unlockedreadsview;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.UnlockedReadsViewHelper;
import net.sf.ehcache.constructs.EhcacheDecoratorAdapter;
import net.sf.ehcache.statistics.LiveCacheStatisticsData;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.TerracottaStore;

public class UnlockedReadsView
extends EhcacheDecoratorAdapter {
    private final String viewName;
    private final TerracottaStore terracottaStore;
    private final LiveCacheStatisticsData liveCacheStatisticsData;

    public UnlockedReadsView(Cache underlyingCache, String incoherentViewName) {
        super((Ehcache)underlyingCache);
        this.viewName = incoherentViewName;
        Store store = new UnlockedReadsViewHelper(underlyingCache).getStore();
        if (!(store instanceof TerracottaStore)) {
            throw new IllegalArgumentException(UnlockedReadsView.class.getName() + " can be used to decorate caches clustered with Terracotta only.");
        }
        this.terracottaStore = (TerracottaStore)store;
        this.liveCacheStatisticsData = (LiveCacheStatisticsData)underlyingCache.getLiveCacheStatistics();
    }

    public String getName() {
        return this.viewName;
    }

    public Element get(Object key) throws IllegalStateException, CacheException {
        if (this.isStatisticsEnabled()) {
            long start = System.currentTimeMillis();
            Element element = this.getFromStoreWithExpiryCheck(key, false, true, true);
            if (element == null) {
                this.liveCacheStatisticsData.cacheMissNotFound();
            }
            long end = System.currentTimeMillis();
            this.liveCacheStatisticsData.addGetTimeMillis(end - start);
            return element;
        }
        return this.getFromStoreWithExpiryCheck(key, false, false, true);
    }

    public Element get(Serializable key) throws IllegalStateException, CacheException {
        return this.get((Object)key);
    }

    public Element getQuiet(Object key) throws IllegalStateException, CacheException {
        return this.getFromStoreWithExpiryCheck(key, true, false, false);
    }

    public Element getQuiet(Serializable key) throws IllegalStateException, CacheException {
        return this.getQuiet((Object)key);
    }

    private Element getFromStoreWithExpiryCheck(Object key, boolean quiet, boolean updateStats, boolean notifyListeners) {
        Element element = null;
        element = quiet ? this.terracottaStore.unlockedGetQuiet(key) : this.terracottaStore.unlockedGet(key);
        if (element != null) {
            if (this.isExpired(element)) {
                if (updateStats) {
                    this.liveCacheStatisticsData.cacheMissExpired();
                }
                element = this.terracottaStore.remove(key);
                if (notifyListeners) {
                    this.getCacheEventNotificationService().notifyElementExpiry(element, false);
                }
                element = null;
            } else {
                if (!quiet) {
                    element.updateAccessStatistics();
                }
                if (updateStats) {
                    this.liveCacheStatisticsData.cacheHitInMemory();
                }
            }
        }
        return element;
    }
}

