/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpDateFormatter {
    private static final Logger LOG = Logger.getLogger(HttpDateFormatter.class.getName());
    private final SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);

    public HttpDateFormatter() {
        this.httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public synchronized String formatHttpDate(Date date) {
        return this.httpDateFormat.format(date);
    }

    public synchronized Date parseDateFromHttpDate(String date) {
        try {
            return this.httpDateFormat.parse(date);
        }
        catch (ParseException e) {
            LOG.log(Level.FINE, "ParseException on date {0}. 1/1/1970 will be returned", date);
            return new Date(0L);
        }
    }
}

