/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web.filter;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.constructs.web.AlreadyGzippedException;
import net.sf.ehcache.constructs.web.HttpDateFormatter;
import net.sf.ehcache.constructs.web.PageInfo;
import net.sf.ehcache.constructs.web.ResponseHeadersNotModifiableException;
import net.sf.ehcache.constructs.web.filter.SimplePageCachingFilter;

public class SimpleCachingHeadersPageCachingFilter
extends SimplePageCachingFilter {
    public static final String NAME = "SimpleCachingHeadersPageCachingFilter";
    private static final Logger LOG = Logger.getLogger(SimpleCachingHeadersPageCachingFilter.class.getName());
    private static final long ONE_YEAR_IN_MILLISECONDS = 31536000000L;
    private static final int MILLISECONDS_PER_SECOND = 1000;

    protected PageInfo buildPage(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws AlreadyGzippedException, Exception {
        PageInfo pageInfo = super.buildPage(request, response, chain);
        Date now = new Date();
        List headers = pageInfo.getResponseHeaders();
        HttpDateFormatter httpDateFormatter = new HttpDateFormatter();
        String lastModified = httpDateFormatter.formatHttpDate(pageInfo.getCreated());
        long ttlMilliseconds = this.calculateTimeToLiveMilliseconds();
        headers.add(new String[]{"Last-Modified", lastModified});
        headers.add(new String[]{"Expires", httpDateFormatter.formatHttpDate(new Date(now.getTime() + ttlMilliseconds))});
        headers.add(new String[]{"Cache-Control", "max-age=" + ttlMilliseconds / 1000L});
        headers.add(new String[]{"ETag", this.generateEtag(ttlMilliseconds)});
        return pageInfo;
    }

    private String generateEtag(long ttlMilliseconds) {
        StringBuffer stringBuffer = new StringBuffer();
        Long eTagRaw = System.currentTimeMillis() + ttlMilliseconds;
        String eTag = stringBuffer.append("\"").append(eTagRaw).append("\"").toString();
        return eTag;
    }

    protected void writeResponse(HttpServletRequest request, HttpServletResponse response, PageInfo pageInfo) throws IOException, DataFormatException, ResponseHeadersNotModifiableException {
        HttpDateFormatter httpDateFormatter = new HttpDateFormatter();
        List responseHeaders = pageInfo.getResponseHeaders();
        boolean header = false;
        boolean value = true;
        for (Object header1 : responseHeaders) {
            String requestIfModifiedSince;
            String[] headerPair = (String[])header1;
            if (headerPair[0].equals("ETag")) {
                String requestIfNoneMatch = request.getHeader("If-None-Match");
                if (!headerPair[1].equals(requestIfNoneMatch)) break;
                response.sendError(304);
                return;
            }
            if (!headerPair[0].equals("Last-Modified") || (requestIfModifiedSince = request.getHeader("If-Modified-Since")) == null) continue;
            Date requestDate = httpDateFormatter.parseDateFromHttpDate(requestIfModifiedSince);
            Date pageInfoDate = httpDateFormatter.parseDateFromHttpDate(headerPair[1]);
            if (requestDate.getTime() < pageInfoDate.getTime()) continue;
            response.sendError(304);
            response.setHeader("Last-Modified", request.getHeader("If-Modified-Since"));
            return;
        }
        super.writeResponse(request, response, pageInfo);
    }

    protected long calculateTimeToLiveMilliseconds() {
        if (this.blockingCache.isDisabled()) {
            return -1L;
        }
        CacheConfiguration cacheConfiguration = this.blockingCache.getCacheConfiguration();
        if (cacheConfiguration.isEternal()) {
            return 31536000000L;
        }
        return cacheConfiguration.getTimeToLiveSeconds() * 1000L;
    }

    private Date createLastModified(Element ehcacheElement) {
        long lastModified = ehcacheElement.getCreationTime();
        Date lastModifiedDate = new Date(lastModified);
        LOG.log(Level.FINE, "lastModified as long: {}", lastModified);
        LOG.log(Level.FINE, "lastModified as Date without ms: {}", lastModifiedDate);
        return lastModifiedDate;
    }

    private String createETag(Element ehcacheElement) {
        long eTagNumber = ehcacheElement.getCreationTime();
        return new StringBuffer().append(eTagNumber).toString();
    }
}

